/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import knightminer.inspirations.common.ClientProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.recipes.InspirationsRecipes;
import knightminer.inspirations.recipes.block.BlockEnhancedCauldron;
import knightminer.inspirations.recipes.tileentity.TileCauldron;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RecipesClientProxy
extends ClientProxy {
    private static final ResourceLocation POTION_MODEL = new ResourceLocation("bottle_drinkable");
    public static final ResourceLocation CAULDRON_MODEL = Util.getResource("cauldron");

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        RecipesClientProxy.setModelStateMapper((Block)InspirationsRecipes.cauldron, (IStateMapper)new CauldronStateMapper(CAULDRON_MODEL));
        RecipesClientProxy.registerItemModel((Item)InspirationsRecipes.potatoSoupItem);
        if (Config.enableCauldronDyeing) {
            RecipesClientProxy.registerItemModel((Item)InspirationsRecipes.dyedWaterBottle, POTION_MODEL);
        }
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        RecipesClientProxy.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            TileEntity te;
            if (tintIndex == 1 && (te = world.func_175625_s(pos)) instanceof TileCauldron) {
                return ((TileCauldron)te).getColor();
            }
            return -1;
        }, new Block[]{InspirationsRecipes.cauldron});
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        RecipesClientProxy.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex == 0) {
                return InspirationsRecipes.dyedWaterBottle.getColor(stack);
            }
            return -1;
        }, InspirationsRecipes.dyedWaterBottle);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        if (InspirationsRecipes.cauldron == null) {
            return;
        }
        boolean boiling = false;
        do {
            int i;
            RecipesClientProxy.replaceTexturedModel(event, new ModelResourceLocation(CAULDRON_MODEL, String.format("boiling=%s,contents=fluid,level=empty", boiling)), "water", false);
            int n = i = Config.enableBiggerCauldron ? 0 : 1;
            while (i <= 3) {
                RecipesClientProxy.replaceTexturedModel(event, new ModelResourceLocation(CAULDRON_MODEL, String.format("boiling=%s,contents=fluid,level=%s", boiling, i)), "water", false);
                ++i;
            }
        } while (boiling = !boiling);
    }

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent.Pre event) {
        TextureMap map = event.getMap();
        RecipesClientProxy.registerFluidTexture(map, InspirationsRecipes.milk);
    }

    public static class CauldronStateMapper
    extends StateMapperBase {
        private static final PropertyEnum<CauldronLevel> LEVEL = PropertyEnum.func_177709_a((String)"level", CauldronLevel.class);
        private ResourceLocation location;

        public CauldronStateMapper(ResourceLocation location) {
            this.location = location;
        }

        @Nonnull
        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
            if (Config.enableBiggerCauldron) {
                map.put(LEVEL, CauldronLevel.forLevel((Integer)state.func_177229_b((IProperty)BlockEnhancedCauldron.LEVELS)));
                map.remove(BlockCauldron.field_176591_a);
                map.remove(BlockEnhancedCauldron.LEVELS);
            } else {
                map.put(LEVEL, CauldronLevel.forLevel((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a)));
                map.remove(BlockCauldron.field_176591_a);
            }
            return new ModelResourceLocation(this.location, this.func_178131_a(map));
        }

        private static enum CauldronLevel implements IStringSerializable
        {
            EMPTY,
            LEVEL0,
            LEVEL1,
            LEVEL2,
            LEVEL3;


            public static CauldronLevel forLevel(int level) {
                if (level < 0 || level > 4) {
                    level = 0;
                }
                if (!Config.enableBiggerCauldron && level != 0) {
                    ++level;
                }
                return CauldronLevel.values()[level];
            }

            public String func_176610_l() {
                if (this == EMPTY) {
                    return "empty";
                }
                return "" + (this.ordinal() - 1);
            }
        }
    }
}

