/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.tileentity;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.Util;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import knightminer.inspirations.recipes.block.BlockEnhancedCauldron;
import knightminer.inspirations.recipes.tank.CauldronTank;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileCauldron
extends TileEntity {
    public static final DamageSource DAMAGE_BOIL = new DamageSource(Util.prefix("boiling")).func_76348_h();
    private ICauldronRecipe.CauldronState state = ICauldronRecipe.CauldronState.WATER;
    private CauldronTank tank = new CauldronTank(this);
    private static final String TAG_CAULDRON_CRAFTED = "cauldron_crafted";
    private static final String TAG_CAULDRON_COOLDOWN = "cauldron_cooldown";
    public static final String TAG_STATE = "state";

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Nonnull
    public BlockEnhancedCauldron.CauldronContents getContentType() {
        if (this.state.getFluid() != null) {
            return BlockEnhancedCauldron.CauldronContents.FLUID;
        }
        if (this.state.getColor() > -1) {
            return BlockEnhancedCauldron.CauldronContents.DYE;
        }
        if (this.state.getPotion() != null) {
            return BlockEnhancedCauldron.CauldronContents.POTION;
        }
        return BlockEnhancedCauldron.CauldronContents.FLUID;
    }

    public boolean isWater() {
        return this.state.isWater();
    }

    public ICauldronRecipe.CauldronState getState() {
        return this.state;
    }

    public int getColor() {
        switch (this.getContentType()) {
            case DYE: {
                return this.state.getColor();
            }
            case POTION: {
                return PotionUtils.func_185183_a((PotionType)this.state.getPotion());
            }
        }
        Fluid fluid = this.state.getFluid();
        if (fluid != null) {
            return this.state.getFluid().getColor();
        }
        return -1;
    }

    public IBlockState writeExtendedBlockState(IExtendedBlockState state) {
        Fluid fluid;
        if (BlockEnhancedCauldron.getCauldronLevel((IBlockState)state) > 0 && this.state != ICauldronRecipe.CauldronState.WATER && this.getContentType() == BlockEnhancedCauldron.CauldronContents.FLUID && (fluid = this.state.getFluid()) != null) {
            state = state.withProperty((IUnlistedProperty)BlockEnhancedCauldron.TEXTURE, (Object)fluid.getStill().toString());
        }
        return state;
    }

    public static boolean interact(World world, BlockPos pos, IBlockState blockState, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        TileCauldron cauldron = null;
        ICauldronRecipe.CauldronState state = ICauldronRecipe.CauldronState.WATER;
        boolean boiling = false;
        Block block = blockState.func_177230_c();
        if (Config.enableExtendedCauldron && block instanceof BlockEnhancedCauldron) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileCauldron) {
                cauldron = (TileCauldron)te;
                state = cauldron.state;
                boiling = (Boolean)blockState.func_177229_b((IProperty)BlockEnhancedCauldron.BOILING);
            }
        } else {
            state = InspirationsRegistry.getCauldronState(blockState);
            boiling = InspirationsRegistry.isCauldronFire(world.func_180495_p(pos.func_177977_b()));
        }
        int level = BlockEnhancedCauldron.getCauldronLevel(blockState);
        ICauldronRecipe recipe = InspirationsRegistry.getCauldronResult(stack, boiling, level, state);
        if (recipe != null) {
            if (!world.field_72995_K) {
                int newLevel;
                ICauldronRecipe.CauldronState newState = recipe.getState(stack, boiling, level, state);
                if (!Config.enableExtendedCauldron && !ICauldronRecipe.CauldronState.WATER.matches(newState)) {
                    return true;
                }
                SoundEvent sound = recipe.getSound(stack, boiling, level, state);
                if (sound != null) {
                    world.func_184133_a((EntityPlayer)null, pos, sound, SoundCategory.BLOCKS, recipe.getVolume(sound), 1.0f);
                }
                if ((newLevel = recipe.getLevel(level)) != level || !state.matches(newState)) {
                    if (newLevel == InspirationsRegistry.getCauldronMax() && InspirationsRegistry.isNormalCauldron(blockState) && InspirationsRegistry.hasFullCauldron(newState)) {
                        world.func_175656_a(pos, InspirationsRegistry.getFullCauldron(newState));
                        cauldron = null;
                    } else {
                        if (!(block instanceof BlockCauldron)) {
                            TileEntity te;
                            Blocks.field_150383_bp.func_176590_a(world, pos, Blocks.field_150383_bp.func_176223_P(), newLevel);
                            if (Config.enableExtendedCauldron && (te = world.func_175625_s(pos)) instanceof TileCauldron) {
                                cauldron = (TileCauldron)te;
                            }
                        } else {
                            ((BlockCauldron)block).func_176590_a(world, pos, blockState, newLevel);
                        }
                        if (newLevel == 0) {
                            newState = ICauldronRecipe.CauldronState.WATER;
                        }
                    }
                }
                if (cauldron != null) {
                    cauldron.setState(newState, true);
                }
                ItemStack result = recipe.getResult(stack, boiling, level, state);
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack container = recipe.getContainer(stack);
                    int original = stack.func_190916_E();
                    ItemStack transform = recipe.transformInput(stack, boiling, level, state);
                    if (transform.func_190926_b()) {
                        if (!container.func_190926_b()) {
                            container.func_190920_e(container.func_190916_E() * original);
                            player.func_184611_a(hand, container);
                        }
                    } else {
                        player.func_184611_a(hand, transform);
                        if (!container.func_190926_b()) {
                            container.func_190920_e(container.func_190916_E() * (original - transform.func_190916_E()));
                            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)container, (int)player.field_71071_by.field_70461_c);
                        }
                    }
                }
                if (!result.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)result, (int)player.field_71071_by.field_70461_c);
                }
            }
            return true;
        }
        if (state.isWater()) {
            Item item = stack.func_77973_b();
            return state != ICauldronRecipe.CauldronState.WATER && (item == Items.field_151068_bn || item == Items.field_151131_as);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public int onEntityCollide(Entity entity, int level, IBlockState currentState) {
        block22: {
            block21: {
                if (!(entity instanceof EntityItem)) break block21;
                entityItem = (EntityItem)entity;
                entityTags = entity.getEntityData();
                if (entityTags.func_74767_n("cauldron_crafted")) {
                    return level;
                }
                cooldown = entityTags.func_74762_e("cauldron_cooldown");
                if (cooldown > 0) {
                    entityTags.func_74768_a("cauldron_cooldown", cooldown - 1);
                    return level;
                }
                boiling = (Boolean)currentState.func_177229_b((IProperty)BlockEnhancedCauldron.BOILING);
                stack = entityItem.func_92059_d();
                recipe = InspirationsRegistry.getCauldronResult(stack, boiling, level, this.state);
                if (recipe != null) {
                    state = this.state;
                    sound = recipe.getSound(stack, boiling, level, state);
                    if (sound != null) {
                        this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, sound, SoundCategory.BLOCKS, recipe.getVolume(sound), 1.0f);
                    }
                    matches = 0;
                    do {
                        newState = recipe.getState(stack, boiling, level, state);
                        if ((level = recipe.getLevel(level)) == 0) {
                            newState = ICauldronRecipe.CauldronState.WATER;
                        }
                        if (!(result = recipe.getResult(stack, boiling, level, state)).func_190926_b()) {
                            this.spawnItem(result, entityItem);
                        }
                        container = recipe.getContainer(stack);
                        oldCount = stack.func_190916_E();
                        stack = recipe.transformInput(stack, boiling, level, state);
                        if (container.func_190926_b()) continue;
                        container.func_190920_e(container.func_190916_E() * (oldCount - stack.func_190916_E()));
                        this.spawnItem(container, entityItem);
                    } while (recipe.matches(stack, boiling, level, state = newState) && ++matches < 10);
                    if (matches == 10) {
                        Inspirations.log.warn("Recipe '{}' matched too many times in a single tick. Either the level or the state should change to make it no longer match.", (Object)recipe);
                    }
                    if (stack.func_190926_b()) {
                        entityItem.func_70106_y();
                    } else {
                        entityItem.func_92058_a(stack);
                        entityTags.func_74757_a("cauldron_crafted", true);
                    }
                    if (!state.matches(this.state)) {
                        this.state = state;
                        this.field_145850_b.func_184138_a(this.field_174879_c, currentState, currentState, 2);
                    }
                } else {
                    entityTags.func_74768_a("cauldron_cooldown", 60);
                }
                break block22;
            }
            if (level <= 0) break block22;
            switch (1.$SwitchMap$knightminer$inspirations$recipes$block$BlockEnhancedCauldron$CauldronContents[this.getContentType().ordinal()]) {
                case 3: {
                    if (!this.isWater()) ** GOTO lbl54
                    if (entity.func_70027_ad()) {
                        entity.func_70066_B();
                        --level;
                    }
                    ** GOTO lbl60
lbl54:
                    // 1 sources

                    fluid = this.state.getFluid();
                    if (fluid.getTemperature() > 450 && !entity.func_70045_F()) {
                        entity.func_70097_a(DamageSource.field_76371_c, 4.0f);
                        entity.func_70015_d(15);
                        break;
                    }
                }
lbl60:
                // 4 sources

                case 1: {
                    if (!((Boolean)currentState.func_177229_b((IProperty)BlockEnhancedCauldron.BOILING)).booleanValue()) break;
                    entity.func_70097_a(TileCauldron.DAMAGE_BOIL, 2.0f);
                    break;
                }
                case 2: {
                    if (!(entity instanceof EntityLivingBase)) break;
                    living = (EntityLivingBase)entity;
                    effects = this.state.getPotion().func_185170_a();
                    if (!effects.stream().anyMatch((Predicate<PotionEffect>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onEntityCollide$0(net.minecraft.entity.EntityLivingBase net.minecraft.potion.PotionEffect ), (Lnet/minecraft/potion/PotionEffect;)Z)((EntityLivingBase)living))) break;
                    for (PotionEffect effect : effects) {
                        if (effect.func_188419_a().func_76403_b()) {
                            effect.func_188419_a().func_180793_a((Entity)living, (Entity)living, living, effect.func_76458_c(), 1.0);
                            continue;
                        }
                        living.func_70690_d(new PotionEffect(effect));
                    }
                    --level;
                }
            }
        }
        return level;
    }

    private void spawnItem(ItemStack stack, EntityItem base) {
        EntityItem entityItem = new EntityItem(this.field_145850_b, base.field_70165_t, base.field_70163_u, base.field_70161_v, stack);
        entityItem.getEntityData().func_74757_a(TAG_CAULDRON_CRAFTED, true);
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public void onBreak(BlockPos pos, int level) {
        switch (this.getContentType()) {
            case FLUID: {
                Block block = this.state.getFluid().getBlock();
                if (block == null) break;
                if (block == Blocks.field_150355_j) {
                    block = Blocks.field_150358_i;
                } else if (block == Blocks.field_150353_l) {
                    block = Blocks.field_150356_k;
                }
                if (level != (Config.enableBiggerCauldron ? 4 : 3)) break;
                this.field_145850_b.func_175656_a(pos, block.func_176223_P());
                break;
            }
            case POTION: {
                PotionType potion = this.state.getPotion();
                EntityAreaEffectCloud cloud = new EntityAreaEffectCloud(this.field_145850_b, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
                cloud.func_184483_a(0.5f * (float)level + 0.5f);
                cloud.func_184486_b(20 * (level + 1));
                cloud.func_184495_b(-0.5f);
                cloud.func_184485_d(10);
                cloud.func_184487_c(-cloud.func_184490_j() / (float)cloud.func_184489_o());
                cloud.func_184484_a(potion);
                for (PotionEffect effect : potion.func_185170_a()) {
                    cloud.func_184496_a(new PotionEffect(effect));
                }
                this.field_145850_b.func_72838_d((Entity)cloud);
            }
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getFluidLevel() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block instanceof BlockEnhancedCauldron) {
            return ((BlockEnhancedCauldron)block).getLevel(state);
        }
        return 0;
    }

    public void setFluidLevel(int levels) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block instanceof BlockEnhancedCauldron) {
            if (levels == 0) {
                this.state = ICauldronRecipe.CauldronState.WATER;
            }
            ((BlockEnhancedCauldron)block).func_176590_a(this.field_145850_b, this.field_174879_c, state, levels);
        }
    }

    public void setState(ICauldronRecipe.CauldronState newState, boolean doBlockUpdate) {
        if (!this.state.matches(newState)) {
            this.state = newState;
            if (doBlockUpdate) {
                IBlockState blockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, blockstate, blockstate, 2);
            } else {
                this.func_70296_d();
            }
        }
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags = super.func_189515_b(tags);
        tags.func_74782_a(TAG_STATE, (NBTBase)this.state.writeToNBT());
        return tags;
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.state = ICauldronRecipe.CauldronState.fromNBT(tags.func_74775_l(TAG_STATE));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.state.writeToNBT());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        ICauldronRecipe.CauldronState newState = ICauldronRecipe.CauldronState.fromNBT(pkt.func_148857_g());
        if (!this.state.matches(newState)) {
            this.state = newState;
            if (this.field_145850_b.field_72995_K) {
                Minecraft.func_71410_x().field_71438_f.func_184376_a(null, this.field_174879_c, null, null, 0);
            }
        }
    }

    private static /* synthetic */ boolean lambda$onEntityCollide$0(EntityLivingBase living, PotionEffect effect) {
        return !living.func_70644_a(effect.func_188419_a());
    }
}

