/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.block;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFittedCarpet
extends BlockCarpet {
    public static final PropertyBool NORTHWEST = PropertyBool.func_177716_a((String)"northwest");
    public static final PropertyBool NORTHEAST = PropertyBool.func_177716_a((String)"northeast");
    public static final PropertyBool SOUTHWEST = PropertyBool.func_177716_a((String)"southwest");
    public static final PropertyBool SOUTHEAST = PropertyBool.func_177716_a((String)"southeast");
    private static final AxisAlignedBB[] BOUNDS;
    private static final AxisAlignedBB BOUNDS_NW;
    private static final AxisAlignedBB BOUNDS_NE;
    private static final AxisAlignedBB BOUNDS_SW;
    private static final AxisAlignedBB BOUNDS_SE;

    public BlockFittedCarpet() {
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149663_c("woolCarpet");
        this.func_149713_g(0);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)field_176330_a, (Comparable)EnumDyeColor.WHITE).func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTHWEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTHEAST, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176330_a, NORTHWEST, NORTHEAST, SOUTHWEST, SOUTHEAST});
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.setProperties(state, this.getStairShape(world, pos.func_177977_b()));
    }

    @Deprecated
    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getStairShape(world, pos) > 0) {
            return field_185506_k;
        }
        return super.func_180646_a(state, world, pos);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS[this.getStairShape(source, pos.func_177977_b())];
    }

    @Deprecated
    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        int shape = this.getStairShape((IBlockAccess)world, pos.func_177977_b());
        switch (shape) {
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                return super.func_180636_a(state, world, pos, start, end);
            }
        }
        ArrayList<RayTraceResult> list = new ArrayList<RayTraceResult>();
        if ((shape & 8) == 0) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_NW));
        }
        if ((shape & 4) == 0) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_NE));
        }
        if ((shape & 2) == 0) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_SW));
        }
        if ((shape & 1) == 0) {
            list.add(this.func_185503_a(pos, start, end, BOUNDS_SE));
        }
        return Util.closestResult(list, end);
    }

    private int getStairShape(IBlockAccess world, BlockPos pos) {
        IBlockState stairs = world.func_180495_p(pos);
        if (!(stairs.func_177230_c() instanceof BlockStairs) || stairs.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.TOP) {
            return 0;
        }
        stairs = stairs.func_185899_b(world, pos);
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)stairs.func_177229_b((IProperty)BlockStairs.field_176310_M);
        switch ((EnumFacing)stairs.func_177229_b((IProperty)BlockStairs.field_176309_a)) {
            case NORTH: {
                switch (shape) {
                    case STRAIGHT: {
                        return 3;
                    }
                    case INNER_LEFT: {
                        return 1;
                    }
                    case INNER_RIGHT: {
                        return 2;
                    }
                    case OUTER_LEFT: {
                        return 7;
                    }
                    case OUTER_RIGHT: {
                        return 11;
                    }
                }
            }
            case SOUTH: {
                switch (shape) {
                    case STRAIGHT: {
                        return 12;
                    }
                    case INNER_LEFT: {
                        return 8;
                    }
                    case INNER_RIGHT: {
                        return 4;
                    }
                    case OUTER_LEFT: {
                        return 14;
                    }
                    case OUTER_RIGHT: {
                        return 13;
                    }
                }
            }
            case WEST: {
                switch (shape) {
                    case STRAIGHT: {
                        return 5;
                    }
                    case INNER_LEFT: {
                        return 4;
                    }
                    case INNER_RIGHT: {
                        return 1;
                    }
                    case OUTER_LEFT: {
                        return 13;
                    }
                    case OUTER_RIGHT: {
                        return 7;
                    }
                }
            }
            case EAST: {
                switch (shape) {
                    case STRAIGHT: {
                        return 10;
                    }
                    case INNER_LEFT: {
                        return 2;
                    }
                    case INNER_RIGHT: {
                        return 8;
                    }
                    case OUTER_LEFT: {
                        return 11;
                    }
                    case OUTER_RIGHT: {
                        return 14;
                    }
                }
            }
        }
        return 0;
    }

    private IBlockState setProperties(IBlockState state, int i) {
        return state.func_177226_a((IProperty)NORTHWEST, (Comparable)Boolean.valueOf((i & 8) > 0)).func_177226_a((IProperty)NORTHEAST, (Comparable)Boolean.valueOf((i & 4) > 0)).func_177226_a((IProperty)SOUTHWEST, (Comparable)Boolean.valueOf((i & 2) > 0)).func_177226_a((IProperty)SOUTHEAST, (Comparable)Boolean.valueOf((i & 1) > 0));
    }

    static {
        BOUNDS_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 0.0625, 0.5625);
        BOUNDS_NE = new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 0.0625, 0.5625);
        BOUNDS_SW = new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 0.0625, 1.0);
        BOUNDS_SE = new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 0.0625, 1.0);
        BOUNDS = new AxisAlignedBB[]{field_185758_b, field_185758_b, field_185758_b, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.5625), field_185758_b, new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 0.0625, 1.0), field_185758_b, BOUNDS_NW, field_185758_b, field_185758_b, new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 0.0625, 1.0), BOUNDS_NE, new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 0.0625, 1.0), BOUNDS_SW, BOUNDS_SE, field_185758_b};
    }
}

