/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import knightminer.inspirations.library.Util;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;

public class BlockBricksButton
extends EnumBlock<BrickType> {
    public static final PropertyEnum<BrickType> TYPE = PropertyEnum.func_177709_a((String)"type", BrickType.class);
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool POWERED = BlockButton.field_176584_b;
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> BRICK_BUTTON;
    private static final ImmutableMap<EnumFacing, AxisAlignedBB> NETHER_BUTTON;

    public BlockBricksButton() {
        super(Material.field_151576_e, TYPE, BrickType.class);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)BrickType.BRICKS)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, FACING, POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BrickType.fromMeta(meta & 1))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta >> 1))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return ((BrickType)((Object)state.func_177229_b(TYPE))).getMeta() | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 1 | ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0);
    }

    @Deprecated
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public int func_180651_a(IBlockState state) {
        return ((BrickType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, ((BrickType)((Object)state.func_177229_b(TYPE))).getMeta());
    }

    public int func_149738_a(World worldIn) {
        return 20;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!Util.clickedAABB(BlockBricksButton.getButtonBox(state), hitX, hitY, hitZ)) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return true;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        world.func_175704_b(pos, pos);
        world.func_184133_a(player, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
        world.func_175685_c(pos, (Block)this, false);
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
        return true;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
            world.func_175685_c(pos, (Block)this, false);
            world.func_184133_a(null, pos, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
            world.func_175704_b(pos, pos);
        }
    }

    private static AxisAlignedBB getButtonBox(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177229_b(TYPE) == BrickType.BRICKS) {
            return (AxisAlignedBB)BRICK_BUTTON.get((Object)facing);
        }
        return (AxisAlignedBB)NETHER_BUTTON.get((Object)facing);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            world.func_175685_c(pos, (Block)this, false);
        }
        super.func_180663_b(world, pos, state);
    }

    @Deprecated
    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return false;
    }

    static {
        ImmutableMap.Builder bounds = ImmutableMap.builder();
        bounds.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.75, 0.5, 0.0625));
        bounds.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.25, 0.3125, 0.9375, 0.6875, 0.5, 1.0));
        bounds.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.3125, 0.25, 0.0625, 0.5, 0.6875));
        bounds.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.9375, 0.3125, 0.3125, 1.0, 0.5, 0.75));
        BRICK_BUTTON = bounds.build();
        bounds = ImmutableMap.builder();
        bounds.put((Object)EnumFacing.NORTH, (Object)new AxisAlignedBB(0.375, 0.5, 0.0, 0.8125, 0.6875, 0.0625));
        bounds.put((Object)EnumFacing.SOUTH, (Object)new AxisAlignedBB(0.1875, 0.5, 0.9375, 0.625, 0.6875, 1.0));
        bounds.put((Object)EnumFacing.WEST, (Object)new AxisAlignedBB(0.0, 0.5, 0.1875, 0.0625, 0.6875, 0.625));
        bounds.put((Object)EnumFacing.EAST, (Object)new AxisAlignedBB(0.9375, 0.5, 0.375, 1.0, 0.6875, 0.8125));
        NETHER_BUTTON = bounds.build();
    }

    public static enum BrickType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        BRICKS,
        NETHER;

        private int meta = this.ordinal();

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }

        public static BrickType fromMeta(int i) {
            if (i < 0 || i > BrickType.values().length) {
                i = 0;
            }
            return BrickType.values()[i];
        }
    }
}

