/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.dispenser;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DispenseFluidTank
extends BehaviorDefaultDispenseItem {
    private static final BehaviorDefaultDispenseItem DEFAULT = new BehaviorDefaultDispenseItem();
    private IBehaviorDispenseItem fallback;

    public DispenseFluidTank(IBehaviorDispenseItem fallback) {
        this.fallback = fallback;
    }

    protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
        EnumFacing side = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
        BlockPos pos = source.func_180699_d().func_177972_a(side);
        World world = source.func_82618_k();
        IFluidHandler handler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)side.func_176734_d());
        if (handler != null) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            FluidActionResult result = fluid != null ? FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true) : FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true);
            if (result.isSuccess()) {
                SoundEvent sound;
                ItemStack resultStack = result.getResult();
                if (fluid != null) {
                    sound = fluid.getFluid().getEmptySound(fluid);
                } else {
                    FluidStack resultFluid = FluidUtil.getFluidContained((ItemStack)resultStack);
                    sound = resultFluid.getFluid().getFillSound(resultFluid);
                }
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (stack.func_190916_E() == 1) {
                    return resultStack;
                }
                if (!resultStack.func_190926_b() && ((TileEntityDispenser)source.func_150835_j()).func_146019_a(resultStack) < 0) {
                    DEFAULT.func_82482_a(source, resultStack);
                }
                ItemStack shrink = stack.func_77946_l();
                shrink.func_190918_g(1);
                return shrink;
            }
            return DEFAULT.func_82482_a(source, stack);
        }
        return this.fallback.func_82482_a(source, stack);
    }
}

