/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.api;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.mcft.copy.backpacks.api.IBackpackType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class BackpackRegistry {
    private static final List<BackpackEntityEntry> _defaultEntities = new ArrayList<BackpackEntityEntry>();
    private static final List<BackpackEntityEntry> _entities = new ArrayList<BackpackEntityEntry>();
    private static final Map<String, Optional<Class<? extends EntityLivingBase>>> _entityClassLookupCache = new HashMap<String, Optional<Class<? extends EntityLivingBase>>>();
    private static Map<Class<? extends EntityLivingBase>, BackpackEntityEntry> _entityEntryLookupCache = null;

    private BackpackRegistry() {
    }

    public static void registerEntity(String entityID, RenderOptions renderOptions) {
        if (entityID == null) {
            throw new NullPointerException("entityID must not be null");
        }
        if (BackpackRegistry.getDefaultEntityEntry(entityID) != null) {
            throw new IllegalArgumentException("entityID '" + entityID + "' has already been registered");
        }
        if (Loader.instance().getLoaderState().compareTo((Enum)LoaderState.PREINITIALIZATION) > 0) {
            throw new IllegalStateException("Must be called during (or before) pre-initialization phase.");
        }
        _defaultEntities.add(new BackpackEntityEntry(entityID, renderOptions, new ArrayList<BackpackEntry>(), true));
    }

    public static void registerBackpack(String entityID, String entryID, String backpack, int chance, String lootTable, ColorRange colorRange) {
        if (entityID == null) {
            throw new NullPointerException("entityID must not be null");
        }
        if (entryID == null) {
            throw new NullPointerException("entryID must not be null");
        }
        BackpackEntityEntry entityEntry = BackpackRegistry.getDefaultEntityEntry(entityID);
        if (entityEntry == null) {
            new IllegalStateException("entityID '" + entityID + "' has not been registered yet");
        }
        if (entityEntry._backpackEntries.stream().anyMatch(e -> e.id.equals(entryID))) {
            throw new IllegalArgumentException("entryID '" + entryID + "' has already been used for entityID '" + entityID + "'");
        }
        if (Loader.instance().getLoaderState().compareTo((Enum)LoaderState.PREINITIALIZATION) > 0) {
            throw new IllegalStateException("Must be called during (or before) pre-initialization phase.");
        }
        entityEntry._backpackEntries.add(new BackpackEntry(entryID, backpack, chance, lootTable, colorRange, true));
    }

    public static boolean canEntityWearBackpacks(Entity entity) {
        return entity != null && EntityLivingBase.class.isAssignableFrom(entity.getClass()) && BackpackRegistry.getEntityEntry(entity.getClass().asSubclass(EntityLivingBase.class)) != null;
    }

    public static List<BackpackEntityEntry> getEntityEntries() {
        return Collections.unmodifiableList(_entities);
    }

    public static List<BackpackEntityEntry> getDefaultEntityEntries() {
        return Collections.unmodifiableList(_defaultEntities);
    }

    public static BackpackEntityEntry getEntityEntry(String entityID) {
        return _entities.stream().filter(e -> e.entityID.equals(entityID)).findAny().orElse(null);
    }

    public static BackpackEntityEntry getDefaultEntityEntry(String entityID) {
        return _defaultEntities.stream().filter(e -> e.entityID.equals(entityID)).findAny().orElse(null);
    }

    public static BackpackEntityEntry getEntityEntry(Class<? extends EntityLivingBase> entityClass) {
        if (EntityPlayer.class.isAssignableFrom(entityClass)) {
            return BackpackEntityEntry.PLAYER;
        }
        if (_entityEntryLookupCache == null) {
            _entityEntryLookupCache = ForgeRegistries.ENTITIES.getEntries().stream().map(e -> new AbstractMap.SimpleEntry<Class, BackpackEntityEntry>(((EntityEntry)e.getValue()).getEntityClass(), BackpackRegistry.getEntityEntry(((ResourceLocation)e.getKey()).toString()))).filter(e -> EntityLivingBase.class.isAssignableFrom((Class)e.getKey()) && e.getValue() != null).collect(Collectors.toMap(e -> ((Class)e.getKey()).asSubclass(EntityLivingBase.class), Map.Entry::getValue));
        }
        return _entityEntryLookupCache.get(entityClass);
    }

    public static void updateEntityEntries(List<BackpackEntityEntry> value) {
        BackpackRegistry.mergeEntityEntriesWithDefault(_entities, value);
        _entityEntryLookupCache = null;
    }

    public static List<BackpackEntityEntry> mergeEntityEntriesWithDefault(List<BackpackEntityEntry> value) {
        return BackpackRegistry.mergeEntityEntriesWithDefault(new ArrayList<BackpackEntityEntry>(), value);
    }

    public static List<BackpackEntityEntry> mergeEntityEntriesWithDefault(List<BackpackEntityEntry> dest, List<BackpackEntityEntry> value) {
        dest.clear();
        _defaultEntities.stream().map(BackpackEntityEntry::new).forEach(dest::add);
        for (BackpackEntityEntry entityEntry : value) {
            BackpackEntityEntry defaultEntityEntry = dest.stream().filter(e -> e.entityID.equals(entityEntry.entityID)).findAny().orElse(null);
            if (defaultEntityEntry != null) {
                for (BackpackEntry backpackEntry : entityEntry._backpackEntries) {
                    int index = IntStream.range(0, defaultEntityEntry._backpackEntries.size()).filter(i -> ((BackpackEntry)((BackpackEntityEntry)defaultEntityEntry)._backpackEntries.get((int)i)).id.equals(backpackEntry.id)).findFirst().orElse(-1);
                    if (index >= 0) {
                        BackpackEntry e2 = (BackpackEntry)defaultEntityEntry._backpackEntries.get(index);
                        defaultEntityEntry._backpackEntries.set(index, new BackpackEntry(e2.id, e2.backpack, backpackEntry.chance, e2.lootTable, e2.colorRange, e2.isDefault));
                        continue;
                    }
                    defaultEntityEntry._backpackEntries.add(backpackEntry);
                }
                continue;
            }
            dest.add(entityEntry);
        }
        return dest;
    }

    public static List<BackpackEntry> getBackpackEntries(Class<? extends EntityLivingBase> entityClass) {
        if (entityClass == null) {
            throw new NullPointerException("entityClass must not be null");
        }
        BackpackEntityEntry entityEntry = BackpackRegistry.getEntityEntry(entityClass);
        return entityEntry != null ? entityEntry.getEntries() : Collections.emptyList();
    }

    public static final class ColorRange {
        public static final ColorRange DEFAULT = new ColorRange(0x202020, 0xD0D0D0);
        private static final Random rnd = new Random();
        public final int min;
        public final int max;

        public ColorRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean isValid() {
            int minR = this.min >> 16 & 0xFF;
            int minG = this.min >> 8 & 0xFF;
            int minB = this.min & 0xFF;
            int maxR = this.max >> 16 & 0xFF;
            int maxG = this.max >> 8 & 0xFF;
            int maxB = this.max & 0xFF;
            return minR <= maxR && minG <= maxG && minB <= maxB;
        }

        public int getRandom() {
            int minR = this.min >> 16 & 0xFF;
            int minG = this.min >> 8 & 0xFF;
            int minB = this.min & 0xFF;
            int maxR = this.max >> 16 & 0xFF;
            int maxG = this.max >> 8 & 0xFF;
            int maxB = this.max & 0xFF;
            int r = maxR - minR + 1 >= 0 ? minR + rnd.nextInt(maxR - minR + 1) : minR;
            int g = maxG - minG + 1 >= 0 ? minG + rnd.nextInt(maxG - minG + 1) : minG;
            int b = maxB - minB + 1 >= 0 ? minB + rnd.nextInt(maxB - minB + 1) : minB;
            return r << 16 | g << 8 | b;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ColorRange)) {
                return false;
            }
            ColorRange other = (ColorRange)obj;
            return other.min == this.min && other.max == this.max;
        }
    }

    public static final class BackpackEntry {
        public static final BackpackEntry DEFAULT = new BackpackEntry(null, "wearablebackpacks:backpack", 1000, "wearablebackpacks:backpack/default", null, false);
        public final String id;
        public final String backpack;
        public final int chance;
        public final String lootTable;
        public final ColorRange colorRange;
        public final boolean isDefault;

        public BackpackEntry(String id, String backpack, int chance, String lootTable, ColorRange colorRange, boolean isDefault) {
            if (backpack == null) {
                throw new NullPointerException("backpack must not be null");
            }
            if (chance < 0) {
                throw new NullPointerException("chance must not be negative");
            }
            this.id = id;
            this.backpack = backpack;
            this.chance = chance;
            this.lootTable = lootTable;
            this.colorRange = colorRange;
            this.isDefault = isDefault;
        }

        public <T extends Item> T getBackpackItem() {
            Item item = Item.func_111206_d((String)this.backpack);
            return (T)(item instanceof IBackpackType ? item : null);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackpackEntry)) {
                return false;
            }
            BackpackEntry other = (BackpackEntry)obj;
            return Objects.equals(other.id, this.id) && Objects.equals(other.backpack, this.backpack) && other.chance == this.chance && Objects.equals(other.lootTable, this.lootTable) && Objects.equals(other.colorRange, this.colorRange);
        }
    }

    public static final class RenderOptions {
        public static final RenderOptions DEFAULT = new RenderOptions(0.0, 2.5, 0.0, 0.8);
        public final double y;
        public final double z;
        public final double rotate;
        public final double scale;

        public RenderOptions(double y, double z, double rotate, double scale) {
            this.y = y;
            this.z = z;
            this.rotate = rotate;
            this.scale = scale;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RenderOptions)) {
                return false;
            }
            RenderOptions other = (RenderOptions)obj;
            return other.y == this.y && other.z == this.z && other.rotate == this.rotate && other.scale == this.scale;
        }
    }

    public static final class BackpackEntityEntry {
        public static final BackpackEntityEntry PLAYER = new BackpackEntityEntry("<player>", RenderOptions.DEFAULT, Collections.emptyList(), true);
        public final String entityID;
        public final RenderOptions renderOptions;
        public final boolean isDefault;
        private final List<BackpackEntry> _backpackEntries;

        public BackpackEntityEntry(String entityID, RenderOptions renderOptions, List<BackpackEntry> entries, boolean isDefault) {
            if (entityID == null) {
                throw new NullPointerException("entityID must not be null");
            }
            if (renderOptions == null) {
                throw new NullPointerException("renderOptions must not be null");
            }
            if (entries == null) {
                throw new NullPointerException("entries must not be null");
            }
            this.entityID = entityID;
            this.renderOptions = renderOptions;
            this.isDefault = isDefault;
            this._backpackEntries = entries;
        }

        public BackpackEntityEntry(BackpackEntityEntry value) {
            this(value.entityID, value.renderOptions, new ArrayList<BackpackEntry>(value._backpackEntries), value.isDefault);
        }

        public Class<? extends EntityLivingBase> getEntityClass() {
            return _entityClassLookupCache.computeIfAbsent(this.entityID, id -> Optional.ofNullable(ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id))).map(EntityEntry::getEntityClass).filter(EntityLivingBase.class::isAssignableFrom).map(c -> c.asSubclass(EntityLivingBase.class))).orElse(null);
        }

        public List<BackpackEntry> getEntries() {
            return Collections.unmodifiableList(this._backpackEntries);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BackpackEntityEntry)) {
                return false;
            }
            BackpackEntityEntry other = (BackpackEntityEntry)obj;
            return Objects.equals(other.entityID, this.entityID) && other.renderOptions.equals(this.renderOptions) && other._backpackEntries.equals(this._backpackEntries);
        }
    }
}

