/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival;

import com.google.common.collect.Maps;
import com.mujmajnkraft.bettersurvival.entities.siegeweapons.EnumWeaponType;
import com.mujmajnkraft.bettersurvival.init.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WorkshopRecipe {
    private static final WorkshopRecipe WORKSHOP_BASE = new WorkshopRecipe();
    private final Map<List<ItemStack>, EnumWeaponType> workshopList = Maps.newHashMap();

    public static WorkshopRecipe instance() {
        return WORKSHOP_BASE;
    }

    public void addWorkshopRecipe(EnumWeaponType weapon, List<ItemStack> ingredients) {
        if (weapon != null && ingredients.size() == 9) {
            for (ItemStack stack : ingredients) {
                if (stack == ItemStack.field_190927_a) continue;
                this.workshopList.put(ingredients, weapon);
                return;
            }
        }
    }

    public List<ItemStack> getIngredients(EnumWeaponType weapon) {
        for (Map.Entry<List<ItemStack>, EnumWeaponType> entry : this.workshopList.entrySet()) {
            if (weapon != entry.getValue()) continue;
            return entry.getKey();
        }
        return new ArrayList<ItemStack>();
    }

    private WorkshopRecipe() {
        ItemStack[] ballista = new ItemStack[]{new ItemStack(Blocks.field_150344_f, 20), ItemStack.field_190927_a, new ItemStack(Items.field_151042_j, 8), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151007_F, 6), ItemStack.field_190927_a};
        ItemStack[] cannon = new ItemStack[]{new ItemStack(Blocks.field_150344_f, 12), new ItemStack(Items.field_151145_ak, 8), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151042_j, 8), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
        ItemStack[] potionthrower = new ItemStack[]{new ItemStack(Blocks.field_150344_f, 20), ItemStack.field_190927_a, new ItemStack(Items.field_151042_j, 8), new ItemStack(Items.field_151116_aA, 8), ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(Items.field_151007_F, 6), ItemStack.field_190927_a};
        ItemStack[] zeppelin = new ItemStack[]{new ItemStack(Blocks.field_150344_f, 64), ItemStack.field_190927_a, new ItemStack(Items.field_151042_j, 8), ItemStack.field_190927_a, new ItemStack(Blocks.field_150325_L, 40), ItemStack.field_190927_a, new ItemStack(Items.field_151007_F, 20), ItemStack.field_190927_a, new ItemStack(Items.field_151137_ax, 6)};
        this.addWorkshopRecipe(EnumWeaponType.BALLISTA, new ArrayList<ItemStack>(Arrays.asList(ballista)));
        this.addWorkshopRecipe(EnumWeaponType.CANNON, new ArrayList<ItemStack>(Arrays.asList(cannon)));
        this.addWorkshopRecipe(EnumWeaponType.POTION_THROWER, new ArrayList<ItemStack>(Arrays.asList(potionthrower)));
        this.addWorkshopRecipe(EnumWeaponType.ZEPPELIN, new ArrayList<ItemStack>(Arrays.asList(zeppelin)));
    }

    public List<ItemStack> getBlueprints() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Map.Entry<List<ItemStack>, EnumWeaponType> entry : this.workshopList.entrySet()) {
            System.out.println(entry.getValue().getName());
            ItemStack stack = new ItemStack(ModItems.blueprint);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Type", entry.getValue().getName());
            stack.func_77982_d(compound);
            list.add(stack);
        }
        return list;
    }
}

