/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.google.common.collect.Multimap;
import com.mujmajnkraft.bettersurvival.Bettersurvival;
import com.mujmajnkraft.bettersurvival.ICustomWeapon;
import com.mujmajnkraft.bettersurvival.config.ConfigHandler;
import com.mujmajnkraft.bettersurvival.init.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemDagger
extends ItemSword
implements ICustomWeapon {
    private Item.ToolMaterial mat;

    public ItemDagger(Item.ToolMaterial material) {
        super(material);
        this.setRegistryName("Item" + material.name().toLowerCase() + "Dagger");
        this.func_77655_b(material.name().toLowerCase() + "dagger");
        this.mat = material;
    }

    public Item.ToolMaterial getMaterial() {
        return this.mat;
    }

    @Override
    public float getReach() {
        return 0.0f;
    }

    @Override
    public boolean noSweepAttack() {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_111264_e, field_111210_e, 0.7);
            this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_188790_f, field_185050_h, 0.8);
        }
        return modifiers;
    }

    private void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double multiplier) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() * multiplier, modifier.func_111169_c()));
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer attacker, Entity entity) {
        if ((double)attacker.func_184825_o(0.5f) > 0.9 && entity instanceof EntityLivingBase) {
            attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            AttributeModifier modifier = new AttributeModifier(UUID.fromString("a6107045-134f-4c04-a645-75c3ae5c7a27"), "compensation", 4.0, 2);
            if (!attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(modifier)) {
                attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(modifier);
            }
            attacker.func_184821_cY();
        }
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (ConfigHandler.integration && OreDictionary.doesOreNameExist((String)("ingot" + this.getMaterial().name()))) {
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + this.getMaterial().name()))) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)repair, (boolean)false)) continue;
                return true;
            }
        }
        return super.func_82789_a(toRepair, repair);
    }

    public CreativeTabs func_77640_w() {
        if (this.getMaterial() == Item.ToolMaterial.DIAMOND || this.getMaterial() == Item.ToolMaterial.GOLD || this.getMaterial() == Item.ToolMaterial.IRON || this.getMaterial() == Item.ToolMaterial.STONE || this.getMaterial() == Item.ToolMaterial.WOOD) {
            return super.func_77640_w();
        }
        if ((this.getMaterial() == ModItems.JUNGLE_CHITIN || this.getMaterial() == ModItems.DESERT_CHITIN || this.getMaterial() == ModItems.DRAGON_BONE) && Bettersurvival.isIafLoaded && ConfigHandler.integration) {
            return super.func_77640_w();
        }
        if (ConfigHandler.integration && !OreDictionary.getOres((String)("ingot" + this.getMaterial().name())).isEmpty()) {
            return super.func_77640_w();
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            String s = I18n.func_74838_a((String)"silvertools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        } else if (this.mat == ModItems.JUNGLE_CHITIN || this.mat == ModItems.DESERT_CHITIN) {
            String s = I18n.func_74838_a((String)"mujmajnkraftsbettersurvival.chitintools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                target.field_70172_ad = 0;
                target.func_70097_a(DamageSource.field_76376_m, 2.0f);
            }
        } else if ((this.mat == ModItems.DESERT_CHITIN || this.mat == ModItems.JUNGLE_CHITIN) && target.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD) {
            target.field_70172_ad = 0;
            target.func_70097_a(DamageSource.field_76376_m, 4.0f);
        }
        return super.func_77644_a(stack, target, attacker);
    }
}

