/*
 * Decompiled with CFR 0.152.
 */
package com.mujmajnkraft.bettersurvival.items;

import com.google.common.collect.Multimap;
import com.mujmajnkraft.bettersurvival.Bettersurvival;
import com.mujmajnkraft.bettersurvival.ICustomWeapon;
import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.INunchakuCombo;
import com.mujmajnkraft.bettersurvival.capabilities.nunchakucombo.NunchakuComboProwider;
import com.mujmajnkraft.bettersurvival.config.ConfigHandler;
import com.mujmajnkraft.bettersurvival.init.ModItems;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemNunchaku
extends ItemSword
implements ICustomWeapon {
    private Item.ToolMaterial mat;

    public ItemNunchaku(Item.ToolMaterial material) {
        super(material);
        this.setRegistryName("Item" + material.name().toLowerCase() + "Nunchaku");
        this.func_77655_b(material.name().toLowerCase() + "nunchaku");
        this.mat = material;
        this.func_185043_a(new ResourceLocation("spinning"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn != null && ((INunchakuCombo)entityIn.getCapability(NunchakuComboProwider.NUNCHAKUCOMBO_CAP, null)).isSpinning() && entityIn.func_184614_ca() == stack) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public Item.ToolMaterial getMaterial() {
        return this.mat;
    }

    @Override
    public float getReach() {
        return 5.0f;
    }

    @Override
    public boolean noSweepAttack() {
        return true;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_111264_e, field_111210_e, 0.5);
            this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_188790_f, field_185050_h, 0.1);
        }
        return modifiers;
    }

    private void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double multiplier) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() * multiplier, modifier.func_111169_c()));
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        int i = EnchantmentHelper.func_77501_a((EntityLivingBase)attacker) + 1;
        target.func_70653_a((Entity)attacker, -((float)i) * 0.1f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)i * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)i * ((float)Math.PI / 180)))));
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                target.field_70172_ad = 0;
                target.func_70097_a(DamageSource.field_76376_m, 2.0f);
            }
        } else if ((this.mat == ModItems.DESERT_CHITIN || this.mat == ModItems.JUNGLE_CHITIN) && target.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD) {
            target.field_70172_ad = 0;
            target.func_70097_a(DamageSource.field_76376_m, 4.0f);
        }
        return super.func_77644_a(stack, target, attacker);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (ConfigHandler.integration && OreDictionary.doesOreNameExist((String)("ingot" + this.getMaterial().name()))) {
            for (ItemStack stack : OreDictionary.getOres((String)("ingot" + this.getMaterial().name()))) {
                if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)repair, (boolean)false)) continue;
                return true;
            }
        }
        return super.func_82789_a(toRepair, repair);
    }

    public CreativeTabs func_77640_w() {
        if (this.getMaterial() == Item.ToolMaterial.DIAMOND || this.getMaterial() == Item.ToolMaterial.GOLD || this.getMaterial() == Item.ToolMaterial.IRON || this.getMaterial() == Item.ToolMaterial.STONE || this.getMaterial() == Item.ToolMaterial.WOOD) {
            return super.func_77640_w();
        }
        if ((this.getMaterial() == ModItems.JUNGLE_CHITIN || this.getMaterial() == ModItems.DESERT_CHITIN || this.getMaterial() == ModItems.DRAGON_BONE) && Bettersurvival.isIafLoaded && ConfigHandler.integration) {
            return super.func_77640_w();
        }
        if (ConfigHandler.integration && !OreDictionary.getOres((String)("ingot" + this.getMaterial().name())).isEmpty()) {
            return super.func_77640_w();
        }
        return null;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.mat == ModItems.SILVER && Bettersurvival.isIafLoaded) {
            String s = I18n.func_74838_a((String)"silvertools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        } else if (this.mat == ModItems.JUNGLE_CHITIN || this.mat == ModItems.DESERT_CHITIN) {
            String s = I18n.func_74838_a((String)"mujmajnkraftsbettersurvival.chitintools.hurt");
            tooltip.add(TextFormatting.GREEN + s);
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

