/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai;

import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileAncientball;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileHomming;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileSalivaball;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileSpineball;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileWebball;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIAttackProjectile
extends EntityAIBase {
    private final EntityParasiteBase parentEntity;
    private int attackTimer;
    private int cooldown;
    private int pType;
    private int shootingTimes;
    private int shootingUpdate;
    private int tickInterval;
    private int heighA;
    private boolean canShootH;

    public EntityAIAttackProjectile(EntityParasiteBase parent, int cooldown, int projectileType, int tickInter, int shootingTim) {
        this(parent, cooldown, projectileType, tickInter, shootingTim, false);
    }

    public EntityAIAttackProjectile(EntityParasiteBase parent, int cooldown, int projectileType, int tickInter, int shootingTim, boolean homming) {
        this.parentEntity = parent;
        this.attackTimer = 0;
        this.cooldown = cooldown;
        this.pType = projectileType;
        this.shootingTimes = shootingTim;
        this.shootingUpdate = 0;
        this.tickInterval = tickInter;
        this.canShootH = homming;
    }

    public boolean func_75250_a() {
        return this.parentEntity.func_70638_az() != null;
    }

    public void func_75251_c() {
        this.shootingUpdate = 0;
        this.attackTimer = 0;
    }

    public void func_75246_d() {
        if (this.parentEntity.func_70638_az() == null || this.parentEntity.getParasiteStatus() >= 3) {
            this.attackTimer = 0;
        } else if (this.parentEntity.func_70638_az().field_70128_L) {
            this.attackTimer = 0;
        } else {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            if (this.parentEntity.getParasiteStatus() == 0) {
                this.parentEntity.setParasiteStatus(1);
            }
            if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 4225.0 && this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                ++this.attackTimer;
                if (this.attackTimer == this.cooldown - 10) {
                    this.soundPost();
                }
                if (this.attackTimer > this.cooldown) {
                    if (this.shootingTimes > this.shootingUpdate) {
                        if (this.attackTimer % this.tickInterval == 0) {
                            this.shoot(entitylivingbase, this.parentEntity.field_70170_p);
                            ++this.shootingUpdate;
                        }
                    } else {
                        this.attackTimer = 0;
                        this.shootingUpdate = 0;
                    }
                }
            } else if (this.attackTimer > 0) {
                --this.attackTimer;
            }
        }
    }

    private void shoot(EntityLivingBase entitylivingbase, World world) {
        this.heighA = !entitylivingbase.field_70122_E && this.canShootH ? ++this.heighA : 0;
        if (this.heighA > 5) {
            switch (this.pType) {
                case 0: {
                    this.parentEntity.func_184185_a(SRPSounds.ORONCO_SHOOTINGREAL, 2.0f, 1.0f);
                    EntityProjectileHomming entityshulkerbullet = new EntityProjectileHomming(this.parentEntity.field_70170_p, (EntityLivingBase)this.parentEntity, (Entity)entitylivingbase, SRPAttributes.ORONCO_ATTACK_DAMAGE);
                    entityshulkerbullet.field_70163_u = this.parentEntity.field_70163_u + (double)this.parentEntity.func_70047_e();
                    this.parentEntity.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                    break;
                }
                case 5: {
                    this.parentEntity.func_184185_a(SRPSounds.EMANA_SHOOTING, 2.0f, 1.0f);
                    EntityProjectileHomming entityshulkerbullet2 = new EntityProjectileHomming(this.parentEntity.field_70170_p, (EntityLivingBase)this.parentEntity, (Entity)entitylivingbase, SRPAttributes.EMANA_A_RANGED_DAMAGE);
                    entityshulkerbullet2.field_70163_u = this.parentEntity.field_70163_u + (double)this.parentEntity.func_70047_e();
                    this.parentEntity.field_70170_p.func_72838_d((Entity)entityshulkerbullet2);
                    break;
                }
            }
        } else {
            double d1 = 4.0;
            Vec3d vec3d = this.parentEntity.func_70676_i(1.0f);
            double d2 = entitylivingbase.field_70165_t - (this.parentEntity.field_70165_t + vec3d.field_72450_a);
            double d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (0.5 + this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
            double d4 = entitylivingbase.field_70161_v - (this.parentEntity.field_70161_v + vec3d.field_72449_c);
            Object entitylargefireball = new EntityLargeFireball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
            switch (this.pType) {
                case 0: {
                    this.parentEntity.func_184185_a(SRPSounds.ORONCO_SHOOTINGREAL, 2.0f, 1.0f);
                    entitylargefireball = new EntityProjectileAncientball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    break;
                }
                case 1: {
                    this.parentEntity.func_184185_a(SRPSounds.ALAFHA_SHOOTING, 2.0f, 1.0f);
                    entitylargefireball = new EntityProjectileSalivaball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    break;
                }
                case 2: {
                    this.parentEntity.func_184185_a(SRPSounds.EMANA_SHOOTING, 2.0f, 1.0f);
                    entitylargefireball = new EntityProjectileSpineball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4, SRPAttributes.EMANA_RANGED_DAMAGE);
                    EntityProjectileSpineball ball = (EntityProjectileSpineball)((Object)entitylargefireball);
                    ball.setDurationAmplifier(SRPConfig.emanaPoisonDuration, SRPConfig.emanaPoisonAmplifier);
                    ball.setGearDamage(SRPConfig.emanaGearD);
                    break;
                }
                case 3: {
                    this.parentEntity.func_184185_a(SRPSounds.DORPA_RANGE, 2.0f, 1.0f);
                    d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 3.0f) - (1.0 + this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                    entitylargefireball = new EntityProjectileWebball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4);
                    break;
                }
                case 4: {
                    this.parentEntity.func_184185_a(SRPSounds.EMANA_SHOOTING, 2.0f, 1.0f);
                    d3 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 4.0f) - (1.0 + this.parentEntity.field_70163_u + (double)(this.parentEntity.field_70131_O / 2.0f));
                    entitylargefireball = new EntityProjectileSpineball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4, SRPAttributes.UNVO_RANGE_ATTACK_DAMAGE);
                    EntityProjectileSpineball ball3 = (EntityProjectileSpineball)((Object)entitylargefireball);
                    ball3.setDurationAmplifier(SRPConfig.unvoPoisonDuration, SRPConfig.unvoPoisonAmplifier);
                    ball3.setGearDamage(SRPConfig.unvoGearD);
                    break;
                }
                case 5: {
                    this.parentEntity.func_184185_a(SRPSounds.EMANA_SHOOTING, 2.0f, 1.0f);
                    entitylargefireball = new EntityProjectileSpineball(world, (EntityLivingBase)this.parentEntity, d2, d3, d4, SRPAttributes.EMANA_A_RANGED_DAMAGE);
                    EntityProjectileSpineball ball2 = (EntityProjectileSpineball)((Object)entitylargefireball);
                    ball2.setDurationAmplifier(SRPConfig.emanaPoisonDuration * 2, SRPConfig.emanaPoisonAmplifier + 1);
                    ball2.setGearDamage(SRPConfig.emanaadaptedgeard);
                    break;
                }
            }
            entitylargefireball.field_70165_t = this.parentEntity.field_70165_t + vec3d.field_72450_a;
            entitylargefireball.field_70163_u = this.parentEntity.field_70163_u + (double)this.parentEntity.func_70047_e() - 0.2;
            entitylargefireball.field_70161_v = this.parentEntity.field_70161_v + vec3d.field_72449_c;
            world.func_72838_d((Entity)entitylargefireball);
        }
    }

    private void soundPost() {
        switch (this.pType) {
            case 0: {
                this.parentEntity.func_184185_a(SRPSounds.ORONCO_SHOOTING, 4.0f, 1.0f);
                break;
            }
            case 1: {
                this.parentEntity.func_184185_a(SRPSounds.ALAFHA_SHOOTINGPOST, 2.0f, 1.0f);
                break;
            }
            case 2: {
                this.parentEntity.func_184185_a(SRPSounds.EMANA_SHOOTINGPOST, 2.0f, 1.0f);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.parentEntity.func_184185_a(SRPSounds.UNVO_SHOOTING, 2.0f, 1.0f);
                break;
            }
            case 5: {
                this.parentEntity.func_184185_a(SRPSounds.AEMANA_SHOOTINGPOST, 2.0f, 1.0f);
                break;
            }
        }
    }
}

