/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.monster;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityBomb
extends Entity {
    private static final DataParameter<Integer> FUSE = EntityDataManager.func_187226_a(EntityBomb.class, (DataSerializer)DataSerializers.field_187192_b);
    @Nullable
    private EntityLivingBase tntPlacedBy;
    private int fuse = 80;
    private float str = 4.0f;
    private float damage;
    private boolean grief;
    private static final DataParameter<Integer> SKIN = EntityDataManager.func_187226_a(EntityBomb.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityBomb(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.field_70178_ae = true;
        this.func_70105_a(0.68f, 0.68f);
    }

    public EntityBomb(World worldIn, EntityLivingBase igniter, boolean canGrief) {
        this(worldIn);
        this.tntPlacedBy = igniter;
        this.func_70107_b(igniter.field_70165_t, igniter.field_70163_u + (double)igniter.func_70047_e() - (double)0.1f, igniter.field_70161_v);
        this.grief = canGrief;
    }

    public EntityBomb(World worldIn, double x, double y, double z, EntityLivingBase igniter, float stren) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        float f = (float)(Math.random() * (Math.PI * 2));
        this.field_70159_w = -((float)Math.sin(f)) * 0.02f;
        this.field_70181_x = 0.2f;
        this.field_70179_y = -((float)Math.cos(f)) * 0.02f;
        this.setFuse(80);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.tntPlacedBy = igniter;
        this.str = stren;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUSE, (Object)80);
        this.field_70180_af.func_187214_a(SKIN, (Object)0);
    }

    public void func_70110_aj() {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
        --this.fuse;
        if (this.fuse <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explode();
            }
        } else {
            this.func_70072_I();
        }
        this.onLivingUpdate();
    }

    public void onLivingUpdate() {
        this.collideWithNearbyEntities();
    }

    protected void collideWithNearbyEntities() {
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), EntitySelectors.func_188442_a((Entity)this));
        if (!list.isEmpty()) {
            int i = this.field_70170_p.func_82736_K().func_180263_c("maxEntityCramming");
            if (i > 0 && list.size() > i - 1 && this.field_70146_Z.nextInt(4) == 0) {
                int j = 0;
                for (int k = 0; k < list.size(); ++k) {
                    if (((Entity)list.get(k)).func_184218_aH()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.func_70097_a(DamageSource.field_191291_g, 6.0f);
                }
            }
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                this.collideWithEntity(entity);
            }
        }
    }

    protected void collideWithEntity(Entity entityIn) {
        entityIn.func_70108_f((Entity)this);
    }

    public void func_70030_z() {
        super.func_70030_z();
    }

    private void explode() {
        this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70165_t, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.1f);
        float f = 4.0f;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(4.0);
        List moblist = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
        for (EntityLivingBase mob : moblist) {
            if (mob instanceof EntityParasiteBase) continue;
            if (this.tntPlacedBy == null) break;
            mob.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.tntPlacedBy), this.damage);
            SRPPotions.applyViral(mob, 100, 0);
        }
        boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) && this.grief;
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, this.str, flag);
    }

    public void setMotion(double xSpeedIn, double ySpeedIn, double zSpeedIn, double capX, double capY) {
        xSpeedIn = Math.min(xSpeedIn, capX);
        ySpeedIn = Math.min(ySpeedIn, capY);
        zSpeedIn = Math.min(zSpeedIn, capX);
        this.field_70159_w = xSpeedIn * (Math.random() * 2.0 - 1.0);
        this.field_70181_x = ySpeedIn;
        this.field_70179_y = zSpeedIn * (Math.random() * 2.0 - 1.0);
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shootTwo(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    public void shootTwo(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Fuse", (short)this.getFuse());
        compound.func_74768_a("parasitetype", this.getSkin());
        compound.func_74776_a("stren", this.str);
        compound.func_74757_a("cangrief", this.grief);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setFuse(compound.func_74765_d("Fuse"));
        if (compound.func_150297_b("parasitetype", 99)) {
            this.setSkin(compound.func_74762_e("parasitetype"));
        }
        if (compound.func_150297_b("stren", 99)) {
            this.str = compound.func_74760_g("stren");
        }
        if (compound.func_150297_b("cangrief", 99)) {
            this.grief = compound.func_74767_n("cangrief");
        }
    }

    @Nullable
    public EntityLivingBase getTntPlacedBy() {
        return this.tntPlacedBy;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    public void setFuse(int fuseIn) {
        this.field_70180_af.func_187227_b(FUSE, (Object)fuseIn);
        this.fuse = fuseIn;
    }

    public void setStren(float in) {
        this.str = in;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (FUSE.equals(key)) {
            this.fuse = this.getFuseDataManager();
        }
    }

    public int getFuseDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(FUSE);
    }

    public int getFuse() {
        return this.fuse;
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN);
    }

    public void setSkin(int texture) {
        this.field_70180_af.func_187227_b(SKIN, (Object)texture);
    }

    public void setDamage(float in) {
        this.damage = in;
    }
}

