/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.init;

import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeInfestedPlain;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SRPBiomes {
    public static final BiomeParasite biomeInfested = new BiomeInfestedPlain();

    private static void register(RegistryEvent.Register<Biome> event, Biome biome, BiomeManager.BiomeType type, String name, int weight, BiomeDictionary.Type ... biomeDictTypes) {
        biome.setRegistryName(new ResourceLocation("srparasites", name));
        event.getRegistry().register((IForgeRegistryEntry)biome);
        for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
        }
        BiomeManager.addBiome((BiomeManager.BiomeType)type, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(biome, weight));
    }

    public static void clearMobSpawnList() {
        biomeInfested.mobListClear();
    }

    @Mod.EventBusSubscriber(modid="srparasites")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<Biome> event) {
            if (SRPConfig.biomeRegster) {
                SRPBiomes.register((RegistryEvent.Register<Biome>)event, biomeInfested, BiomeManager.BiomeType.COOL, "biome_parasite", SRPConfig.biomeweight, new BiomeDictionary.Type[]{BiomeDictionary.Type.SPOOKY});
            }
        }
    }
}

