/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.network;

import com.dhanantry.scapeandrunparasites.client.particle.ParticleSpawner;
import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SRPPacketParticle
implements IMessage {
    private BlockPos blockPos;
    private float width;
    private float height;
    private byte type;

    public SRPPacketParticle() {
    }

    public SRPPacketParticle(BlockPos pos, float width, float height, byte particleType) {
        this.blockPos = pos;
        this.width = width;
        this.height = height;
        this.type = particleType;
    }

    public void fromBytes(ByteBuf ByteBuf2) {
        this.blockPos = new BlockPos(ByteBuf2.readInt(), ByteBuf2.readInt(), ByteBuf2.readInt());
        this.width = ByteBuf2.readFloat();
        this.height = ByteBuf2.readFloat();
        this.type = ByteBuf2.readByte();
    }

    public void toBytes(ByteBuf ByteBuf2) {
        ByteBuf2.writeInt(this.blockPos.func_177958_n());
        ByteBuf2.writeInt(this.blockPos.func_177956_o());
        ByteBuf2.writeInt(this.blockPos.func_177952_p());
        ByteBuf2.writeFloat(this.width);
        ByteBuf2.writeFloat(this.height);
        ByteBuf2.writeByte((int)this.type);
    }

    public static class Handler
    implements IMessageHandler<SRPPacketParticle, IMessage> {
        public IMessage onMessage(SRPPacketParticle message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(SRPPacketParticle message, MessageContext ctx) {
            switch (message.type) {
                case 1: {
                    this.spawnParticles(SRPEnumParticle.GSPLASH, new Random(), message, 0);
                    break;
                }
                case 2: {
                    for (int i = 0; i <= 3; ++i) {
                        this.spawnParticles(SRPEnumParticle.GCLOUD, new Random(), message, 0);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i <= 5; ++i) {
                        this.spawnParticles(SRPEnumParticle.RHAPPY, new Random(), message, 0);
                    }
                    break;
                }
            }
        }

        private void spawnParticles(SRPEnumParticle particleType, Random rand, SRPPacketParticle message, int r) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            ParticleSpawner.spawnParticle(particleType, (double)message.blockPos.func_177958_n() + (double)(rand.nextFloat() * message.width * 2.0f) - (double)message.width, (double)message.blockPos.func_177956_o() + 0.5 + (double)(rand.nextFloat() * message.height), (double)message.blockPos.func_177952_p() + (double)(rand.nextFloat() * message.width * 2.0f) - (double)message.width, d0, d1, d2, r, 0, 0);
        }
    }
}

