/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.util.handlers;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleBiomass;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleFog;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleMultipleGore;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleRHappy;
import com.dhanantry.scapeandrunparasites.client.particle.ParticleSpore;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIBlockGriefing;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityBanoAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityCanraAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityEmanaAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityHullAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityNoglaAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityRanracAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.adapted.EntityShycoAdapted;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityOronco;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityTerla;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityTonro;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityUnvo;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityButhol;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityLodo;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityMudo;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityRathol;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityDorpa;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityHost;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfBear;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfCow;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfEnderman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHorse;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfHuman;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPig;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfPlayer;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfSheep;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfVillager;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInfWolf;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityBano;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityCanra;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityEmana;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityHull;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityNogla;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityRanrac;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityShyco;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityAlafha;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityAnged;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityEsor;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityFlog;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityGanro;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityOmboo;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.item.tool.IHaveReach;
import com.dhanantry.scapeandrunparasites.network.SRPPacketMeleeRange;
import com.dhanantry.scapeandrunparasites.network.SRPPacketParticle;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventWorld;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import com.dhanantry.scapeandrunparasites.world.biome.BiomeParasite;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class SRPEventHandlerBus {
    float fog = 0.0f;
    int counerW = 0;

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(EntityViewRenderEvent.FogDensity event) {
        if (event.getEntity().field_70170_p.func_180494_b(event.getEntity().func_180425_c()) instanceof BiomeParasite) {
            this.fog = Math.min(this.fog + 4.5E-5f, SRPConfig.biomeFogDensity);
        } else if (this.fog > 0.0f) {
            this.fog = Math.max(this.fog - 8.0E-5f, 0.0f);
        }
        if (this.fog > 0.0f && !Minecraft.func_71410_x().field_71439_g.func_70644_a(MobEffects.field_76440_q)) {
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            event.setDensity(this.fog);
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(EntityViewRenderEvent.FogColors event) {
        if (this.fog > 0.0f && !Minecraft.func_71410_x().field_71439_g.func_70644_a(MobEffects.field_76440_q)) {
            event.setRed(SRPConfig.biomeFogRed / 255.0f);
            event.setGreen(SRPConfig.biomeFogGreen / 255.0f);
            event.setBlue(SRPConfig.biomeFogBlue / 255.0f);
        }
    }

    @SubscribeEvent
    public void cropGrow(BlockEvent.CropGrowEvent.Pre event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        if (SRPConfig.nodesActivated || SRPConfig.useEvolution) {
            SRPWorldData data = SRPWorldData.get(event.getWorld());
            switch (data.nearestHeartAge(event.getPos(), false, 0)) {
                case 1: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < (double)SRPConfig.nodeCropStopNodeOne)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 2: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < (double)SRPConfig.nodeCropStopNodeTwo)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 3: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < (double)SRPConfig.nodeCropStopNodeThree)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
            }
            switch (data.getEvolutionPhase()) {
                case 1: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedOne)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 2: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedTwo)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 3: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedThree)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 4: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedFour)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 5: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedFive)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 6: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedSix)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 7: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedSeven)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
                case 8: {
                    if (!(event.getWorld().field_73012_v.nextDouble() < SRPConfig.cropGrowStunnedEight)) break;
                    event.setResult(Event.Result.DENY);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void entityHeal(LivingHealEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.field_70170_p.func_180494_b(entity.func_180425_c()) instanceof BiomeParasite) {
            if (entity instanceof EntityParasiteBase) {
                return;
            }
            if (entity instanceof EntityPlayer) {
                event.setAmount(event.getAmount() * SRPConfig.biomeHealPenalty);
            } else {
                boolean flag = ParasiteEventEntity.checkName(EntityList.func_191301_a((Entity)entity).toString(), SRPConfig.biomeHealPenaltyBlackList, SRPConfig.biomeHealPenaltyBlackListWhite);
                if (SRPConfig.biomeHealPenaltyBlackListWhite ? flag : flag) {
                    return;
                }
                event.setAmount(event.getAmount() * SRPConfig.biomeHealPenalty);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void stitchEventPre(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(ParticleSpore.PARTICLES_TEXTURE);
        event.getMap().func_174942_a(ParticleFog.PARTICLES_TEXTURE);
        event.getMap().func_174942_a(ParticleMultipleGore.PARTICLES_TEXTUREINFECTED);
        event.getMap().func_174942_a(ParticleMultipleGore.PARTICLES_TEXTURESPIDER);
        event.getMap().func_174942_a(ParticleMultipleGore.PARTICLES_TEXTUREPRIMITIVE);
        event.getMap().func_174942_a(ParticleMultipleGore.PARTICLES_TEXTUREADAPTED);
        event.getMap().func_174942_a(ParticleMultipleGore.PARTICLES_TEXTUREVOMIT);
        event.getMap().func_174942_a(ParticleRHappy.PARTICLES_TEXTURE);
        event.getMap().func_174942_a(ParticleBiomass.PARTICLES_TEXTURE);
    }

    @SubscribeEvent
    public void playerFishing(ItemFishedEvent event) {
        SRPWorldData data;
        if (!event.getEntity().field_70170_p.field_72995_K && SRPConfig.useEvolution && (data = SRPWorldData.get(event.getEntity().field_70170_p)).getEvolutionPhase() >= SRPConfig.evolutionStopFishing) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void itemEntity(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof EntityLivingBase && !event.getWorld().field_72995_K) {
            ItemStack stack = event.getItemStack();
            String item = stack.func_77973_b().getRegistryName().toString();
            String[] atm = new String[3];
            for (int i = 0; i < SRPConfig.COTHItemPrevent.length; ++i) {
                atm = SRPConfig.COTHItemPrevent[i].split(";");
                if (!atm[0].equals(item)) continue;
                int dur = Integer.parseInt(atm[2]);
                if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    double chance = Double.parseDouble(atm[1]);
                    if (!(event.getWorld().field_73012_v.nextDouble() < chance)) continue;
                    ((EntityLivingBase)event.getTarget()).func_70690_d(new PotionEffect(SRPPotions.EPEL_E, dur * 20, 0));
                    SRPMain.network.sendToAll((IMessage)new SRPPacketParticle(event.getTarget().func_180425_c(), event.getTarget().field_70130_N, event.getTarget().field_70131_O, 3));
                    continue;
                }
                ((EntityLivingBase)event.getTarget()).func_70690_d(new PotionEffect(SRPPotions.EPEL_E, dur * 20, 0));
                SRPMain.network.sendToAll((IMessage)new SRPPacketParticle(event.getTarget().func_180425_c(), event.getTarget().field_70130_N, event.getTarget().field_70131_O, 3));
            }
        }
    }

    @SubscribeEvent
    public void itemPlayer(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        if (player.func_70644_a(SRPPotions.FEAR_E) && SRPConfig.fearActive && player.func_70660_b(SRPPotions.FEAR_E).func_76458_c() >= 1 && player.field_70170_p.field_73012_v.nextDouble() < (double)SRPConfig.fearItemChance && !ParasiteEventEntity.checkName(event.getItemStack().func_77973_b().getRegistryName().toString(), SRPConfig.fearItemBlackList, SRPConfig.fearItemBlackListWhite)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.srparasites.fearitem", new Object[0]), true);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void blockPlayer(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        if (player.func_70644_a(SRPPotions.FEAR_E) && SRPConfig.fearActive && player.func_70660_b(SRPPotions.FEAR_E).func_76458_c() >= 2 && player.field_70170_p.field_73012_v.nextDouble() < (double)SRPConfig.fearBlockChance) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.srparasites.fearblock", new Object[0]), true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entityPlayer(PlayerInteractEvent.EntityInteractSpecific event) {
        int heart = ParasiteEventWorld.canBiomeStillExist(event.getWorld(), event.getPos(), false);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void guiPlayer(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null || event.getGui() == null) {
            return;
        }
        if (player.func_184812_l_() || event.getGui().func_73868_f()) {
            return;
        }
        if (player.func_70644_a(SRPPotions.FEAR_E) && SRPConfig.fearActive && !player.field_71075_bZ.field_75102_a && player.func_70660_b(SRPPotions.FEAR_E).func_76458_c() >= 3 && player.field_70170_p.field_73012_v.nextDouble() < (double)SRPConfig.fearInvChance) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("message.srparasites.feargui", new Object[0]), true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void mobFalling(LivingDamageEvent event) {
        EntityLivingBase in = event.getEntityLiving();
        if (in == null) {
            return;
        }
        if (in.func_70644_a(SRPPotions.FEAR_E) && SRPConfig.fearActive && event.getSource() == DamageSource.field_76379_h) {
            event.setAmount(event.getAmount() * SRPConfig.fearFallDamage);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity() instanceof EntityLivingBase && !event.getEntity().field_70170_p.field_72995_K) {
            if (event.getEntity() instanceof EntityPlayer) {
                return;
            }
            String mobname = null;
            try {
                mobname = EntityList.func_191301_a((Entity)event.getEntity()).toString();
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
                return;
            }
            if (mobname == null) {
                return;
            }
            NBTTagCompound tags = event.getEntity().getEntityData();
            boolean parasite = event.getEntity() instanceof EntityParasiteBase;
            boolean flagNC = SRPConfig.nodesActivated || SRPConfig.coloniesActivated || SRPConfig.useEvolution;
            SRPWorldData data = null;
            if (flagNC) {
                data = SRPWorldData.get(event.getWorld());
            }
            if (SRPConfig.nodesActivated && SRPConfig.cothActive && data.nearestHeartAge(event.getEntity().func_180425_c(), false, 0) != -1) {
                ((EntityLivingBase)event.getEntity()).func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
            }
            if (!tags.func_74764_b("srpcothimmunity") && SRPConfig.cothActive && !parasite) {
                this.writeCOTHTag(event.getEntity(), mobname, tags, data);
            }
            if (parasite) {
                this.setNewParasiteTask((EntityParasiteBase)event.getEntity(), mobname, flagNC, data);
            } else if (event.getEntity() instanceof EntityCreature) {
                this.setNewCreatureTask((EntityCreature)event.getEntity(), mobname);
            }
        }
    }

    private void writeCOTHTag(Entity in, String mobname, NBTTagCompound tags, SRPWorldData data) {
        if (in instanceof EntityArmorStand) {
            tags.func_74768_a("srpcothimmunity", 0);
        } else if (ParasiteEventEntity.checkName(mobname, SRPConfig.COTHImmuneList, SRPConfig.COTHImmuneListWhite)) {
            tags.func_74768_a("srpcothimmunity", 0);
        } else {
            tags.func_74768_a("srpcothimmunity", 1);
        }
        this.setCOTH((EntityLivingBase)in, data.getEvolutionPhase());
    }

    private void setNewParasiteTask(EntityParasiteBase entity, String mobname, boolean flagNC, SRPWorldData data) {
        if (flagNC) {
            entity.applyBonuses(data.totalColonyPoints(0), data.totalNodePoints(0), data.getEvolutionPhase());
        }
        if (SRPConfig.parasiteGriefing.length != 0) {
            String[] task = new String[4];
            for (int i = 0; i < SRPConfig.parasiteGriefing.length; ++i) {
                if (SRPConfig.parasiteGriefing[i] == null || !(task = SRPConfig.parasiteGriefing[i].split(";"))[0].equals(mobname)) continue;
                entity.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBlockGriefing(entity, Integer.parseInt(task[2]), Float.parseFloat(task[1]), MathHelper.func_76123_f((float)entity.field_70131_O), Integer.parseInt(task[3])));
                return;
            }
        }
    }

    private void setNewCreatureTask(EntityCreature entity, String mobname) {
        if (ParasiteEventEntity.checkName(mobname, SRPConfig.entitiesWillAttack, SRPConfig.entitiesWillAttackWhite)) {
            entity.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget(entity, EntityParasiteBase.class, true));
            return;
        }
        if (ParasiteEventEntity.checkName(mobname, SRPConfig.entitiesWillAvoid, SRPConfig.entitiesWillAvoidWhite)) {
            entity.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntity(entity, EntityParasiteBase.class, 12.0f, 0.8, 0.8));
        }
    }

    private void setCOTH(EntityLivingBase target, byte evo) {
        Random rand = new Random();
        switch (evo) {
            case 1: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceOne)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
                break;
            }
            case 2: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceTwo)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
                break;
            }
            case 3: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceThree)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
                break;
            }
            case 4: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceFour)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
                break;
            }
            case 5: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceFive)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
                break;
            }
            case 6: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceSix)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
                break;
            }
            case 7: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceSeven)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
                break;
            }
            case 8: {
                if (!(rand.nextDouble() < SRPConfig.mobSpawningCOTHChanceEight)) break;
                target.func_70690_d(new PotionEffect(SRPPotions.COTH_E, 3600, 0, false, false));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        ++this.counerW;
        if (this.counerW >= SRPConfig.dayTickValue && (SRPConfig.nodesActivated || SRPConfig.coloniesActivated || SRPConfig.useEvolution)) {
            WorldServer worldX;
            if (SRPConfig.coloniesActivated) {
                for (int i : SRPConfig.blackListedDimensionsColonies) {
                    worldX = DimensionManager.getWorld((int)i);
                    if (worldX == null) continue;
                    ParasiteEventWorld.checkColonyStatus((World)worldX);
                }
            }
            if (SRPConfig.nodesActivated) {
                for (int i : SRPConfig.blackListedDimensionsNodes) {
                    worldX = DimensionManager.getWorld((int)i);
                    if (worldX == null) continue;
                    ParasiteEventWorld.checkNodeStatus((World)worldX);
                }
            }
            if (SRPConfig.useEvolution) {
                // empty if block
            }
            this.counerW -= SRPConfig.dayTickValue;
        }
    }

    @SubscribeEvent
    public void setLoot(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityParasiteBase) {
            if (!event.getEntityLiving().field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
                return;
            }
            EntityLivingBase mob = event.getEntityLiving();
            if (mob instanceof EntityCanra) {
                this.loot(event, SRPConfig.canraLoot);
                return;
            }
            if (mob instanceof EntityCanraAdapted) {
                this.loot(event, SRPConfig.canraadaptedloot);
                return;
            }
            if (mob instanceof EntityEmana) {
                this.loot(event, SRPConfig.emanaLoot);
                return;
            }
            if (mob instanceof EntityEmanaAdapted) {
                this.loot(event, SRPConfig.emanaadaptedloot);
                return;
            }
            if (mob instanceof EntityNogla) {
                this.loot(event, SRPConfig.noglaLoot);
                return;
            }
            if (mob instanceof EntityNoglaAdapted) {
                this.loot(event, SRPConfig.noglaadaptedloot);
                return;
            }
            if (mob instanceof EntityHull) {
                this.loot(event, SRPConfig.hullLoot);
                return;
            }
            if (mob instanceof EntityHullAdapted) {
                this.loot(event, SRPConfig.hulladaptedloot);
                return;
            }
            if (mob instanceof EntityShyco) {
                this.loot(event, SRPConfig.shycoLoot);
                return;
            }
            if (mob instanceof EntityShycoAdapted) {
                this.loot(event, SRPConfig.shycoadaptedloot);
                return;
            }
            if (mob instanceof EntityRanrac) {
                this.loot(event, SRPConfig.arachnidaLoot);
                return;
            }
            if (mob instanceof EntityRanracAdapted) {
                this.loot(event, SRPConfig.arachnidaadaptedloot);
                return;
            }
            if (mob instanceof EntityBano) {
                this.loot(event, SRPConfig.zetmoLoot);
                return;
            }
            if (mob instanceof EntityBanoAdapted) {
                this.loot(event, SRPConfig.zetmoadaptedloot);
                return;
            }
            if (mob instanceof EntityHost) {
                this.loot(event, SRPConfig.hostLoot);
                return;
            }
            if (mob instanceof EntityInfBear) {
                this.loot(event, SRPConfig.infbearLoot);
                return;
            }
            if (mob instanceof EntityDorpa) {
                this.loot(event, SRPConfig.dorpaLoot);
                return;
            }
            if (mob instanceof EntityInfEnderman) {
                this.loot(event, SRPConfig.infendermanLoot);
                return;
            }
            if (mob instanceof EntityInfHuman) {
                this.loot(event, SRPConfig.infhumanLoot);
                return;
            }
            if (mob instanceof EntityInfCow) {
                this.loot(event, SRPConfig.infcowLoot);
                return;
            }
            if (mob instanceof EntityInfPig) {
                this.loot(event, SRPConfig.infpigLoot);
                return;
            }
            if (mob instanceof EntityInfSheep) {
                this.loot(event, SRPConfig.infsheepLoot);
                return;
            }
            if (mob instanceof EntityInfWolf) {
                this.loot(event, SRPConfig.infwolfLoot);
                return;
            }
            if (mob instanceof EntityInfVillager) {
                this.loot(event, SRPConfig.infvillagerLoot);
                return;
            }
            if (mob instanceof EntityInfHorse) {
                this.loot(event, SRPConfig.infhorseLoot);
                return;
            }
            if (mob instanceof EntityLodo) {
                this.loot(event, SRPConfig.LodoLoot);
                return;
            }
            if (mob instanceof EntityMudo) {
                this.loot(event, SRPConfig.mudoLoot);
                return;
            }
            if (mob instanceof EntityRathol) {
                this.loot(event, SRPConfig.ratholLoot);
                return;
            }
            if (mob instanceof EntityButhol) {
                this.loot(event, SRPConfig.butholLoot);
                return;
            }
            if (mob instanceof EntityUnvo) {
                this.loot(event, SRPConfig.unvoLoot);
                return;
            }
            if (mob instanceof EntityTonro) {
                this.loot(event, SRPConfig.tonroLoot);
                return;
            }
            if (mob instanceof EntityAlafha) {
                this.loot(event, SRPConfig.alafhaLoot);
                return;
            }
            if (mob instanceof EntityGanro) {
                this.loot(event, SRPConfig.ganroLoot);
                return;
            }
            if (mob instanceof EntityAnged) {
                this.loot(event, SRPConfig.angedLoot);
                return;
            }
            if (mob instanceof EntityEsor) {
                this.loot(event, SRPConfig.esorLoot);
                return;
            }
            if (mob instanceof EntityFlog) {
                this.loot(event, SRPConfig.flogLoot);
                return;
            }
            if (mob instanceof EntityOmboo) {
                this.loot(event, SRPConfig.ombooLoot);
                return;
            }
            if (mob instanceof EntityOronco) {
                this.loot(event, SRPConfig.oroncoLoot);
                return;
            }
            if (mob instanceof EntityTerla) {
                this.loot(event, SRPConfig.terlaLoot);
                return;
            }
        } else if (event.getEntity() instanceof EntityLivingBase && !(event.getEntity() instanceof EntityPlayer) && SRPConfig.cothActive && ((EntityLivingBase)event.getEntity()).func_70644_a(SRPPotions.COTH_E)) {
            int key;
            NBTTagCompound tags;
            if (SRPConfig.useEvolution) {
                int key2;
                NBTTagCompound tags2;
                SRPWorldData data = SRPWorldData.get(event.getEntity().field_70170_p);
                if (data.getEvolutionPhase() >= SRPConfig.evolutionCothStopLoot && (tags2 = event.getEntity().getEntityData()).func_74764_b("srpcothimmunity") && (key2 = tags2.func_74762_e("srpcothimmunity")) != 0) {
                    event.setCanceled(true);
                }
            } else if (SRPConfig.cothLootDisable && (tags = event.getEntity().getEntityData()).func_74764_b("srpcothimmunity") && (key = tags.func_74762_e("srpcothimmunity")) != 0) {
                event.setCanceled(true);
            }
        }
    }

    private void loot(LivingDropsEvent event, String[] drop) {
        block8: {
            try {
                if (drop.length == 0) break block8;
                String[] dropping = new String[4];
                String[] dropped = new String[drop.length];
                Random rand = new Random();
                boolean always = false;
                int quantity = 0;
                int realquantity = 0;
                int chance = 0;
                int rng = 0;
                int totalFalse = 0;
                for (int i = 0; i < drop.length; ++i) {
                    dropping = drop[i].split(";");
                    always = Boolean.parseBoolean(dropping[3]);
                    quantity = Integer.parseInt(dropping[2]);
                    chance = Integer.parseInt(dropping[1]);
                    if (always) {
                        rng = rand.nextInt(100);
                        if (rng > chance - 1) continue;
                        Item item = Item.func_111206_d((String)dropping[0]);
                        realquantity = rand.nextInt(quantity);
                        for (int j = 0; j <= realquantity; ++j) {
                            BlockPos pos = event.getEntity().func_180425_c();
                            event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(item)));
                        }
                        continue;
                    }
                    dropped[totalFalse] = drop[i];
                    ++totalFalse;
                }
                if (totalFalse != 0) {
                    int n = rand.nextInt(totalFalse);
                    String[] stringItem = dropped[n].split(";");
                    quantity = Integer.parseInt(stringItem[2]);
                    chance = Integer.parseInt(stringItem[1]);
                    rng = rand.nextInt(100);
                    if (rng <= chance - 1) {
                        Item item = Item.func_111206_d((String)stringItem[0]);
                        realquantity = rand.nextInt(quantity);
                        for (int j = 0; j <= realquantity; ++j) {
                            BlockPos pos = event.getEntity().func_180425_c();
                            event.getDrops().add(new EntityItem(event.getEntity().func_130014_f_(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(item)));
                        }
                    }
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem with loot event", (Throwable)e);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70170_p.field_72995_K) {
            EntityPlayer entityPlayer = event.player;
        }
    }

    @SubscribeEvent
    public void playerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer && SRPConfig.cothActive && SRPConfig.infadventurerEnabled && event.getSource().func_76346_g() instanceof EntityParasiteBase) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (!player.func_70644_a(SRPPotions.COTH_E)) {
                return;
            }
            World world = player.field_70170_p;
            EntityInfPlayer out = new EntityInfPlayer(world);
            ItemStack head = new ItemStack(player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b());
            ItemStack legs = new ItemStack(player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b());
            ItemStack feet = new ItemStack(player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b());
            if (head.func_77973_b() != Items.field_190931_a) {
                out.func_184201_a(EntityEquipmentSlot.HEAD, head);
                out.setHelmetSlot(true);
            }
            out.func_184201_a(EntityEquipmentSlot.LEGS, legs);
            out.func_184201_a(EntityEquipmentSlot.FEET, feet);
            out.func_96094_a(player.func_70005_c_());
            out.func_174805_g(true);
            out.func_82149_j((Entity)player);
            out.func_180482_a(world.func_175649_E(new BlockPos((Entity)out)), null);
            world.func_72838_d((Entity)out);
            world.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)out), 0);
            out.particleStatus(7);
            out.cannotDespawn(false);
            return;
        }
    }

    @SubscribeEvent
    public void playerSleep(PlayerSleepInBedEvent event) {
        if (!SRPConfig.useEvolution) {
            return;
        }
        SRPWorldData data = SRPWorldData.get(event.getEntityPlayer().field_70170_p);
        if (data.getEvolutionPhase() >= SRPConfig.evolutionSleepDenied) {
            event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("message.srparasites.evolutionsleep", new Object[0]), true);
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            return;
        }
    }

    @SubscribeEvent
    public void playerUp(PlayerWakeUpEvent event) {
        if (!SRPConfig.useEvolution || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        SRPWorldData data = SRPWorldData.get(event.getEntityPlayer().field_70170_p);
        World world = event.getEntityPlayer().field_70170_p;
        if (event.getEntity().field_70170_p.func_72820_D() % (long)SRPConfig.dayTickValue < 13000L) {
            switch (data.getEvolutionPhase()) {
                case 0: {
                    data.setTotalKills(SRPConfig.sleepPenaltyZero, true, world);
                    break;
                }
                case 1: {
                    data.setTotalKills(SRPConfig.sleepPenaltyOne, true, world);
                    break;
                }
                case 2: {
                    data.setTotalKills(SRPConfig.sleepPenaltyTwo, true, world);
                    break;
                }
                case 3: {
                    data.setTotalKills(SRPConfig.sleepPenaltyThree, true, world);
                    break;
                }
                case 4: {
                    data.setTotalKills(SRPConfig.sleepPenaltyFour, true, world);
                    break;
                }
                case 5: {
                    data.setTotalKills(SRPConfig.sleepPenaltyFive, true, world);
                    break;
                }
                case 6: {
                    data.setTotalKills(SRPConfig.sleepPenaltySix, true, world);
                    break;
                }
                case 7: {
                    data.setTotalKills(SRPConfig.sleepPenaltySeven, true, world);
                    break;
                }
                case 8: {
                    data.setTotalKills(SRPConfig.sleepPenaltyEight, true, world);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        List entityList = event.world.field_72996_f;
        for (int i = 0; i < entityList.size(); ++i) {
            Entity entity = (Entity)entityList.get(i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(MouseEvent event) {
        if (event.getButton() == 0 && event.isButtonstate()) {
            float reach;
            RayTraceResult mov;
            IHaveReach ieri;
            ItemStack itemstack;
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP thePlayer = mc.field_71439_g;
            if (thePlayer != null && (itemstack = thePlayer.func_184614_ca()) != null && (ieri = itemstack.func_77973_b() instanceof IHaveReach ? (IHaveReach)itemstack.func_77973_b() : null) != null && (mov = this.getMouseOverExtended(reach = ieri.getReach())) != null && mov.field_72308_g != null && mov.field_72308_g.field_70172_ad == 0 && mov.field_72308_g != thePlayer) {
                SRPMain.network.sendToServer((IMessage)new SRPPacketMeleeRange(mov.field_72308_g.func_145782_y()));
            }
        }
    }

    public RayTraceResult getMouseOverExtended(float dist) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        Entity theRenderViewEntity = mc.func_175606_aa();
        AxisAlignedBB theViewBoundingBox = new AxisAlignedBB(theRenderViewEntity.field_70165_t - 0.5, theRenderViewEntity.field_70163_u - 0.0, theRenderViewEntity.field_70161_v - 0.5, theRenderViewEntity.field_70165_t + 0.5, theRenderViewEntity.field_70163_u + 1.5, theRenderViewEntity.field_70161_v + 0.5);
        RayTraceResult returnMOP = null;
        if (mc.field_71441_e != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.func_174822_a(var2, 0.0f);
            double calcdist = var2;
            Vec3d pos = theRenderViewEntity.func_174824_e(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.field_72307_f.func_72438_d(pos);
            }
            Vec3d lookvec = theRenderViewEntity.func_70676_i(0.0f);
            Vec3d var8 = pos.func_72441_c(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.field_71441_e.func_72839_b(theRenderViewEntity, theViewBoundingBox.func_72321_a(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2).func_72314_b((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.func_70067_L()) continue;
                float bordersize = entity.func_70111_Y();
                AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f), entity.field_70163_u, entity.field_70161_v - (double)(entity.field_70130_N / 2.0f), entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
                aabb.func_72321_a((double)bordersize, (double)bordersize, (double)bordersize);
                RayTraceResult mop0 = aabb.func_72327_a(pos, var8);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !((d1 = pos.func_72438_d(mop0.field_72307_f)) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new RayTraceResult(pointedEntity);
            }
        }
        return returnMOP;
    }
}

