/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TooltipFixer {
    @SubscribeEvent
    public static void configTooltip(RenderTooltipEvent.Pre event) {
        ArrayList<String> lines = event.getLines();
        boolean fixNewlines = false;
        boolean fillScreen = false;
        for (String string : lines) {
            if (string.contains("FIXNEWLINES")) {
                fixNewlines = true;
            }
            if (!string.contains("FILLSCREEN")) continue;
            fillScreen = true;
        }
        if (fixNewlines || fillScreen) {
            String[] oldLines = lines.toArray(new String[lines.size()]);
            lines = new ArrayList<String>();
            if (fixNewlines) {
                for (String string : oldLines) {
                    for (String s : string.split("\\\\n")) {
                        lines.add(s.replaceAll("FIXNEWLINES[ ]*", "").replaceAll("FILLSCREEN[ ]*", ""));
                    }
                }
            } else {
                for (String string : oldLines) {
                    lines.add(string.replaceAll("FILLSCREEN[ ]*", ""));
                }
            }
            event.setCanceled(true);
            if (fillScreen) {
                GuiUtils.drawHoveringText(lines, (int)0, (int)0, (int)event.getScreenWidth(), (int)event.getScreenHeight(), (int)Integer.MAX_VALUE, (FontRenderer)event.getFontRenderer());
            } else {
                GuiUtils.drawHoveringText(lines, (int)event.getX(), (int)event.getY(), (int)event.getScreenWidth(), (int)event.getScreenHeight(), (int)event.getMaxWidth(), (FontRenderer)event.getFontRenderer());
            }
        }
    }
}

