/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.controlintercept;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.Network;
import com.fantasticsource.tools.ReflectionTool;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

public class ControlEvent
extends Event {
    protected static Map<String, KeyBinding> keybinds;
    protected static Map<KeyBinding, Boolean> keybindStates;
    protected static Map<KeyBinding, Boolean> rawKeybindStates;
    public String name;
    public KeyBinding binding = null;
    public boolean state;
    public Boolean lastState;
    public String identifier = "";
    public EntityPlayerMP player = null;
    protected ArrayList<String> queueToServer = new ArrayList();
    protected boolean cancelOriginal = false;

    protected ControlEvent(String name, KeyBinding binding, boolean state, Boolean lastState) {
        this.name = name;
        this.binding = binding;
        this.state = state;
        this.lastState = lastState;
    }

    public ControlEvent(String name, boolean state, Boolean lastState, String identifier) {
        this.name = name;
        this.state = state;
        this.lastState = lastState;
        this.identifier = identifier;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void interceptControls(InputEvent inputEvent) {
        for (ControlEvent event : ControlEvent.updateStatesAndReportChanged()) {
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.cancelOriginal) {
                ControlEvent.setKeyState(event.binding, event.lastState);
            } else {
                keybindStates.put(event.binding, event.state);
            }
            Iterator<String> iterator = event.queueToServer.iterator();
            while (iterator.hasNext()) {
                String identifier;
                event.identifier = identifier = iterator.next();
                Network.WRAPPER.sendToServer((IMessage)new Network.ControlEventPacket(event));
            }
        }
    }

    protected static ArrayList<ControlEvent> updateStatesAndReportChanged() {
        ArrayList<ControlEvent> result = new ArrayList<ControlEvent>();
        for (Map.Entry<String, KeyBinding> entry : keybinds.entrySet()) {
            KeyBinding binding = entry.getValue();
            boolean state = binding.func_151470_d();
            boolean lastState = keybindStates.computeIfAbsent(binding, o -> false);
            boolean lastRawState = rawKeybindStates.computeIfAbsent(binding, o -> false);
            if (state != lastState) {
                if (state != lastRawState) {
                    result.add(new ControlEvent(entry.getKey(), binding, state, lastState));
                } else {
                    ControlEvent.setKeyState(binding, lastState);
                }
            }
            rawKeybindStates.put(binding, state);
        }
        return result;
    }

    protected static void setKeyState(KeyBinding binding, boolean state) {
        if (binding.func_151470_d() == state) {
            return;
        }
        KeyBinding.func_74510_a((int)binding.func_151463_i(), (boolean)state);
        if (state) {
            KeyBinding.func_74507_a((int)binding.func_151463_i());
        } else {
            while (binding.func_151468_f()) {
            }
        }
    }

    public void cancelOriginal() {
        this.cancelOriginal = true;
    }

    public void sendToServer(String identifier) {
        if (identifier == null || identifier.equals("")) {
            throw new IllegalArgumentException("Identifier cannot be null or empty!");
        }
        this.queueToServer.add(identifier);
    }

    public ControlEvent setPlayer(EntityPlayerMP player) {
        this.player = player;
        return this;
    }

    static {
        keybindStates = new LinkedHashMap<KeyBinding, Boolean>();
        rawKeybindStates = new LinkedHashMap<KeyBinding, Boolean>();
        try {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                keybinds = (Map)ReflectionTool.getField(KeyBinding.class, "field_74516_a", "KEYBIND_ARRAY").get(null);
                ControlEvent.updateStatesAndReportChanged();
                MinecraftForge.EVENT_BUS.register(ControlEvent.class);
            }
        }
        catch (IllegalAccessException e) {
            MCTools.crash(e, true);
        }
    }
}

