/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.data;

import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.Network;
import com.fantasticsource.tools.component.CStringUTF8;
import com.fantasticsource.tools.component.Component;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class CDataHandler
extends Component {
    private static final LinkedHashMap<Class<? extends CDataHandler>, LinkedHashMap<String, CDataHandler>> SERVER_DATA_HANDLERS = new LinkedHashMap();
    private static final LinkedHashMap<Class<? extends CDataHandler>, LinkedHashMap<String, CDataHandler>> SYNCED_DATA_HANDLERS = new LinkedHashMap();
    String key;
    final boolean sync;

    public CDataHandler() {
        this.sync = true;
    }

    public CDataHandler(String key, boolean sync) {
        this.key = key;
        this.sync = sync;
        if (sync) {
            SYNCED_DATA_HANDLERS.computeIfAbsent(this.getClass(), o -> new LinkedHashMap()).put(key, this);
        } else {
            SERVER_DATA_HANDLERS.computeIfAbsent(this.getClass(), o -> new LinkedHashMap()).put(key, this);
        }
        if (sync && MCTools.hosting()) {
            for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                Network.WRAPPER.sendTo((IMessage)new Network.GenericComponentPacket(this), player);
            }
        }
    }

    @Override
    public CDataHandler write(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
        return this;
    }

    @Override
    public CDataHandler read(ByteBuf buf) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
        return this;
    }

    @Override
    public CDataHandler save(OutputStream stream) {
        new CStringUTF8().set(this.key).save(stream);
        return this;
    }

    @Override
    public CDataHandler load(InputStream stream) {
        this.key = new CStringUTF8().load((InputStream)stream).value;
        return this;
    }

    @Override
    public CDataHandler writeText(BufferedWriter writer) {
        try {
            writer.write(this.key + "\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public CDataHandler readText(BufferedReader reader) {
        try {
            this.key = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public abstract void load();

    public abstract void save();

    public abstract void clear();

    public final void reload() {
        this.clear();
        this.load();
    }

    public final void destroy() {
        LinkedHashMap<String, CDataHandler> dataHandlers;
        LinkedHashMap<String, CDataHandler> linkedHashMap = dataHandlers = this.sync ? SYNCED_DATA_HANDLERS.get(this.getClass()) : SERVER_DATA_HANDLERS.get(this.getClass());
        if (dataHandlers != null) {
            dataHandlers.remove(this.key);
            if (dataHandlers.size() == 0) {
                if (this.sync) {
                    SYNCED_DATA_HANDLERS.remove(this.getClass());
                } else {
                    SERVER_DATA_HANDLERS.remove(this.getClass());
                }
            }
        }
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            Network.WRAPPER.sendTo((IMessage)new Network.GenericComponentPacket(new Removal(this.key)), player);
        }
    }

    public final void syncToClient(EntityPlayerMP player) {
        Network.WRAPPER.sendTo((IMessage)new Network.GenericComponentPacket(this), player);
    }

    @Override
    public void onClientSync() {
        SYNCED_DATA_HANDLERS.computeIfAbsent(this.getClass(), o -> new LinkedHashMap()).put(this.key, this);
    }

    @SubscribeEvent
    public static void syncOnLogin(PlayerEvent.PlayerLoggedInEvent event) {
        for (LinkedHashMap<String, CDataHandler> handlers : SYNCED_DATA_HANDLERS.values()) {
            for (CDataHandler handler : handlers.values()) {
                handler.syncToClient((EntityPlayerMP)event.player);
            }
        }
    }

    protected static void load(Class<? extends CDataHandler> cls) {
        for (LinkedHashMap dataHandlers : new LinkedHashMap[]{SYNCED_DATA_HANDLERS.get(cls), SERVER_DATA_HANDLERS.get(cls)}) {
            if (dataHandlers == null) continue;
            for (CDataHandler handler : dataHandlers.values()) {
                handler.load();
            }
        }
    }

    protected static void clear(Class<? extends CDataHandler> cls) {
        LinkedHashMap<String, CDataHandler> dataHandlers = SYNCED_DATA_HANDLERS.get(cls);
        if (dataHandlers != null) {
            for (CDataHandler handler : dataHandlers.values()) {
                handler.load();
            }
        }
    }

    public static CDataHandler get(Class<? extends CDataHandler> cls, String key, boolean sync) {
        LinkedHashMap<String, CDataHandler> dataHandlers = sync ? SYNCED_DATA_HANDLERS.get(cls) : SERVER_DATA_HANDLERS.get(cls);
        return dataHandlers == null ? null : dataHandlers.get(key);
    }

    private static class Removal
    extends CDataHandler {
        public Removal(String key) {
            this.key = key;
        }

        @Override
        public void load() {
        }

        @Override
        public void save() {
        }

        @Override
        public void clear() {
        }

        @Override
        public void onClientSync() {
            LinkedHashMap dataHandlers = (LinkedHashMap)SYNCED_DATA_HANDLERS.get(this.getClass());
            if (dataHandlers != null) {
                dataHandlers.remove(this.key);
                if (dataHandlers.size() == 0) {
                    SYNCED_DATA_HANDLERS.remove(this.getClass());
                }
            }
        }
    }
}

