/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.view;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.view.GUIView;
import com.fantasticsource.tools.Tools;

public class GUIAutocroppedView
extends GUIView {
    public GUIElement background;
    protected double padding;

    public GUIAutocroppedView(GUIScreen screen) {
        this(screen, 0.0, null);
    }

    public GUIAutocroppedView(GUIScreen screen, double padding) {
        this(screen, padding, null);
    }

    public GUIAutocroppedView(GUIScreen screen, GUIElement background) {
        this(screen, 0.0, background);
    }

    public GUIAutocroppedView(GUIScreen screen, double padding, GUIElement background) {
        super(screen, 1.0, 1.0);
        this.padding = Math.min(padding, 0.5);
        this.background = background;
        if (background != null) {
            background.autoplace = false;
            this.add(background);
        }
    }

    public GUIAutocroppedView(GUIScreen screen, double x, double y) {
        this(screen, x, y, 0.0, null);
    }

    public GUIAutocroppedView(GUIScreen screen, double x, double y, double padding) {
        this(screen, x, y, padding, null);
    }

    public GUIAutocroppedView(GUIScreen screen, double x, double y, GUIElement background) {
        this(screen, x, y, 0.0, background);
    }

    public GUIAutocroppedView(GUIScreen screen, double x, double y, double padding, GUIElement background) {
        super(screen, x, y, 1.0, 1.0);
        this.padding = Math.min(padding, 0.5);
        this.background = background;
        if (background != null) {
            background.autoplace = false;
            this.add(background);
        }
    }

    @Override
    public GUIAutocroppedView recalc(int subIndexChanged) {
        this.width = 1.0;
        this.height = 1.0;
        if (this.parent == null) {
            return this;
        }
        this.recalcAndRepositionSubElements(0);
        this.width = 0.0;
        this.height = 0.0;
        switch (this.subElementAutoplaceMethod) {
            case -1: {
                double minY = Double.MAX_VALUE;
                for (GUIElement element : this.children) {
                    if (element == this.background) continue;
                    minY = Tools.min(minY, element.y);
                    this.width = Tools.max(this.width, element.width);
                    this.height = Tools.max(this.height, element.height);
                }
                this.height -= minY;
                break;
            }
            case 0: {
                for (GUIElement element : this.children) {
                    if (element == this.background) continue;
                    this.width = Tools.max(this.width, element.x + element.width);
                    this.height = Tools.max(this.height, element.y + element.height);
                }
                break;
            }
            case 8: {
                for (GUIElement element : this.children) {
                    if (element == this.background) continue;
                    this.width = Tools.max(this.width, element.width);
                    this.height = Tools.max(this.height, element.y + element.height);
                }
                break;
            }
            case 10: {
                for (GUIElement element : this.children) {
                    if (element == this.background) continue;
                    this.width = Tools.max(this.width, element.width);
                    this.height = Tools.max(this.height, element.y + element.height);
                }
                break;
            }
            case 11: {
                for (GUIElement element : this.children) {
                    if (element == this.background) continue;
                    this.width = Tools.max(this.width, element.x + element.width);
                    this.height = Tools.max(this.height, element.height);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented autoplace type: " + this.subElementAutoplaceMethod);
            }
        }
        this.recalcAndRepositionSubElements(0);
        double paddingPx = (double)Tools.min(this.absolutePxWidth(), this.absolutePxHeight()) * this.padding;
        double xPad = paddingPx / (double)this.parent.absolutePxWidth();
        double yPad = paddingPx / (double)this.parent.absolutePxHeight();
        this.width += xPad * 2.0;
        this.height += yPad * 2.0;
        xPad /= this.width;
        yPad /= this.height;
        for (GUIElement element : this.children) {
            if (element == this.background) continue;
            element.x += (0.5 - element.x) * 2.0 * xPad;
            element.y += (0.5 - element.y) * 2.0 * yPad;
            element.recalc(0);
        }
        this.postRecalc();
        return this;
    }
}

