/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.screen;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.Namespace;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.other.GUIDarkenedBackground;
import com.fantasticsource.mctools.gui.element.other.GUIVerticalScrollbar;
import com.fantasticsource.mctools.gui.element.text.GUILabeledTextInput;
import com.fantasticsource.mctools.gui.element.text.GUINavbar;
import com.fantasticsource.mctools.gui.element.text.GUITextButton;
import com.fantasticsource.mctools.gui.element.text.filter.FilterNotEmpty;
import com.fantasticsource.mctools.gui.element.view.GUIList;
import com.fantasticsource.tools.datastructures.Color;
import java.util.LinkedHashSet;

public class StringListGUI
extends GUIScreen {
    protected String title;

    protected StringListGUI(String title) {
        this.title = title;
    }

    public static void show(String title, final String prompt, final String baseName, LinkedHashSet<String> strings) {
        final StringListGUI gui = new StringListGUI(title);
        StringListGUI.showStacked(gui);
        gui.drawStack = false;
        gui.root.add(new GUIDarkenedBackground(gui));
        GUINavbar navbar = new GUINavbar(gui);
        GUITextButton done = new GUITextButton((GUIScreen)gui, "Done", Color.GREEN);
        GUITextButton cancel = new GUITextButton((GUIScreen)gui, "Cancel", Color.RED);
        gui.root.addAll(navbar, done, cancel);
        GUIList list = new GUIList((GUIScreen)gui, true, 0.98, 1.0 - (cancel.y + cancel.height), new GUIElement[0]){

            @Override
            public GUIElement[] newLineDefaultElements() {
                Namespace namespace = gui.namespaces.computeIfAbsent("Strings", o -> new Namespace());
                String nameString = namespace.getFirstAvailableNumberedName(baseName);
                GUILabeledTextInput input = new GUILabeledTextInput((GUIScreen)gui, prompt, nameString, FilterNotEmpty.INSTANCE).setNamespace("Strings");
                return new GUIElement[]{input};
            }
        };
        list.addRemoveChildActions(element -> {
            if (element instanceof GUIList.Line) {
                GUIList.Line line = (GUIList.Line)element;
                GUILabeledTextInput labeledTextInput = (GUILabeledTextInput)line.getLineElement(0);
                ((Namespace)gui.namespaces.get((Object)"Strings")).inputs.remove(labeledTextInput.input);
            }
            return false;
        });
        GUIVerticalScrollbar scrollbar = new GUIVerticalScrollbar((GUIScreen)gui, 0.02, 1.0 - (cancel.y + cancel.height), Color.GRAY, Color.BLANK, Color.WHITE, (Color)Color.BLANK, list);
        gui.root.addAll(list, scrollbar);
        for (String s : strings) {
            ((GUILabeledTextInput)list.addLine().getLineElement(0)).setText(s);
        }
        cancel.addRecalcActions(() -> {
            list.height = 1.0 - (cancel.y + cancel.height);
            scrollbar.height = 1.0 - (cancel.y + cancel.height);
        });
        Runnable[] runnableArray = new Runnable[1];
        runnableArray[0] = gui::close;
        cancel.addClickActions(runnableArray);
        done.addClickActions(() -> {
            for (GUIList.Line line : list.getLines()) {
                if (((GUILabeledTextInput)line.getLineElement(0)).valid()) continue;
                return;
            }
            strings.clear();
            for (GUIList.Line line : list.getLines()) {
                strings.add(((GUILabeledTextInput)line.getLineElement(0)).getText());
            }
            gui.close();
        });
    }

    @Override
    public String title() {
        return this.title;
    }
}

