/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.items;

import java.util.Collection;
import java.util.Iterator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemMatcher {
    public static boolean stacksMatch(ItemStack stack1, ItemStack stack2) {
        return ItemMatcher.stacksMatch(stack1, stack2, true);
    }

    public static boolean stacksMatch(ItemStack stack1, ItemStack stack2, boolean testCount) {
        if (stack1 == stack2) {
            return true;
        }
        if (testCount && stack1.func_190916_E() != stack2.func_190916_E()) {
            return false;
        }
        Item item = stack1.func_77973_b();
        if (item != stack2.func_77973_b()) {
            return false;
        }
        if (!item.func_77645_m() && item.getMetadata(stack1) != item.getMetadata(stack2)) {
            return false;
        }
        NBTTagCompound compound1 = stack1.func_77978_p();
        NBTTagCompound compound2 = stack2.func_77978_p();
        return compound1 == null ? compound2 == null : compound1.equals((Object)compound2);
    }

    public static boolean stacksMatch(Collection<ItemStack> stacks1, Collection<ItemStack> stacks2) {
        return ItemMatcher.stacksMatch(stacks1, stacks2, true);
    }

    public static boolean stacksMatch(Collection<ItemStack> stacks1, Collection<ItemStack> stacks2, boolean testCount) {
        ItemStack stack1;
        Iterator<ItemStack> iterator1 = stacks1.iterator();
        for (ItemStack stack2 : stacks2) {
            stack1 = iterator1.next();
            if (stack1 == stack2) continue;
            if (testCount && stack1.func_190916_E() != stack2.func_190916_E()) {
                return false;
            }
            Item item = stack1.func_77973_b();
            if (item != stack2.func_77973_b()) {
                return false;
            }
            if (item.func_77645_m() || item.getMetadata(stack1) == item.getMetadata(stack2)) continue;
            return false;
        }
        iterator1 = stacks1.iterator();
        for (ItemStack stack2 : stacks2) {
            stack1 = iterator1.next();
            NBTTagCompound compound1 = stack1.func_77978_p();
            NBTTagCompound compound2 = stack2.func_77978_p();
            if (!(compound1 == null ? compound2 != null : !compound1.equals((Object)compound2))) continue;
            return false;
        }
        return true;
    }

    public static boolean stacksMatch(ItemStack[] stacks1, ItemStack[] stacks2) {
        return ItemMatcher.stacksMatch(stacks1, stacks2, true);
    }

    public static boolean stacksMatch(ItemStack[] stacks1, ItemStack[] stacks2, boolean testCount) {
        ItemStack stack2;
        ItemStack stack1;
        int i;
        int size = stacks1.length;
        for (i = 0; i < size; ++i) {
            stack1 = stacks1[i];
            stack2 = stacks2[i];
            if (stack1 == stack2) continue;
            if (testCount && stack1.func_190916_E() != stack2.func_190916_E()) {
                return false;
            }
            Item item = stack1.func_77973_b();
            if (item != stack2.func_77973_b()) {
                return false;
            }
            if (item.func_77645_m() || item.getMetadata(stack1) == item.getMetadata(stack2)) continue;
            return false;
        }
        for (i = 0; i < size; ++i) {
            stack1 = stacks1[i];
            stack2 = stacks2[i];
            NBTTagCompound compound1 = stack1.func_77978_p();
            NBTTagCompound compound2 = stack2.func_77978_p();
            if (!(compound1 == null ? compound2 != null : !compound1.equals((Object)compound2))) continue;
            return false;
        }
        return true;
    }
}

