/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools;

import com.fantasticsource.tools.Tools;
import java.util.Date;
import java.util.LinkedHashMap;

public class TrigLookupTable {
    protected static final LinkedHashMap<Integer, TrigLookupTable> TABLES = new LinkedHashMap();
    public static final TrigLookupTable TRIG_TABLE_1024 = new TrigLookupTable(1024);
    private double[] table;
    private double[] invtable;

    public TrigLookupTable(int granularity) {
        this.table = new double[granularity];
        this.invtable = new double[granularity];
        double step = Math.PI * 2 / (double)granularity;
        double invstep = 2.0 / (double)granularity;
        for (int i = 0; i < granularity; ++i) {
            double theta = step * (double)i;
            this.table[i] = theta == Math.PI ? 0.0 : Math.sin(theta);
            double val = invstep * (double)i - 1.0;
            this.invtable[i] = Math.asin(val);
        }
    }

    public static TrigLookupTable getInstance(int granularity) {
        return TABLES.computeIfAbsent(granularity, o -> new TrigLookupTable(granularity));
    }

    public static void test() {
        int i;
        TrigLookupTable t = new TrigLookupTable(1024);
        double[] doubles = new double[1000000];
        System.out.println("All tests are 1000000 runs of each method\r\n");
        System.out.println("The TrigLookupTable has a granularity of 1024\r\n");
        Date d1 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = t.sin(Math.random() * 2000000.0 - 1000000.0);
        }
        Date d2 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = Math.sin(Math.random() * 2000000.0 - 1000000.0);
        }
        Date d3 = new Date();
        System.out.println("TrigLookupTable.sin = " + (d2.getTime() - d1.getTime()));
        System.out.println("Math.sin = " + (d3.getTime() - d2.getTime()) + "\r\n");
        d1 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = t.cos(Math.random() * 2000000.0 - 1000000.0);
        }
        d2 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = Math.cos(Math.random() * 2000000.0 - 1000000.0);
        }
        d3 = new Date();
        System.out.println("TrigLookupTable.cos = " + (d2.getTime() - d1.getTime()));
        System.out.println("Math.cos = " + (d3.getTime() - d2.getTime()) + "\r\n");
        d1 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = t.tan(Math.random() * 2000000.0 - 1000000.0);
        }
        d2 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = Math.tan(Math.random() * 2000000.0 - 1000000.0);
        }
        d3 = new Date();
        System.out.println("TrigLookupTable.tan = " + (d2.getTime() - d1.getTime()));
        System.out.println("Math.tan = " + (d3.getTime() - d2.getTime()) + "\r\n");
        d1 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = t.arcsin(Math.random() * 2.0 - 1.0);
        }
        d2 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = Math.asin(Math.random() * 2.0 - 1.0);
        }
        d3 = new Date();
        System.out.println("TrigLookupTable.arcsin = " + (d2.getTime() - d1.getTime()));
        System.out.println("Math.asin = " + (d3.getTime() - d2.getTime()) + "\r\n");
        d1 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = t.arccos(Math.random() * 2.0 - 1.0);
        }
        d2 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = Math.acos(Math.random() * 2.0 - 1.0);
        }
        d3 = new Date();
        System.out.println("TrigLookupTable.arccos = " + (d2.getTime() - d1.getTime()));
        System.out.println("Math.acos = " + (d3.getTime() - d2.getTime()) + "\r\n");
        d1 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = t.arctan(Math.random() * 2000000.0 - 1000000.0);
        }
        d2 = new Date();
        for (i = 0; i < 1000000; ++i) {
            doubles[i] = Math.atan(Math.random() * 2000000.0 - 1000000.0);
        }
        d3 = new Date();
        System.out.println("TrigLookupTable.arctan = " + (d2.getTime() - d1.getTime()));
        System.out.println("Math.atan = " + (d3.getTime() - d2.getTime()) + "\r\n");
    }

    public double sin(double theta) {
        int i = (int)Math.round((double)this.table.length * (theta = Tools.posMod(theta, Math.PI * 2)) / (Math.PI * 2));
        if (i == this.table.length) {
            i = 0;
        }
        return this.table[i];
    }

    public double cos(double theta) {
        return this.sin(theta + 1.5707963267948966);
    }

    public double tan(double theta) {
        return this.sin(theta) / this.cos(theta);
    }

    public double arcsin(double input) {
        if (input < -1.0 || input > 1.0) {
            throw new IllegalArgumentException("arcsin() and arccos() can only take in from -1 to 1.  Input was " + input);
        }
        int i = (int)Math.round((double)this.invtable.length * (input + 1.0) * 0.5);
        if (i == this.invtable.length) {
            return 1.5707963267948966;
        }
        return this.invtable[i];
    }

    public double arccos(double input) {
        return 1.5707963267948966 - this.arcsin(input);
    }

    public double arctan(double input) {
        if (input == 0.0) {
            return 0.0;
        }
        if (input == Double.POSITIVE_INFINITY) {
            return 1.5707963267948966;
        }
        if (input == Double.NEGATIVE_INFINITY) {
            return -1.5707963267948966;
        }
        if (input > 0.0) {
            if (input < 1.0) {
                return this.arcsin(input / Math.sqrt(1.0 + input * input));
            }
            double x = 1.0 / input;
            return this.arccos(x / Math.sqrt(1.0 + x * x));
        }
        if (input > -1.0) {
            return this.arcsin(input / Math.sqrt(1.0 + input * input));
        }
        double x = 1.0 / input;
        return this.arccos(x / Math.sqrt(1.0 + x * x)) - Math.PI;
    }

    public double arctanFullcircle(double x1, double y1, double x2, double y2) {
        double x = x2 - x1;
        double y = y1 - y2;
        if (x > 0.0) {
            if (y > 0.0) {
                if (x > y) {
                    return this.arcsin(y / Math.sqrt(x * x + y * y));
                }
                return this.arccos(x / Math.sqrt(x * x + y * y));
            }
            if (y < 0.0) {
                if (x > -y) {
                    return Math.PI * 2 + this.arcsin(y / Math.sqrt(x * x + y * y));
                }
                return Math.PI * 2 - this.arccos(x / Math.sqrt(x * x + y * y));
            }
            return 0.0;
        }
        if (x < 0.0) {
            if (y > 0.0) {
                if (-x > y) {
                    return Math.PI - this.arcsin(y / Math.sqrt(x * x + y * y));
                }
                return this.arccos(x / Math.sqrt(x * x + y * y));
            }
            if (y < 0.0) {
                if (x < y) {
                    return Math.PI - this.arcsin(y / Math.sqrt(x * x + y * y));
                }
                return Math.PI * 2 - this.arccos(x / Math.sqrt(x * x + y * y));
            }
            return Math.PI;
        }
        if (y > 0.0) {
            return 1.5707963267948966;
        }
        if (y < 0.0) {
            return 4.71238898038469;
        }
        return 0.0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("" + this.table[0]);
        for (int i = 1; i < this.table.length; ++i) {
            str.append("\r\n").append(this.table[i]);
        }
        return str.toString();
    }

    public double[] getArray() {
        return this.table;
    }

    public double[] getInvArray() {
        return this.invtable;
    }

    public int getGranularity() {
        return this.table.length;
    }

    static {
        TABLES.put(1024, TRIG_TABLE_1024);
    }
}

