/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class BeaconReplacementHandler {
    private static Potion[][] defaultEffectsList = null;
    private static List<Replacer> replacers;

    public static void parse(String[] lines) {
        replacers = new LinkedList<Replacer>();
        for (String s : lines) {
            Replacer r = Replacer.fromString(s);
            if (r == null) continue;
            replacers.add(r);
        }
        BeaconReplacementHandler.commit();
    }

    private static void commit() {
        if (defaultEffectsList == null) {
            defaultEffectsList = new Potion[TileEntityBeacon.field_146009_a.length][2];
            for (int i = 0; i < TileEntityBeacon.field_146009_a.length; ++i) {
                Potion[] a = TileEntityBeacon.field_146009_a[i];
                for (int j = 0; j < a.length && j < defaultEffectsList[i].length; ++j) {
                    BeaconReplacementHandler.defaultEffectsList[i][j] = a[j];
                }
            }
        }
        Set validEffects = (Set)ObfuscationReflectionHelper.getPrivateValue(TileEntityBeacon.class, null, (String)"field_184280_f");
        for (Replacer r : replacers) {
            validEffects.add(r.potion);
        }
    }

    public static void update(TileEntityBeacon beacon) {
        for (int i = 0; i < TileEntityBeacon.field_146009_a.length; ++i) {
            Potion[] a = TileEntityBeacon.field_146009_a[i];
            for (int j = 0; j < a.length && j < defaultEffectsList[i].length; ++j) {
                a[j] = defaultEffectsList[i][j];
            }
        }
        BlockPos pos = beacon.func_174877_v();
        World world = beacon.func_145831_w();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                BlockPos targetPos = pos.func_177982_a(i, 0, j);
                IBlockState state = world.func_180495_p(targetPos);
                replacers.forEach(r -> r.replace(state));
            }
        }
    }

    private static class Replacer {
        private final Block block;
        private final int meta;
        private final int layer;
        private final int effect;
        private final Potion potion;

        public Replacer(Block block, int meta, int layer, int effect, Potion potion) {
            this.block = block;
            this.meta = meta;
            this.layer = layer;
            this.effect = effect;
            this.potion = potion;
        }

        private static Replacer fromString(String s) {
            String[] tokens = s.split(",");
            if (tokens.length != 5) {
                return null;
            }
            try {
                Block block = Block.func_149684_b((String)tokens[0]);
                int meta = Integer.parseInt(tokens[1]);
                int layer = Integer.parseInt(tokens[2]);
                int effect = Integer.parseInt(tokens[3]);
                Potion potion = Potion.func_180142_b((String)tokens[4]);
                if (potion == null || effect < 0 || effect > 1 || layer < 0 || layer > 3) {
                    return null;
                }
                return new Replacer(block, meta, layer, effect, potion);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public void replace(IBlockState stateAt) {
            if (this.block == null || stateAt.func_177230_c() == this.block && (this.meta == -1 || this.block.func_176201_c(stateAt) == this.meta)) {
                TileEntityBeacon.field_146009_a[this.layer][this.effect] = this.potion;
            }
        }
    }
}

