/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDeadBush;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import snownee.snow.FallingSnowEntity;
import snownee.snow.ModConfig;
import snownee.snow.SnowTile;
import snownee.snow.compat.BiomesOPlentyCompat;
import snownee.snow.compat.FerdinandsFlowersCompat;
import snownee.snow.compat.HarvestCraftCompat;
import snownee.snow.compat.NoTreePunchingCompat;
import snownee.snow.compat.PlantsCompat;
import snownee.snow.compat.PyrotechCompat;
import snownee.snow.compat.WeeeFlowersCompat;
import snownee.snow.compat.XLFoodModCompat;

public class ModSnowBlock
extends BlockSnow {
    protected static final AxisAlignedBB[] SNOW_AABB_MAGIC = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.4375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)};
    public static final PropertyBool TILE = PropertyBool.func_177716_a((String)"tile");

    public ModSnowBlock() {
        if (ModConfig.placeSnowInBlock) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(false)));
        }
        this.setRegistryName("minecraft", "snow_layer");
        this.func_149711_c(0.1f);
        this.func_149672_a(SoundType.field_185856_i);
        this.func_149663_c("snow");
        this.func_149713_g(0);
    }

    protected BlockStateContainer func_180661_e() {
        if (ModConfig.placeSnowInBlock) {
            return new BlockStateContainer((Block)this, new IProperty[]{field_176315_a, TILE});
        }
        return super.func_180661_e();
    }

    public boolean hasTileEntity(IBlockState state) {
        if (ModConfig.placeSnowInBlock) {
            return (Boolean)state.func_177229_b((IProperty)TILE);
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (ModConfig.placeSnowInBlock) {
            return new SnowTile();
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        if (ModConfig.placeSnowInBlock) {
            IBlockState state = super.func_176203_a(meta);
            if (meta >= 8) {
                state = state.func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return super.func_176203_a(meta);
    }

    public int func_176201_c(IBlockState state) {
        int meta = super.func_176201_c(state);
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            meta += 8;
        }
        return meta;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (!ModConfig.thinnerBoundingBox) {
            return super.func_180646_a(blockState, worldIn, pos);
        }
        int layers = (Integer)blockState.func_177229_b((IProperty)field_176315_a);
        BlockPos posUp = pos.func_177984_a();
        if (layers == 8 && worldIn.func_180495_p(posUp).func_185890_d(worldIn, posUp) != null) {
            return field_185505_j;
        }
        return SNOW_AABB_MAGIC[layers - 1];
    }

    public RayTraceResult func_180636_a(IBlockState state, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult hit1 = null;
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            hit1 = this.func_185503_a(pos, start, end, this.getContainedState((IBlockAccess)worldIn, pos).func_185900_c((IBlockAccess)worldIn, pos));
        }
        RayTraceResult hit2 = super.func_180636_a(state, worldIn, pos, start, end);
        if (hit1 == null) {
            return hit2;
        }
        if (hit2 == null) {
            return hit1;
        }
        Vec3d vec1 = hit1.field_72307_f;
        Vec3d vec2 = hit2.field_72307_f;
        if (start.func_72436_e(vec1) < start.func_72436_e(vec2)) {
            return hit1;
        }
        return hit2;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        IBlockState contained;
        AxisAlignedBB aabb = super.func_180640_a(state, worldIn, pos);
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue() && (contained = this.getContainedState((IBlockAccess)worldIn, pos)).func_177230_c() != Blocks.field_150350_a) {
            aabb = aabb.func_111270_a(contained.func_185918_c(worldIn, pos));
        }
        return aabb;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (state.func_177230_c() != this) {
            return false;
        }
        return (Integer)state.func_177229_b((IProperty)field_176315_a) == 8;
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (ModConfig.snowGravity && !BlockFalling.field_149832_M) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!ModConfig.snowGravity) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        } else if (!BlockFalling.field_149832_M) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.checkFallable(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = iblockstate.func_177230_c();
        if (ModConfig.snowOnIce || block != Blocks.field_150432_aD && block != Blocks.field_150403_cj && block != Blocks.field_180401_cv) {
            BlockFaceShape blockfaceshape = iblockstate.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
            return blockfaceshape == BlockFaceShape.SOLID || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b()) || block == this && (Integer)iblockstate.func_177229_b((IProperty)field_176315_a) == 8;
        }
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        if (!ModConfig.snowNeverMelt && worldIn.func_175642_b(EnumSkyBlock.BLOCK, pos) > 11) {
            worldIn.func_175698_g(pos);
            return;
        }
        if (!ModConfig.snowAccumulationDuringSnowfall && !ModConfig.snowAccumulationDuringSnowstorm || random.nextInt(8) > 0 || !worldIn.func_175678_i(pos.func_177984_a())) {
            return;
        }
        boolean flag = false;
        if (worldIn.func_72896_J()) {
            if (ModConfig.snowAccumulationDuringSnowfall) {
                flag = true;
            } else if (ModConfig.snowAccumulationDuringSnowstorm && worldIn.func_72911_I()) {
                flag = true;
            }
        }
        int layers = (Integer)state.func_177229_b((IProperty)field_176315_a);
        if (worldIn.func_175708_f(pos, false)) {
            if (flag) {
                ModSnowBlock.accumulate(worldIn, pos, state, (w, p) -> !(w.func_180495_p(p.func_177977_b()).func_177230_c() instanceof ModSnowBlock) && w.func_175642_b(EnumSkyBlock.BLOCK, p) < 10, true);
            } else if (layers > 1 && !worldIn.func_72896_J() && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
                ModSnowBlock.accumulate(worldIn, pos, state, (w, p) -> !(w.func_180495_p(p.func_177984_a()).func_177230_c() instanceof ModSnowBlock), false);
            }
        }
    }

    private static void accumulate(World world, BlockPos pos, IBlockState centerState, BiPredicate<World, BlockPos> filter, boolean accumulate) {
        int i = (Integer)centerState.func_177229_b((IProperty)field_176315_a);
        for (int j = 0; j < 8; ++j) {
            int k = j / 2;
            EnumFacing direction = EnumFacing.func_176731_b((int)k);
            BlockPos pos2 = pos.func_177972_a(direction);
            if (j % 2 == 1) {
                pos2 = pos2.func_177972_a(EnumFacing.func_176731_b((int)(k + 1)));
            }
            if (!world.func_175667_e(pos2) || !filter.test(world, pos2)) continue;
            IBlockState state = world.func_180495_p(pos2);
            boolean isAir = state.func_177230_c().isAir(state, (IBlockAccess)world, pos2);
            int height = world.func_175725_q(pos2).func_177956_o();
            if (!isAir && state.func_177230_c() != Blocks.field_150431_aC ? !ModSnowBlock.canContainState(state) || height != pos2.func_177956_o() && height != pos2.func_177956_o() + 1 : height != pos2.func_177956_o()) continue;
            if (!Blocks.field_150431_aC.func_176196_c(world, pos2)) continue;
            int l = state.func_177230_c() instanceof ModSnowBlock ? (Integer)state.func_177229_b((IProperty)field_176315_a) : 0;
            if (!(accumulate ? i > l : i < l)) continue;
            i = l;
            pos = pos2;
            break;
        }
        if (accumulate) {
            if (i < 8 && ModSnowBlock.placeLayersOn(world, pos, 1, false, false, 3)) {
                AxisAlignedBB aabb = new AxisAlignedBB(pos);
                for (Entity entity : world.func_72839_b(null, aabb)) {
                    entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + (ModConfig.thinnerBoundingBox ? 0.0625 : 0.125), entity.field_70161_v);
                }
            }
        } else {
            world.func_175656_a(pos, centerState.func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(i - 1)));
        }
    }

    private boolean checkFallable(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos posDown = pos.func_177977_b();
        if ((worldIn.func_175623_d(posDown) || ModSnowBlock.canFallThrough(worldIn.func_180495_p(posDown), worldIn, posDown)) && pos.func_177956_o() >= 0) {
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    worldIn.func_175698_g(pos);
                    FallingSnowEntity entityfallingblock = new FallingSnowEntity(worldIn, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (Integer)state.func_177229_b((IProperty)field_176315_a));
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while (blockpos.func_177956_o() > 0) {
                    IBlockState state2 = worldIn.func_180495_p(blockpos);
                    if (state2.func_177230_c() instanceof BlockSnow) {
                        return true;
                    }
                    if (!ModSnowBlock.canFallThrough(state2, worldIn, blockpos)) break;
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean placeLayersOn(World world, BlockPos pos, int layers, boolean falling, boolean playSound, int flags) {
        IBlockState base;
        if (!Blocks.field_150431_aC.func_176196_c(world, pos)) {
            return false;
        }
        layers = MathHelper.func_76125_a((int)layers, (int)1, (int)8);
        IBlockState state = world.func_180495_p(pos);
        int originLayers = 0;
        boolean flag = false;
        if (state.func_177230_c() == Blocks.field_150431_aC) {
            originLayers = (Integer)state.func_177229_b((IProperty)field_176315_a);
            base = state;
        } else {
            base = Blocks.field_150431_aC.func_176223_P();
            if (ModSnowBlock.canContainState(state)) {
                flag = true;
                base = base.func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(true));
            }
        }
        if (flag || state.func_177230_c() == Blocks.field_150431_aC || state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            TileEntity tile;
            world.func_180501_a(pos, base.func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(originLayers + layers), (int)1, (int)8))), flags);
            if (flag && (tile = world.func_175625_s(pos)) instanceof SnowTile) {
                ((SnowTile)tile).setState(state);
            }
            if (falling) {
                world.func_175641_c(pos, Blocks.field_150431_aC, originLayers, layers);
            } else if (playSound) {
                SoundType soundtype = Blocks.field_150431_aC.getSoundType(state, world, pos, null);
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            }
            if (originLayers + layers > 8 && world.func_180495_p(pos = pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
                world.func_180501_a(pos, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(originLayers + layers - 8), (int)1, (int)8))), flags);
            }
            return true;
        }
        return false;
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int originLayers, int layers) {
        double offsetY = (double)originLayers / 8.0;
        layers *= 10;
        for (int i = 0; i < layers; ++i) {
            double d0 = RANDOM.nextGaussian() * 0.2;
            double d1 = RANDOM.nextGaussian() * 0.02;
            double d2 = RANDOM.nextGaussian() * 0.2;
            worldIn.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, (double)((float)pos.func_177958_n() + RANDOM.nextFloat()), (double)pos.func_177956_o() + offsetY, (double)((float)pos.func_177952_p() + RANDOM.nextFloat()), d0, d1, d2, new int[0]);
        }
        SoundType soundtype = this.getSoundType(state, worldIn, pos, null);
        worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        return true;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)field_176315_a) == 8) {
            return false;
        }
        if (ModConfig.placeSnowInBlock && state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            return this.getContainedState(worldIn, pos).func_185904_a().func_76222_j();
        }
        return ModConfig.snowAlwaysReplaceable || super.func_176200_f(worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!ModConfig.particleThroughLeaves || rand.nextInt(31) != 1) {
            return;
        }
        IBlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        if (stateDown.func_177230_c().isLeaves(stateDown, (IBlockAccess)worldIn, pos.func_177977_b())) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.SNOW_SHOVEL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public static boolean canContainState(IBlockState state) {
        if (!ModConfig.placeSnowInBlock || state.func_177230_c().hasTileEntity(state)) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block instanceof BlockTallGrass || block instanceof BlockFlower || block instanceof BlockSapling || block instanceof BlockMushroom || block instanceof BlockDeadBush) {
            return true;
        }
        if (block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockPane && !(block instanceof BlockStainedGlassPane)) {
            return true;
        }
        return ModSnowBlock.isCompatBlock(block);
    }

    public IBlockState getContainedState(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof SnowTile) {
            return ((SnowTile)tile).getState();
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            IBlockState stateIn = this.getContainedState(worldIn, pos);
            Block block = stateIn.func_177230_c();
            if (block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockPane) {
                return face == EnumFacing.UP ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
            }
            return stateIn.func_193401_d(worldIn, pos, face);
        }
        return super.func_193383_a(worldIn, state, pos, face);
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.getContainedState(world, pos).func_177230_c().canBeConnectedTo(world, pos, facing);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        ModSnowBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)state.func_185890_d((IBlockAccess)worldIn, pos));
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            this.getContainedState((IBlockAccess)worldIn, pos).func_185908_a(worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos).func_185904_a() == Material.field_151579_a && this.hasTileEntity(state)) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof SnowTile) {
                IBlockState newState = ((SnowTile)tile).getState();
                worldIn.func_175713_t(pos);
                if (worldIn.func_175656_a(pos, newState)) {
                    newState.func_177230_c().func_189540_a(newState, worldIn, pos, newState.func_177230_c(), pos.func_177977_b());
                }
            } else {
                worldIn.func_175713_t(pos);
            }
        }
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        if (ModConfig.placeSnowInBlock) {
            return this.getContainedState(worldIn, pos).func_177230_c().func_176205_b(worldIn, pos);
        }
        return super.func_176205_b(worldIn, pos);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return this.hasTileEntity(state) ? EnumPushReaction.BLOCK : EnumPushReaction.DESTROY;
    }

    public static boolean canFallThrough(IBlockState state, World worldIn, BlockPos pos) {
        return state.func_185890_d((IBlockAccess)worldIn, pos) == null;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        if (ModConfig.placeSnowInBlock && (layer == BlockRenderLayer.CUTOUT || layer == BlockRenderLayer.CUTOUT_MIPPED) && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            return true;
        }
        return layer == BlockRenderLayer.SOLID;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ModConfig.placeSnowInBlock) {
            if (((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
                IBlockState contained = this.getContainedState((IBlockAccess)worldIn, pos);
                if (ModSnowBlock.isCompatBlock(contained.func_177230_c())) {
                    try {
                        if (contained.func_177230_c().func_180639_a(worldIn, pos, contained, playerIn, hand, facing, hitX, hitY, hitZ)) {
                            return worldIn.func_175656_a(pos, state.func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(false)));
                        }
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                IBlockState state2;
                ItemStack stack = playerIn.func_184586_b(hand);
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                if (block != null && block != Blocks.field_150350_a && (state2 = block.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, stack.func_77960_j(), (EntityLivingBase)playerIn, hand)) != null && ModSnowBlock.canContainState(state2) && state2.func_177230_c().func_176198_a(worldIn, pos, EnumFacing.UP)) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_180501_a(pos, state2, 48);
                        int i = (Integer)state.func_177229_b((IProperty)field_176315_a);
                        if (ModSnowBlock.placeLayersOn(worldIn, pos, i, false, true, 3) && !playerIn.func_184812_l_()) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer player) {
        if (worldIn.field_72995_K) {
            return;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        if (ModConfig.placeSnowInBlock && ((Boolean)state.func_177229_b((IProperty)TILE)).booleanValue()) {
            try {
                IBlockState contained = this.getContainedState((IBlockAccess)worldIn, pos);
                if (contained.func_185887_b(worldIn, pos) == 0.0f) {
                    worldIn.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)contained));
                    contained.func_177230_c().func_180657_a(worldIn, player, pos, contained, null, player.func_184614_ca());
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)TILE, (Comparable)Boolean.valueOf(false)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isCompatBlock(Block block) {
        return NoTreePunchingCompat.isRock(block) || XLFoodModCompat.isPlant(block) || BiomesOPlentyCompat.isPlantOrGate(block) || HarvestCraftCompat.isGarden(block) || WeeeFlowersCompat.isFlower(block) || PlantsCompat.isPlant(block) || FerdinandsFlowersCompat.isFlower(block) || PyrotechCompat.isRock(block);
    }
}

