/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.structures.city;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulevs.betternether.noise.WorleyNoiseOctaved;
import paulevs.betternether.structures.big.BigStructure;
import paulevs.betternether.structures.big.StructureManager;
import paulevs.betternether.structures.city.BigStructureCity;
import paulevs.betternether.structures.city.CityGenerator;

public class CityStructureManager
extends StructureManager {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState LAVA = Blocks.field_150353_l.func_176223_P();
    protected CityGenerator generator = new CityGenerator();
    protected WorleyNoiseOctaved noiseX;
    protected WorleyNoiseOctaved noiseY;
    protected WorleyNoiseOctaved noiseZ;

    public CityStructureManager(long seed) {
        super("city", 80, seed);
        this.random.setSeed(seed);
        this.noiseX = new WorleyNoiseOctaved(this.random.nextLong(), 2);
        this.noiseY = new WorleyNoiseOctaved(this.random.nextLong(), 2);
        this.noiseZ = new WorleyNoiseOctaved(this.random.nextLong(), 2);
    }

    @Override
    protected BigStructure makeStructure(int cx, int cz) {
        this.setSeed(cx, cz);
        BlockPos pos = new BlockPos(cx << 4, 40, cz << 4);
        BigStructureCity cave = new BigStructureCity(pos, cx, cz, this.generator, this.random);
        int caveSize = (int)((double)cave.getCitySide() * 0.6) + this.random.nextInt(50);
        this.makeCave(caveSize, 40, cave);
        List<BlockPos> positions = cave.getPosList(pos);
        List<Integer> radiuses = cave.getRadiuses();
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos cp = positions.get(i);
            int r = radiuses.get(i);
            this.makeCave(r, cp.func_177958_n(), cp.func_177956_o(), cp.func_177952_p(), cave);
        }
        return cave;
    }

    protected void makeCave(int radius, int centerY, BigStructure structure) {
        int bounds = (int)((double)radius * 1.5);
        int rr = radius * radius;
        int minY = 5 - centerY;
        int lavaH = 31 - centerY;
        for (int x = -bounds; x < bounds; ++x) {
            for (int y = minY; y < radius; ++y) {
                int wy = y + centerY - 40;
                int y2 = y * 2;
                for (int z = -bounds; z < bounds; ++z) {
                    double dz;
                    double zz;
                    double dy;
                    double yy;
                    double dx = (double)x + this.noiseX.GetValue((double)y2 * 0.02, (double)z * 0.02) * 20.0;
                    double xx = dx * dx;
                    if (!(xx + (yy = (dy = (double)y2 + this.noiseX.GetValue((double)x * 0.02, (double)z * 0.02) * 20.0) * dy) + (zz = (dz = (double)z + this.noiseX.GetValue((double)y * 0.02, (double)x * 0.02) * 20.0) * dz) < (double)rr)) continue;
                    if (wy > lavaH) {
                        structure.setBlock(AIR, new BlockPos(x, wy, z));
                        continue;
                    }
                    structure.setBlock(LAVA, new BlockPos(x, wy, z));
                }
            }
        }
    }

    protected void makeCave(int radius, int centerX, int centerY, int centerZ, BigStructure structure) {
        int bounds = (int)((double)radius * 1.5);
        int rr = radius * radius;
        int minY = 5 - centerY;
        int lavaH = 31 - centerY;
        for (int x = -bounds; x < bounds; ++x) {
            int wx = x + centerX;
            for (int y = minY; y < bounds; ++y) {
                int wy = y + centerY - 40;
                for (int z = -bounds; z < bounds; ++z) {
                    double dz;
                    double zz;
                    double dy;
                    double yy;
                    int wz = z + centerZ;
                    double dx = (double)x + this.noiseX.GetValue((double)y * 0.02, (double)z * 0.02) * 20.0 - 10.0;
                    double xx = dx * dx;
                    if (!(xx + (yy = (dy = (double)y + this.noiseX.GetValue((double)x * 0.02, (double)z * 0.02) * 20.0 - 10.0) * dy) + (zz = (dz = (double)z + this.noiseX.GetValue((double)y * 0.02, (double)x * 0.02) * 20.0 - 10.0) * dz) < (double)rr)) continue;
                    if (wy > lavaH) {
                        structure.setBlock(AIR, new BlockPos(wx, wy, wz));
                        continue;
                    }
                    structure.setBlock(LAVA, new BlockPos(wx, wy, wz));
                }
            }
        }
    }

    @Override
    public void load(World world) {
        String path = world.func_72860_G().func_75765_b().getAbsolutePath() + "/data/bn_" + this.name + ".nbt";
        File file = new File(path);
        if (file.exists()) {
            try {
                FileInputStream fs = new FileInputStream(file);
                NBTTagCompound root = CompressedStreamTools.func_74796_a((InputStream)fs);
                fs.close();
                NBTTagList structureData = root.func_150295_c("structures", 10);
                for (int i = 0; i < structureData.func_74745_c(); ++i) {
                    BigStructureCity city = new BigStructureCity(structureData.func_150305_b(i), this.generator);
                    this.structures.add(city);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

