/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.suffixtree;

import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectMaps;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.suffixtree.Edge;
import mezz.jei.util.Log;

class Node {
    private final IntList data;
    private Char2ObjectMap<Edge> edges = new Char2ObjectOpenHashMap();
    @Nullable
    private Node suffix = null;

    Node() {
        this.data = new IntArrayList(0);
    }

    void getData(IntSet ret) {
        ret.addAll((IntCollection)this.data);
        for (Edge e : this.edges.values()) {
            e.getDest().getData(ret);
        }
    }

    boolean addRef(int index) {
        if (this.contains(index)) {
            return false;
        }
        this.addIndex(index);
        Node iter = this.suffix;
        while (iter != null && !iter.contains(index)) {
            iter.addIndex(index);
            iter = iter.suffix;
        }
        return true;
    }

    private boolean contains(int index) {
        return this.data.contains(index);
    }

    void addEdge(char ch, Edge e) {
        try {
            this.edges.put(ch, (Object)e);
        }
        catch (UnsupportedOperationException ex) {
            Log.get().warn("Mod added a tree entry after memory optimization!", (Throwable)ex);
            this.edges = new Char2ObjectOpenHashMap(this.edges);
            this.edges.put(ch, (Object)e);
        }
    }

    @Nullable
    Edge getEdge(char ch) {
        return (Edge)this.edges.get(ch);
    }

    @Nullable
    Node getSuffix() {
        return this.suffix;
    }

    void setSuffix(Node suffix) {
        this.suffix = suffix;
    }

    private void addIndex(int index) {
        this.data.add(index);
    }

    public String toString() {
        return "Node: size:" + this.data.size() + " Edges: " + this.edges.toString();
    }

    ObjectCollection<Edge> edges() {
        return this.edges.values();
    }

    void trimToSize() {
        if (this.data instanceof IntArrayList) {
            ((IntArrayList)this.data).trim();
        }
        switch (this.edges.size()) {
            case 0: {
                this.edges = Char2ObjectMaps.emptyMap();
                break;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.edges.entrySet().iterator().next();
                this.edges = Char2ObjectMaps.singleton((Character)((Character)entry.getKey()), entry.getValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.edges = new Char2ObjectArrayMap(this.edges);
            }
        }
    }
}

