/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.item.ItemFishBucket;
import net.theawesomegem.fishingmadebetter.util.ItemStackUtil;
import net.theawesomegem.fishingmadebetter.util.TimeUtil;

public class BetterFishUtil {
    @Nullable
    public static String getFishId(ItemStack itemStack) {
        return !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("FishId") ? null : itemStack.func_77978_p().func_74779_i("FishId");
    }

    public static int getFishWeight(ItemStack itemStack) {
        return !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("FishWeight") ? 1 : itemStack.func_77978_p().func_74762_e("FishWeight");
    }

    public static long getFishCaughtTime(ItemStack itemStack) {
        return !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("FishCaughtTime") ? 0L : itemStack.func_77978_p().func_74763_f("FishCaughtTime");
    }

    public static void setFishCaughtTime(ItemStack itemStack, int time) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74772_a("FishCaughtTime", (long)time);
        itemStack.func_77982_d(tagCompound);
    }

    public static boolean doesFishHasScale(ItemStack itemStack) {
        return !itemStack.func_77942_o() || !itemStack.func_77978_p().func_74764_b("FishScale") ? false : itemStack.func_77978_p().func_74767_n("FishScale");
    }

    public static void setFishHasScale(ItemStack itemStack, boolean value) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74757_a("FishScale", value);
        itemStack.func_77982_d(tagCompound);
        if (!value) {
            ArrayList<String> tooltipList = new ArrayList<String>();
            tooltipList.add(String.format("Weight: %d", BetterFishUtil.getFishWeight(itemStack)));
            tooltipList.add(String.format("Scale: %s", "Detached"));
            tooltipList.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Dead" + TextFormatting.RESET);
            itemStack = ItemStackUtil.appendToolTip(itemStack, tooltipList);
            BetterFishUtil.setFishCaughtTime(itemStack, 0);
        }
    }

    public static boolean isBetterFish(ItemStack itemStack) {
        String fishId = BetterFishUtil.getFishId(itemStack);
        if (itemStack.func_77973_b() instanceof ItemFishBucket) {
            return false;
        }
        return fishId != null && fishId.length() > 0;
    }

    public static boolean isValidBait(ItemStack itemStack) {
        String baitString = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b())).toString();
        if (baitString == null) {
            return false;
        }
        Integer baitMeta = itemStack.func_77960_j();
        return CustomConfigurationHandler.possibleBaitMap.containsKey(baitString) && CustomConfigurationHandler.possibleBaitMap.get(baitString).contains(baitMeta);
    }

    public static boolean isDead(ItemStack itemStack, long time) {
        String fishId = BetterFishUtil.getFishId(itemStack);
        if (fishId == null) {
            return true;
        }
        FishData fishData = CustomConfigurationHandler.fishDataMap.get(fishId);
        if (fishData == null) {
            return true;
        }
        long fishCaughtTime = BetterFishUtil.getFishCaughtTime(itemStack);
        if (fishCaughtTime == 0L) {
            return true;
        }
        if (fishData.allowScaling && !BetterFishUtil.doesFishHasScale(itemStack)) {
            return true;
        }
        return time >= fishCaughtTime + TimeUtil.secondsToMinecraftTicks(fishData.timeOutsideOfWater);
    }
}

