/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.FishingCapabilityProvider;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.IFishingData;
import net.theawesomegem.fishingmadebetter.common.configuration.ConfigurationManager;

public class GuiReelingOverlay
extends Gui {
    private static final ResourceLocation textureOutline = new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_outline.png");
    private static final ResourceLocation textureTarget = new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_target.png");
    private static final ResourceLocation texturePosition = new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_position.png");
    private static final ResourceLocation textureUnderOverlay = new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_underoverlay.png");
    private static final ResourceLocation textureFullsize = new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_fullsize.png");
    private static final ResourceLocation textureBiome = new ResourceLocation("fishingmadebetter", "textures/gui/reeling_hud_biome.png");
    private Minecraft mc;
    private final int backgroundBarWidth = 128;
    private final int backgroundBarHeight = 24;
    private final int outlineBarWidth = 134;
    private final int outlineBarHeight = 30;
    private int fontColor = 0xFFFFFF;
    private FontRenderer fontRenderer;

    public GuiReelingOverlay(Minecraft minecraft) {
        this.mc = minecraft;
        this.fontRenderer = minecraft.field_71466_p;
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post e) {
        if (e.isCanceled() || e.getType() != RenderGameOverlayEvent.ElementType.ALL || !ConfigurationManager.client.reelingHud) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player == null || !player.func_70089_S()) {
            return;
        }
        IFishingData fishingData = (IFishingData)player.getCapability(FishingCapabilityProvider.FISHING_DATA_CAP, null);
        if (fishingData == null || !fishingData.isFishing()) {
            return;
        }
        int scaledWidth = e.getResolution().func_78326_a();
        int scaledHeight = e.getResolution().func_78328_b();
        double distance = (double)(fishingData.getFishDeepLevel() - fishingData.getFishDistance()) / 10.0;
        this.fontColor = this.getIntFromColor(fishingData.getLineBreak());
        this.fontRenderer.func_175063_a(String.format("Distance: %sm", distance), (float)this.getBarPosX(scaledWidth) + 67.0f - 30.0f, (float)(this.getBarPosY(scaledHeight) + 30 + 2), this.fontColor);
        int posX = this.getBarPosX(scaledWidth);
        int posY = this.getBarPosY(scaledHeight);
        Integer[] minigameBackground = fishingData.getMinigameBackground();
        this.beginRenderingTransparency();
        this.mc.field_71446_o.func_110577_a(textureOutline);
        this.renderOutlineBar(posX += ConfigurationManager.client.reelingMeterXOffset, posY += ConfigurationManager.client.reelingMeterYOffset);
        if (minigameBackground[0] == 1) {
            this.mc.field_71446_o.func_110577_a(textureUnderOverlay);
            this.renderBackgroundBar(posX, posY, 0, minigameBackground[3] == 0 ? 7 : minigameBackground[3]);
            this.mc.field_71446_o.func_110577_a(textureFullsize);
            this.renderBackgroundBar(posX, posY, 0, 0);
        } else if (minigameBackground[0] == -1) {
            this.mc.field_71446_o.func_110577_a(textureUnderOverlay);
            this.renderBackgroundBar(posX, posY, 0, minigameBackground[3]);
            this.mc.field_71446_o.func_110577_a(textureFullsize);
            this.renderBackgroundBar(posX, posY, 0, 1);
        } else if (minigameBackground[1] == 1) {
            this.mc.field_71446_o.func_110577_a(textureUnderOverlay);
            this.renderBackgroundBar(posX, posY, 0, minigameBackground[3] == 0 ? 9 : minigameBackground[3]);
            this.mc.field_71446_o.func_110577_a(textureFullsize);
            this.renderBackgroundBar(posX, posY, 0, 2);
        } else {
            if (minigameBackground[3] == 0) {
                this.mc.field_71446_o.func_110577_a(textureUnderOverlay);
                this.renderBackgroundBar(posX, posY, 1, minigameBackground[4]);
            } else {
                this.mc.field_71446_o.func_110577_a(textureUnderOverlay);
                this.renderBackgroundBar(posX, posY, 0, minigameBackground[3]);
            }
            this.mc.field_71446_o.func_110577_a(textureUnderOverlay);
            this.renderBackgroundBar(posX, posY, 0, minigameBackground[2] + 3);
            this.mc.field_71446_o.func_110577_a(textureBiome);
            this.renderBackgroundBar(posX, posY, 0, minigameBackground[4]);
            this.mc.field_71446_o.func_110577_a(textureUnderOverlay);
            this.renderBackgroundBar(posX, posY, 0, minigameBackground[2] + 5);
        }
        this.mc.field_71446_o.func_110577_a(textureTarget);
        this.renderReelingTarget(fishingData, posX, posY);
        this.mc.field_71446_o.func_110577_a(texturePosition);
        this.renderReelingPosition(fishingData, posX, posY);
        this.endRenderingTransparency();
    }

    public int getIntFromColor(int input) {
        int R = (int)Math.min(255.0, (double)input * 8.5);
        int G = (int)Math.min(255.0, 510.0 - (double)input * 8.5);
        int B = 0;
        R = R << 16 & 0xFF0000;
        G = G << 8 & 0xFF00;
        return 0xFF000000 | R | G | (B &= 0xFF);
    }

    private void renderOutlineBar(int posX, int posY) {
        this.func_73729_b(posX - 3, posY - 3, 0, 0, 134, 30);
    }

    private void renderBackgroundBar(int posX, int posY, int indexX, int indexY) {
        this.func_73729_b(posX, posY, 128 * indexX, 24 * indexY, 128, 24);
    }

    private void renderReelingPosition(IFishingData fishingData, int posX, int posY) {
        int reelAmount = fishingData.getReelAmount() / 10;
        int variance = fishingData.getErrorVariance() / 10;
        int width = variance * 2;
        GuiReelingOverlay.func_146110_a((int)(posX + 16 + reelAmount - variance), (int)(posY + 13), (float)0.0f, (float)0.0f, (int)2, (int)8, (float)8.0f, (float)8.0f);
        if (width - 4 > 0) {
            GuiReelingOverlay.func_152125_a((int)(posX + 16 + reelAmount - variance + 2), (int)(posY + 13), (float)2.0f, (float)0.0f, (int)4, (int)8, (int)(width - 4), (int)8, (float)8.0f, (float)8.0f);
        }
        GuiReelingOverlay.func_146110_a((int)(posX + 16 + reelAmount + variance - 2), (int)(posY + 13), (float)6.0f, (float)0.0f, (int)2, (int)8, (float)8.0f, (float)8.0f);
    }

    private void renderReelingTarget(IFishingData fishingData, int posX, int posY) {
        int reelTarget = fishingData.getReelTarget() / 10;
        GuiReelingOverlay.func_146110_a((int)(posX + 16 + reelTarget - 3), (int)(posY + 14), (float)0.0f, (float)0.0f, (int)6, (int)6, (float)6.0f, (float)6.0f);
    }

    private void beginRenderingTransparency() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
    }

    private void endRenderingTransparency() {
        GlStateManager.func_179121_F();
    }

    private int getBarPosX(int scaledWidth) {
        switch (ConfigurationManager.client.reelingHubPos) {
            case TOP_LEFT: 
            case BOTTOM_LEFT: {
                return 0;
            }
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                return scaledWidth - 128;
            }
            case TOP_CENTER: 
            case BOTTOM_CENTER: {
                return scaledWidth / 2 - 64;
            }
        }
        return 0;
    }

    private int getBarPosY(int scaledHeight) {
        switch (ConfigurationManager.client.reelingHubPos) {
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case TOP_CENTER: {
                return 0;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: 
            case BOTTOM_CENTER: {
                return scaledHeight - 24;
            }
        }
        return 0;
    }
}

