/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.client.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;

public class FishSlicingRecipeWrapper
implements ICraftingRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;

    public FishSlicingRecipeWrapper(List<FishData> fishDataList, boolean useDefault) {
        ItemStack knifeWood = new ItemStack((Item)ItemManager.FILLET_KNIFE_WOOD);
        ItemStack knifeIron = new ItemStack((Item)ItemManager.FILLET_KNIFE_IRON);
        ItemStack knifeDiamond = new ItemStack((Item)ItemManager.FILLET_KNIFE_DIAMOND);
        ArrayList<ItemStack> fishStackList = new ArrayList<ItemStack>();
        ItemStack sliceStack = new ItemStack((Item)ItemManager.FISH_SLICE_RAW);
        for (FishData fishData : fishDataList) {
            ItemStack fishStack = new ItemStack(Item.func_111206_d((String)fishData.itemId), 1, fishData.itemMetaData);
            fishStackList.add(fishStack);
            if (useDefault) continue;
            sliceStack = new ItemStack(Item.func_111206_d((String)fishData.filletItem), 1, fishData.filletItemMetadata);
        }
        this.inputs = Arrays.asList(Arrays.asList(knifeWood, knifeIron, knifeDiamond), fishStackList);
        this.output = sliceStack;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }
}

