/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.theawesomegem.fishingmadebetter.common.block.BlockTileEntityBase;
import net.theawesomegem.fishingmadebetter.common.block.tileentity.TileEntityBaitBox;
import net.theawesomegem.fishingmadebetter.common.registry.FMBCreativeTab;

public class BlockBaitBox
extends BlockTileEntityBase<TileEntityBaitBox> {
    public BlockBaitBox() {
        super(Material.field_151575_d, "baitbox");
        this.func_149647_a(FMBCreativeTab.instance);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(TextFormatting.GRAY + "Feeds fish in the local chunk when filled with bait to aid fish reproduction." + TextFormatting.RESET);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || !hand.equals((Object)EnumHand.MAIN_HAND)) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBaitBox) {
            ((TileEntityBaitBox)tileEntity).handleRightClick(world, pos, state, player);
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityBaitBox) {
            IItemHandler inventory = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b() || world.field_72995_K) continue;
                EntityItem entityIn = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                entityIn.func_174869_p();
                world.func_72838_d((Entity)entityIn);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public Class<TileEntityBaitBox> getTileEntityClass() {
        return TileEntityBaitBox.class;
    }

    @Override
    @Nullable
    public TileEntityBaitBox createTileEntity(World world, IBlockState state) {
        return new TileEntityBaitBox();
    }
}

