/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.capability.world;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.theawesomegem.fishingmadebetter.common.capability.world.IChunkFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.PopulationData;

public class ChunkFishingStorage
implements Capability.IStorage<IChunkFishingData> {
    @Nullable
    public NBTBase writeNBT(Capability<IChunkFishingData> capability, IChunkFishingData instance, EnumFacing side) {
        NBTTagCompound nbt = new NBTTagCompound();
        for (PopulationData fishEntry : instance.getRawFishMap().values()) {
            NBTTagCompound fishDataTag = new NBTTagCompound();
            fishDataTag.func_74768_a("Quantity", fishEntry.getQuantity());
            fishDataTag.func_74768_a("ReproductionTick", fishEntry.getReproductionTick());
            fishDataTag.func_74772_a("LastEatenTime", fishEntry.getLastEatenTime());
            nbt.func_74782_a(fishEntry.getFishType(), (NBTBase)fishDataTag);
        }
        nbt.func_74772_a("TimeSinceRegenerated", instance.getTimeSinceLastRegen());
        nbt.func_74772_a("TimeSinceReproduction", instance.getTimeSinceLastReproduced());
        return nbt;
    }

    public void readNBT(Capability<IChunkFishingData> capability, IChunkFishingData instance, EnumFacing side, NBTBase nbtBase) {
        if (nbtBase instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)nbtBase;
            HashMap<String, PopulationData> fishPopulationMap = new HashMap<String, PopulationData>();
            for (String fishType : nbt.func_150296_c()) {
                NBTTagCompound fishDataTag = nbt.func_74775_l(fishType);
                if (fishDataTag.func_82582_d()) continue;
                PopulationData populationData = new PopulationData(fishType, fishDataTag.func_74762_e("Quantity"), fishDataTag.func_74762_e("ReproductionTick"), fishDataTag.func_74763_f("LastEatenTime"));
                fishPopulationMap.put(fishType, populationData);
            }
            instance.setTimeSinceLastRegen(nbt.func_74763_f("TimeSinceRegenerated"), false);
            instance.setTimeSinceLastReproduced(nbt.func_74763_f("TimeSinceReproduction"), false);
            instance.addFishes(fishPopulationMap, false);
        }
    }
}

