/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.event;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.theawesomegem.fishingmadebetter.BetterFishUtil;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.FishPopulation;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.FishingCapabilityProvider;
import net.theawesomegem.fishingmadebetter.common.capability.fishing.IFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.ChunkCapabilityProvider;
import net.theawesomegem.fishingmadebetter.common.capability.world.IChunkFishingData;
import net.theawesomegem.fishingmadebetter.common.capability.world.PopulationData;
import net.theawesomegem.fishingmadebetter.common.configuration.ConfigurationManager;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishCaughtData;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.data.WeightedRandomFishPopulation;
import net.theawesomegem.fishingmadebetter.common.entity.EntityFMBCustomFishHook;
import net.theawesomegem.fishingmadebetter.common.entity.EntityFMBLavaFishHook;
import net.theawesomegem.fishingmadebetter.common.entity.EntityFMBVoidFishHook;
import net.theawesomegem.fishingmadebetter.common.item.attachment.hook.ItemHook;
import net.theawesomegem.fishingmadebetter.common.item.fishingrod.ItemBetterFishingRod;
import net.theawesomegem.fishingmadebetter.common.item.tracker.ItemFishTracker;
import net.theawesomegem.fishingmadebetter.common.loottable.LootHandler;
import net.theawesomegem.fishingmadebetter.common.networking.PrimaryPacketHandler;
import net.theawesomegem.fishingmadebetter.common.networking.packet.PacketFishingHandshakeS;
import net.theawesomegem.fishingmadebetter.common.networking.packet.PacketKeybindS;
import net.theawesomegem.fishingmadebetter.common.networking.packet.PacketReelingC;
import net.theawesomegem.fishingmadebetter.common.registry.RegistryManager;
import net.theawesomegem.fishingmadebetter.util.ItemStackUtil;
import net.theawesomegem.fishingmadebetter.util.LevelUpLoot;
import net.theawesomegem.fishingmadebetter.util.MathUtil;
import net.theawesomegem.fishingmadebetter.util.RandomUtil;
import net.theawesomegem.fishingmadebetter.util.TimeUtil;

public class FishingEventHandler {
    static final Field currentStateField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_190627_av");
    static final Field biteIntervalField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_146045_ax");
    static final Field delayBeforeBiteField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_146038_az");
    static final Field delayBeforeSwimmingToHookField = ObfuscationReflectionHelper.findField(EntityFishHook.class, (String)"field_146040_ay");

    @SubscribeEvent
    public void onPlayerFish(ItemFishedEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        if (player == null || !player.func_70089_S()) {
            return;
        }
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (this.usingVanillaFishingRod(player)) {
            return;
        }
        IFishingData fishingData = (IFishingData)player.getCapability(FishingCapabilityProvider.FISHING_DATA_CAP, null);
        if (fishingData == null) {
            e.setCanceled(true);
            return;
        }
        IChunkFishingData chunkFishingData = (IChunkFishingData)world.func_175726_f(e.getHookEntity().func_180425_c()).getCapability(ChunkCapabilityProvider.CHUNK_FISHING_DATA_CAP, null);
        if (chunkFishingData == null) {
            e.setCanceled(true);
            return;
        }
        if (!fishingData.isFishing()) {
            e.setCanceled(true);
            return;
        }
        FishCaughtData fishCaughtData = fishingData.getFishCaughtData();
        if (fishCaughtData == null) {
            e.setCanceled(true);
            return;
        }
        e.setCanceled(true);
        if ((ConfigurationManager.server.skipMinigame || fishingData.getFishDistance() >= fishingData.getFishDeepLevel() - 10) && chunkFishingData.getFishes(world.func_82737_E()).get(fishCaughtData.fishId).getQuantity() > 0) {
            ItemStack fishingRod = this.getBetterFishingRod(player);
            ItemHook hookAttachment = ItemBetterFishingRod.getHookItem(fishingRod);
            int weightModifier = hookAttachment.getWeightModifier();
            int treasureChance = ConfigurationManager.server.baseTreasureChance + hookAttachment.getTreasureModifier();
            EntityFishHook hook = e.getHookEntity();
            ItemStack treasure = ItemStack.field_190927_a;
            if (treasureChance > RandomUtil.getRandomInRange(player.func_70681_au(), 0, 100)) {
                LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)world);
                lootBuilder.func_186469_a((float)EnchantmentHelper.func_191529_b((ItemStack)fishingRod) + player.func_184817_da()).func_186470_a(player).func_186472_a((Entity)hook);
                List result = world.func_184146_ak().func_186521_a(LootHandler.FMB_COMBINED).func_186462_a(player.func_70681_au(), lootBuilder.func_186471_a());
                if (result.size() > 0) {
                    treasure = (ItemStack)result.get(0);
                }
            }
            ItemStack fishStack = this.getFishItemStack(fishCaughtData, world.func_82737_E(), weightModifier);
            EntityItem entityFishItem = new EntityItem(player.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, fishStack);
            if (ConfigurationManager.server.magneticFishing) {
                entityFishItem.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
            } else {
                double d0 = player.field_70165_t - hook.field_70165_t;
                double d1 = player.field_70163_u - hook.field_70163_u;
                double d2 = player.field_70161_v - hook.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                entityFishItem.field_70159_w = d0 * 0.1;
                entityFishItem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                entityFishItem.field_70179_y = d2 * 0.1;
            }
            player.field_70170_p.func_72838_d((Entity)entityFishItem);
            if (!treasure.func_190926_b()) {
                EntityItem entityTreasureItem = new EntityItem(player.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, treasure);
                if (ConfigurationManager.server.magneticFishing) {
                    entityTreasureItem.func_70107_b(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v);
                } else {
                    double d0 = player.field_70165_t - hook.field_70165_t;
                    double d1 = player.field_70163_u - hook.field_70163_u;
                    double d2 = player.field_70161_v - hook.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    entityTreasureItem.field_70159_w = d0 * 0.1;
                    entityTreasureItem.field_70181_x = d1 * 0.1 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
                    entityTreasureItem.field_70179_y = d2 * 0.1;
                }
                player.field_70170_p.func_72838_d((Entity)entityTreasureItem);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.treasure", new Object[0]), true);
            }
            if (Loader.isModLoaded((String)"levelup2") && ConfigurationManager.server.levelUpPatch) {
                LevelUpLoot.doLevelUpLoot(hook, world, player);
            }
            chunkFishingData.reducePopulation(fishCaughtData.fishId, 1, world.func_82737_E(), true);
            player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, player.func_70681_au().nextInt(6) + 1));
        }
        fishingData.reset();
    }

    @SubscribeEvent
    public void onPlayerTickClient(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        if (!player.field_70170_p.field_72995_K || e.phase == TickEvent.Phase.END) {
            return;
        }
        IFishingData fishingData = (IFishingData)player.getCapability(FishingCapabilityProvider.FISHING_DATA_CAP, null);
        if (fishingData == null) {
            return;
        }
        if (fishingData.isFishing()) {
            PrimaryPacketHandler.INSTANCE.sendToServer((IMessage)new PacketFishingHandshakeS(true));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        int delayBeforeBite;
        HookState hookState;
        IFishingData fishingData;
        EntityPlayer player = e.player;
        if (player.field_70170_p.field_72995_K || e.phase == TickEvent.Phase.END) {
            return;
        }
        if (player.field_70173_aa % 5 == 0) {
            this.checkForFishInventory(player);
        }
        if ((fishingData = (IFishingData)player.getCapability(FishingCapabilityProvider.FISHING_DATA_CAP, null)) == null) {
            return;
        }
        this.checkTracking(player, fishingData);
        this.updateFishingData(player, fishingData);
        EntityFishHook hook = player.field_71104_cf;
        if (hook == null || hook.field_70128_L) {
            fishingData.setUsingVanillaRod(false);
            fishingData.reset();
            return;
        }
        if (player.func_184586_b(EnumHand.MAIN_HAND) != null && player.func_184586_b(EnumHand.OFF_HAND) != null && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemFishingRod && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemFishingRod) {
            fishingData.reset();
            hook.func_70106_y();
            return;
        }
        if (this.usingVanillaFishingRod(player)) {
            fishingData.setUsingVanillaRod(true);
            fishingData.reset();
            return;
        }
        if (fishingData.getUsingVanillaRod()) {
            fishingData.setUsingVanillaRod(false);
            fishingData.reset();
            hook.func_70106_y();
            return;
        }
        ItemStack betterFishingRodStack = this.getBetterFishingRod(player);
        if (betterFishingRodStack == null || betterFishingRodStack.func_190926_b()) {
            fishingData.reset();
            return;
        }
        if (fishingData.getTimeBeforeFishSwimToHook() == 0) {
            if (this.getDelayBeforeSwimmingToHook(hook) > 20) {
                this.setLureSpeed(hook, 20);
            }
        } else {
            this.setLureSpeed(hook, 200);
        }
        if ((hookState = this.getHookState(hook)) == null || !hookState.equals((Object)HookState.BOBBING)) {
            fishingData.reset();
            return;
        }
        if (fishingData.isFishing()) {
            int distanceTime = fishingData.getFishDistanceTime();
            if (distanceTime <= 0) {
                distanceTime = Math.min(10, 1 + fishingData.getFishWeight() / 100);
                int reelDiff = fishingData.getReelTarget() - fishingData.getReelAmount();
                int distanceMod = (reelDiff = Math.abs(reelDiff)) <= fishingData.getErrorVariance() ? ItemBetterFishingRod.getReelItem(betterFishingRodStack).getReelSpeed() : -1;
                fishingData.setFishDistance(Math.min(fishingData.getFishDeepLevel(), Math.max(0, fishingData.getFishDistance() + distanceMod)));
            }
            fishingData.setFishDistanceTime(distanceTime - 1);
        }
        World world = hook.field_70170_p;
        Chunk chunk = world.func_175726_f(hook.func_180425_c());
        IChunkFishingData chunkFishingData = this.getChunkFishingData(chunk);
        if (fishingData.getFishPopulation() == null && !fishingData.isFishing()) {
            boolean justChecked = false;
            if (world.func_72820_D() % 60L == 0L) {
                fishingData.setFishPopulation(this.getSelectedFishPop(player, chunkFishingData));
                justChecked = true;
            }
            if (fishingData.getFishPopulation() == null) {
                fishingData.reset();
                if (justChecked && world.func_72820_D() % 180L == 0L) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.failure.empty", new Object[0]), true);
                }
                return;
            }
        }
        if (fishingData.getTimeBeforeFishSwimToHook() == -1 && !fishingData.isFishing()) {
            fishingData.setTimeBeforeFishSwimToHook(this.getLureSpeed(player, fishingData.getFishPopulation()));
        }
        if ((delayBeforeBite = this.getDelayBeforeBite(hook)) > 0 && delayBeforeBite <= 10) {
            Boolean caughtTick = false;
            if (fishingData.getLastFailedFishing() <= 0 && !fishingData.isFishing()) {
                if (hook instanceof EntityFMBLavaFishHook) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187633_N, SoundCategory.PLAYERS, 1.0f, 1.0f);
                } else if (hook instanceof EntityFMBVoidFishHook) {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_193777_bb, SoundCategory.PLAYERS, 1.0f, 1.0f);
                } else {
                    player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, RegistryManager.RegistryHandler.FISH_SPLASHING_EVENT, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                if (ConfigurationManager.server.looseBait) {
                    ItemBetterFishingRod.removeBait(betterFishingRodStack);
                }
                Integer[] minigameBackground = new Integer[]{world.field_73011_w.getDimension(), hook.field_70163_u < 56.0 ? 1 : 0, world.func_72935_r() ? 0 : 1, hook instanceof EntityFMBLavaFishHook ? Integer.valueOf(1) : (hook instanceof EntityFMBVoidFishHook ? Integer.valueOf(2) : Integer.valueOf(0)), this.textureIndexFromBiome(chunk.func_177411_a(hook.func_180425_c(), world.func_72959_q()))};
                fishingData.startFishing(player.func_70681_au(), betterFishingRodStack, minigameBackground);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.bite", new Object[0]), true);
                caughtTick = true;
            }
            if (player.field_70173_aa % 3 == 0 && !caughtTick.booleanValue() && fishingData.isFishing() && (ConfigurationManager.server.skipMinigame || ConfigurationManager.server.autoReel && fishingData.getFishDistance() == fishingData.getFishDeepLevel() && fishingData.getFishDistance() != 0)) {
                EnumHand hand = null;
                if (player.func_184614_ca().func_77973_b() instanceof ItemBetterFishingRod) {
                    hand = EnumHand.MAIN_HAND;
                } else if (player.func_184592_cb().func_77973_b() instanceof ItemBetterFishingRod) {
                    hand = EnumHand.OFF_HAND;
                }
                if (hand != null) {
                    ((ItemBetterFishingRod)player.func_184586_b(hand).func_77973_b()).func_77659_a(world, player, hand);
                }
            }
            if (fishingData.getLineBreak() < 60) {
                this.spawnParticleBasedOnFishSpeed(player.field_70170_p, hook, fishingData);
                this.setBiteInterval(hook, 20);
            } else {
                if (fishingData.isFishing() && fishingData.getLineBreak() == 60) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.failure.snap", new Object[0]), true);
                }
                this.setBiteInterval(hook, 0);
                fishingData.setLastFailedFishing(20);
                fishingData.reset();
            }
        } else {
            fishingData.reset(false);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load e) {
        if (e.getWorld().field_72995_K) {
            return;
        }
        Chunk chunk = e.getChunk();
        IChunkFishingData chunkFishingData = this.getChunkFishingData(chunk);
        chunkFishingData.chunkLoad(chunk);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (!(stack.func_77973_b() instanceof ItemBetterFishingRod)) {
            return;
        }
        if (ConfigurationManager.server.charmSalvagePatch && Loader.isModLoaded((String)"charm") && stack.func_77952_i() >= stack.func_77958_k()) {
            ItemBetterFishingRod.removeReelItem(stack);
            ItemBetterFishingRod.removeBobberItem(stack);
            ItemBetterFishingRod.removeHookItem(stack);
        }
    }

    private int textureIndexFromBiome(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
            return 8;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
            return 9;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 1;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 7;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
            return 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 3;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) {
            return 4;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 5;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            return 6;
        }
        return 0;
    }

    private void checkForFishInventory(EntityPlayer player) {
        InventoryPlayer playerInventory = player.field_71071_by;
        long currentTime = player.field_70170_p.func_82737_E();
        for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = playerInventory.func_70301_a(i);
            if (itemStack.func_190926_b() || !BetterFishUtil.isBetterFish(itemStack)) continue;
            ArrayList<String> tooltipList = new ArrayList<String>();
            tooltipList.add(String.format("Weight: %d", BetterFishUtil.getFishWeight(itemStack)));
            if (CustomConfigurationHandler.fishDataMap.get((Object)BetterFishUtil.getFishId((ItemStack)itemStack)).allowScaling) {
                tooltipList.add(String.format("Scale: %s", BetterFishUtil.doesFishHasScale(itemStack) ? "Attached" : "Detached"));
            }
            tooltipList.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + (BetterFishUtil.isDead(itemStack, currentTime) ? "Dead" : "Alive") + TextFormatting.RESET);
            itemStack = ItemStackUtil.appendToolTip(itemStack, tooltipList);
            if (!BetterFishUtil.isDead(itemStack, currentTime)) continue;
            BetterFishUtil.setFishCaughtTime(itemStack, 0);
        }
    }

    private void checkTracking(EntityPlayer player, IFishingData fishingData) {
        if (fishingData.getTimeSinceTracking() <= 0L) {
            return;
        }
        ItemStack mainHandItem = player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHandItem = player.func_184586_b(EnumHand.OFF_HAND);
        if (!(mainHandItem.func_77973_b() instanceof ItemFishTracker) && !(offHandItem.func_77973_b() instanceof ItemFishTracker)) {
            fishingData.setTimeSinceTracking(0L);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.tracker.nohand", new Object[0]), true);
        } else if (mainHandItem.func_77973_b() instanceof ItemFishTracker && offHandItem.func_77973_b() instanceof ItemFishTracker) {
            fishingData.setTimeSinceTracking(0L);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.tracker.twohand", new Object[0]), true);
        } else {
            ItemStack fishTrackerItem = mainHandItem.func_77973_b() instanceof ItemFishTracker ? mainHandItem : offHandItem;
            fishingData.setTimeSinceTracking(fishingData.getTimeSinceTracking() + 2L);
            long maxTrackingTime = player.field_70170_p.func_82737_E() + TimeUtil.secondsToMinecraftTicks(ConfigurationManager.server.baitBoxUpdateInterval);
            if (fishingData.getTimeSinceTracking() >= maxTrackingTime) {
                fishingData.setTimeSinceTracking(0L);
                this.getTrackingFish(player, (ItemFishTracker)fishTrackerItem.func_77973_b());
                player.func_146105_b((ITextComponent)new TextComponentTranslation("notif.fishingmadebetter.tracker.finish", new Object[0]), true);
            }
        }
    }

    private void getTrackingFish(EntityPlayer player, ItemFishTracker item) {
        World world = player.field_70170_p;
        Chunk chunk = world.func_175726_f(player.func_180425_c());
        IChunkFishingData chunkFishingData = this.getChunkFishingData(chunk);
        if (chunkFishingData == null) {
            return;
        }
        boolean limitInfo = !player.func_70093_af();
        boolean creative = player.func_184812_l_();
        boolean fishFound = false;
        int underYCount = 0;
        int trackerQualityCount = 0;
        int hibernatingCount = 0;
        player.func_145747_a((ITextComponent)new TextComponentString("-----"));
        for (PopulationData populationData : chunkFishingData.getFishes(world.func_82737_E()).values()) {
            FishData fishData = CustomConfigurationHandler.fishDataMap.get(populationData.getFishType());
            if (fishData == null) continue;
            if (creative) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("%s %s in %s at Y%s-%s", populationData.getQuantity(), fishData.fishId, fishData.liquid.toString(), fishData.minYLevel, fishData.maxYLevel)));
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("MinLine %sm, Time %s, MaxLight %s, Rain %s, Thunder %s", fishData.minDeepLevel, fishData.time.toString(), fishData.maxLightLevel, fishData.rainRequired, fishData.thunderRequired)));
                continue;
            }
            if (!fishData.trackable || !fishData.liquid.equals((Object)FishData.FishingLiquid.ANY) && !item.getLiquidEnum().equals((Object)fishData.liquid) || (double)fishData.minYLevel > player.field_70163_u) continue;
            fishFound = true;
            if ((double)fishData.maxYLevel < player.field_70163_u) {
                ++underYCount;
                continue;
            }
            if (fishData.minDeepLevel > item.getMaxDepth()) {
                ++trackerQualityCount;
                continue;
            }
            if (fishData.rarity < ItemFishTracker.TrackingVision.getMinRarity(item.getTrackingVision())) {
                ++trackerQualityCount;
                continue;
            }
            if (fishData.time.equals((Object)FishData.TimeToFish.DAY) && !world.func_72935_r() || fishData.time.equals((Object)FishData.TimeToFish.NIGHT) && world.func_72935_r()) {
                ++hibernatingCount;
                continue;
            }
            if (fishData.maxLightLevel < world.func_175699_k(player.func_180425_c())) {
                ++hibernatingCount;
                continue;
            }
            if (fishData.rainRequired && !world.func_72896_J() || fishData.thunderRequired && !world.func_72911_I()) {
                ++hibernatingCount;
                continue;
            }
            int pop = populationData.getQuantity();
            String quantity = pop > 50 ? "immense" : (pop > 40 ? "abundant" : (pop > 30 ? "ample" : (pop > 20 ? "substantial" : (pop > 10 ? "numerous" : (pop > 3 ? "light" : (pop > 1 ? "sparse" : "meager"))))));
            if (limitInfo) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Detected %s.", fishData.fishId)));
                continue;
            }
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Detected %s, %s in %s quantity.", fishData.fishId, fishData.description, quantity)));
        }
        if (creative) {
            player.func_145747_a((ITextComponent)new TextComponentString("-----"));
            return;
        }
        if (!fishFound) {
            player.func_145747_a((ITextComponent)new TextComponentString("Probe failed to detect any fish in this location"));
        } else {
            if (underYCount > 0) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Detected traces of %s fish living at a lower altitiude.", underYCount)));
            }
            if (trackerQualityCount > 0) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Detected traces of %s fish outside of the probe's ability.", trackerQualityCount)));
            }
            if (hibernatingCount > 0) {
                player.func_145747_a((ITextComponent)new TextComponentString(String.format("Detected %s fish currently not feeding in these conditions.", hibernatingCount)));
            }
        }
        player.func_145747_a((ITextComponent)new TextComponentString("-----"));
    }

    private int getDistanceTime(int weight) {
        return (int)(1.0 + Math.cbrt(weight * weight) / 6.0);
    }

    private ItemStack getFishItemStack(FishCaughtData fishCaughtData, long currentTime, int weightModifier) {
        Item item = Item.func_111206_d((String)fishCaughtData.itemId);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = new ItemStack(item, 1, fishCaughtData.itemMetaData);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        tagCompound.func_74778_a("FishId", fishCaughtData.fishId);
        tagCompound.func_74768_a("FishWeight", (int)((float)fishCaughtData.weight * (1.0f + (float)weightModifier / 100.0f)));
        tagCompound.func_74772_a("FishCaughtTime", currentTime);
        if (CustomConfigurationHandler.fishDataMap.get((Object)fishCaughtData.fishId).allowScaling) {
            tagCompound.func_74757_a("FishScale", true);
        }
        itemStack.func_77982_d(tagCompound);
        itemStack.func_151001_c(TextFormatting.RESET + fishCaughtData.fishId);
        ArrayList<String> tooltipList = new ArrayList<String>();
        tooltipList.add(String.format("Weight: %d", fishCaughtData.weight));
        if (itemStack.func_77978_p().func_74764_b("FishScale")) {
            tooltipList.add("Scale: Attached");
        }
        tooltipList.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Alive" + TextFormatting.RESET);
        itemStack = ItemStackUtil.appendToolTip(itemStack, tooltipList);
        return itemStack;
    }

    private void spawnParticleBasedOnFishSpeed(World world, EntityFishHook hook, IFishingData fishingData) {
        double particleSpeed;
        float numberOfParticles;
        int minFishTime;
        if (world.field_72995_K) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        int fishTime = fishingData.getLastFishTime();
        if (MathUtil.inRange(fishTime, minFishTime = 80, minFishTime + 80)) {
            numberOfParticles = 40.0f;
            particleSpeed = 0.40000000298023225;
        } else if (MathUtil.inRange(fishTime, minFishTime + 81, minFishTime + 139)) {
            numberOfParticles = 30.0f;
            particleSpeed = 0.3000000029802322;
        } else if (MathUtil.inRange(fishTime, minFishTime + 140, minFishTime + 175)) {
            numberOfParticles = 30.0f;
            particleSpeed = 0.3000000029802322;
        } else if (MathUtil.inRange(fishTime, minFishTime + 176, minFishTime + 200)) {
            numberOfParticles = 20.0f;
            particleSpeed = 0.2f;
        } else if (MathUtil.inRange(fishTime, minFishTime + 201, minFishTime + 230)) {
            numberOfParticles = 5.0f;
            particleSpeed = 0.10000000298023223;
        } else {
            numberOfParticles = 2.0f;
            particleSpeed = 0.05000000298023224;
        }
        double yPos = hook.func_174813_aQ().field_72338_b + 0.5;
        if (hook instanceof EntityFMBCustomFishHook) {
            worldServer.func_175739_a(((EntityFMBCustomFishHook)hook).getBubbleParticle(), hook.field_70165_t, yPos, hook.field_70161_v, (int)(1.0f + hook.field_70130_N * numberOfParticles), (double)hook.field_70130_N, 0.0, (double)hook.field_70130_N, particleSpeed, new int[0]);
            worldServer.func_175739_a(((EntityFMBCustomFishHook)hook).getWakeParticle(), hook.field_70165_t, yPos, hook.field_70161_v, (int)(1.0f + hook.field_70130_N * numberOfParticles), (double)hook.field_70130_N, 0.0, (double)hook.field_70130_N, particleSpeed, new int[0]);
        } else {
            worldServer.func_175739_a(EnumParticleTypes.WATER_BUBBLE, hook.field_70165_t, yPos, hook.field_70161_v, (int)(1.0f + hook.field_70130_N * numberOfParticles), (double)hook.field_70130_N, 0.0, (double)hook.field_70130_N, particleSpeed, new int[0]);
            worldServer.func_175739_a(EnumParticleTypes.WATER_WAKE, hook.field_70165_t, yPos, hook.field_70161_v, (int)(1.0f + hook.field_70130_N * numberOfParticles), (double)hook.field_70130_N, 0.0, (double)hook.field_70130_N, particleSpeed, new int[0]);
        }
    }

    private void updateFishingData(EntityPlayer player, IFishingData fishingData) {
        if (fishingData.getLastFailedFishing() > 0) {
            fishingData.setLastFailedFishing(fishingData.getLastFailedFishing() - 1);
        }
        if (fishingData.getTimeBeforeFishSwimToHook() > 0) {
            fishingData.setTimeBeforeFishSwimToHook(fishingData.getTimeBeforeFishSwimToHook() - 1 - (player.field_70170_p.func_175727_C(player.func_180425_c()) ? player.func_70681_au().nextInt(2) : 0));
        }
        if (fishingData.isFishing()) {
            ItemStack betterFishingRodStack = this.getBetterFishingRod(player);
            int fishSpeed = 4 + (int)((float)this.getDistanceTime(fishingData.getFishWeight()) + 0.5f);
            int tensioningSpeed = 8;
            this.updateReelTarget(player.func_70681_au(), fishingData, fishSpeed -= ItemBetterFishingRod.getHookItem(betterFishingRodStack).getTuggingReduction());
            this.updateReelPosition(fishingData, tensioningSpeed += ItemBetterFishingRod.getBobberItem(betterFishingRodStack).getTensioningModifier(), player);
            this.updateLineBreak(fishingData);
            PrimaryPacketHandler.INSTANCE.sendTo((IMessage)new PacketReelingC(fishingData.getReelAmount(), fishingData.getReelTarget(), fishingData.getFishDistance(), fishingData.getFishDeepLevel(), fishingData.getErrorVariance(), fishingData.isFishing(), fishingData.getMinigameBackground()[0], fishingData.getMinigameBackground()[1], fishingData.getMinigameBackground()[2], fishingData.getMinigameBackground()[3], fishingData.getMinigameBackground()[4], fishingData.getLineBreak()), (EntityPlayerMP)player);
        }
    }

    private void updateReelTarget(Random random, IFishingData fishingData, int fishSpeed) {
        int prevTugging = fishingData.getFishTugging();
        fishSpeed = prevTugging == 0 ? fishSpeed * (random.nextInt(3) - 1) * Math.max(0, RandomUtil.getRandomInRange(random, -this.getDistanceTime(fishingData.getFishWeight()), 1)) : fishSpeed * (int)Math.signum(prevTugging) * (int)Math.signum(RandomUtil.getRandomInRange(random, -1, 20));
        fishingData.setFishTugging(fishSpeed);
        int fishMomentum = fishingData.getFishMomentum();
        fishMomentum += (int)Math.signum(fishSpeed - fishMomentum);
        fishingData.setFishMomentum(fishMomentum);
        fishingData.setReelTarget(fishingData.getReelTarget() + fishMomentum);
    }

    private void updateReelPosition(IFishingData fishingData, int tensioningSpeed, EntityPlayer player) {
        tensioningSpeed = fishingData.getKeybind().equals((Object)PacketKeybindS.Keybind.REEL_IN) ? (tensioningSpeed *= -1) : (fishingData.getKeybind().equals((Object)PacketKeybindS.Keybind.REEL_OUT) ? (tensioningSpeed *= 1) : (tensioningSpeed *= 0));
        int tensionMomentum = fishingData.getTensionMomentum();
        tensionMomentum += (int)Math.signum(tensioningSpeed - tensionMomentum);
        fishingData.setTensionMomentum(tensionMomentum);
        fishingData.setReelAmount(fishingData.getReelAmount() + tensionMomentum);
        this.playReelingSound(tensionMomentum, player);
    }

    private void updateLineBreak(IFishingData fishingData) {
        fishingData.setLineBreak(fishingData.getLineBreak() + (fishingData.getFishDistance() == 0 ? 1 : -1));
    }

    private void playReelingSound(int momentum, EntityPlayer player) {
        if (momentum == 0 || player.field_70173_aa % 2 != 0) {
            return;
        }
        float pitch = Math.min(2.0f, Math.max(0.0f, (float)Math.abs(momentum) / 10.0f));
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, RegistryManager.RegistryHandler.REELING_EVENT, SoundCategory.PLAYERS, pitch, 2.0f);
    }

    private IChunkFishingData getChunkFishingData(Chunk chunk) {
        return (IChunkFishingData)chunk.getCapability(ChunkCapabilityProvider.CHUNK_FISHING_DATA_CAP, null);
    }

    private int getLureSpeed(EntityPlayer player, FishPopulation population) {
        ItemStack itemFishingRod = this.getBetterFishingRod(player);
        int pop = population.population;
        int rate = (int)(ConfigurationManager.server.baseTimeToBobber * ((100.0f - (float)ItemBetterFishingRod.getHookItem(itemFishingRod).getBiteRateModifier()) / 100.0f));
        rate -= 100 * EnchantmentHelper.func_191528_c((ItemStack)itemFishingRod);
        rate -= 4 * pop;
        FishData fishData = CustomConfigurationHandler.fishDataMap.get(population.fishId);
        String baitItem = ItemBetterFishingRod.getBaitItem(itemFishingRod);
        if (ItemBetterFishingRod.hasBait(itemFishingRod) && (ConfigurationManager.server.simpleBait || fishData.baitItemMap.containsKey(baitItem) && Arrays.asList((Object[])fishData.baitItemMap.get(baitItem)).contains(ItemBetterFishingRod.getBaitMetadata(itemFishingRod)))) {
            rate -= RandomUtil.getRandomInRange(player.func_70681_au(), 100, 300);
        }
        rate = Math.max(60, rate);
        return rate;
    }

    private FishPopulation getSelectedFishPop(EntityPlayer player, IChunkFishingData chunkFishingData) {
        Material mat;
        if (!chunkFishingData.hasFishes()) {
            return null;
        }
        World world = player.field_70170_p;
        EntityFishHook hook = player.field_71104_cf;
        FishData.FishingLiquid liquid = FishData.FishingLiquid.WATER;
        if (hook instanceof EntityFMBLavaFishHook) {
            liquid = FishData.FishingLiquid.LAVA;
        } else if (hook instanceof EntityFMBVoidFishHook) {
            liquid = FishData.FishingLiquid.VOID;
        }
        if (liquid == FishData.FishingLiquid.WATER) {
            int waterCount = 0;
            for (BlockPos pos : BlockPos.func_191532_a((int)((int)hook.field_70165_t - 2), (int)((int)hook.field_70163_u - 3), (int)((int)hook.field_70161_v - 2), (int)((int)hook.field_70165_t + 2), (int)((int)hook.field_70163_u), (int)((int)hook.field_70161_v + 2))) {
                mat = world.func_180495_p(pos).func_185904_a();
                if (mat == MaterialLiquid.field_151586_h) {
                    ++waterCount;
                }
                if (waterCount < 25) continue;
                break;
            }
            if (waterCount < 25) {
                return null;
            }
        }
        if (liquid == FishData.FishingLiquid.LAVA) {
            int lavaCount = 0;
            for (BlockPos pos : BlockPos.func_191532_a((int)((int)hook.field_70165_t - 2), (int)((int)hook.field_70163_u - 3), (int)((int)hook.field_70161_v - 2), (int)((int)hook.field_70165_t + 2), (int)((int)hook.field_70163_u), (int)((int)hook.field_70161_v + 2))) {
                mat = world.func_180495_p(pos).func_185904_a();
                if (mat == MaterialLiquid.field_151587_i) {
                    ++lavaCount;
                }
                if (lavaCount < 25) continue;
                break;
            }
            if (lavaCount < 25) {
                return null;
            }
        }
        ItemStack itemFishingRod = this.getBetterFishingRod(player);
        boolean hasFishBait = ItemBetterFishingRod.hasBait(itemFishingRod);
        Map<String, PopulationData> fishPopulationMap = chunkFishingData.getFishes(world.func_82737_E());
        ArrayList<WeightedRandomFishPopulation> weightedRandomFishPopulationList = new ArrayList<WeightedRandomFishPopulation>();
        for (PopulationData populationData : fishPopulationMap.values()) {
            FishData fishData = CustomConfigurationHandler.fishDataMap.get(populationData.getFishType());
            if (fishData == null || fishData.time.equals((Object)FishData.TimeToFish.DAY) && !world.func_72935_r() || fishData.time.equals((Object)FishData.TimeToFish.NIGHT) && world.func_72935_r() || !fishData.liquid.equals((Object)liquid) && !fishData.liquid.equals((Object)FishData.FishingLiquid.ANY) || fishData.minDeepLevel > ItemBetterFishingRod.getReelItem(itemFishingRod).getReelRange() || (double)fishData.minYLevel > hook.field_70163_u || (double)fishData.maxYLevel < hook.field_70163_u || fishData.maxLightLevel < world.func_175699_k(hook.func_180425_c()) || fishData.rainRequired && !world.func_72896_J() || fishData.thunderRequired && !world.func_72911_I()) continue;
            int rarity = fishData.rarity;
            if (!ConfigurationManager.server.simpleBait && hasFishBait && ItemBetterFishingRod.isBaitForFish(itemFishingRod, populationData.getFishType())) {
                rarity += RandomUtil.getRandomInRange(player.func_70681_au(), 25, 75);
            }
            weightedRandomFishPopulationList.add(new WeightedRandomFishPopulation(rarity, populationData.getFishType(), populationData.getQuantity()));
        }
        if (weightedRandomFishPopulationList.size() <= 0) {
            return null;
        }
        WeightedRandomFishPopulation randomFishPopulation = (WeightedRandomFishPopulation)WeightedRandom.func_76271_a((Random)world.field_73012_v, weightedRandomFishPopulationList);
        return new FishPopulation(randomFishPopulation.fishId, randomFishPopulation.population);
    }

    private ItemStack getBetterFishingRod(EntityPlayer player) {
        if (this.usingVanillaFishingRod(player)) {
            return ItemStack.field_190927_a;
        }
        ItemStack mainHandItem = player.func_184614_ca();
        ItemStack offHandItem = player.func_184592_cb();
        if (!mainHandItem.func_190926_b() && mainHandItem.func_77973_b() instanceof ItemBetterFishingRod) {
            return mainHandItem;
        }
        if (!offHandItem.func_190926_b() && offHandItem.func_77973_b() instanceof ItemBetterFishingRod) {
            return offHandItem;
        }
        return ItemStack.field_190927_a;
    }

    private boolean usingVanillaFishingRod(EntityPlayer player) {
        ItemStack mainHandItem = player.func_184614_ca();
        ItemStack offHandItem = player.func_184592_cb();
        if (!mainHandItem.func_190926_b()) {
            if (mainHandItem.func_77973_b() instanceof ItemBetterFishingRod) {
                return false;
            }
            if (mainHandItem.func_77973_b() instanceof ItemFishingRod) {
                return true;
            }
        }
        if (!offHandItem.func_190926_b()) {
            if (offHandItem.func_77973_b() instanceof ItemBetterFishingRod) {
                return false;
            }
            if (offHandItem.func_77973_b() instanceof ItemFishingRod) {
                return true;
            }
        }
        return false;
    }

    private void setLureSpeed(EntityFishHook hook, int ticks) {
        if (delayBeforeSwimmingToHookField == null) {
            return;
        }
        try {
            delayBeforeSwimmingToHookField.setAccessible(true);
            delayBeforeSwimmingToHookField.setInt(hook, ticks);
            delayBeforeSwimmingToHookField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            delayBeforeSwimmingToHookField.setAccessible(false);
            e.printStackTrace();
        }
    }

    private int getDelayBeforeSwimmingToHook(EntityFishHook hook) {
        if (delayBeforeSwimmingToHookField == null) {
            return -1;
        }
        try {
            delayBeforeSwimmingToHookField.setAccessible(true);
            int delay = delayBeforeSwimmingToHookField.getInt(hook);
            delayBeforeSwimmingToHookField.setAccessible(false);
            return delay;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            delayBeforeSwimmingToHookField.setAccessible(false);
            e.printStackTrace();
            return -1;
        }
    }

    private int getDelayBeforeBite(EntityFishHook hook) {
        if (delayBeforeBiteField == null) {
            return -1;
        }
        try {
            delayBeforeBiteField.setAccessible(true);
            int delay = delayBeforeBiteField.getInt(hook);
            delayBeforeBiteField.setAccessible(false);
            return delay;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            delayBeforeBiteField.setAccessible(false);
            e.printStackTrace();
            return -1;
        }
    }

    private void setBiteInterval(EntityFishHook hook, int time) {
        if (biteIntervalField == null) {
            return;
        }
        try {
            biteIntervalField.setAccessible(true);
            biteIntervalField.setInt(hook, time);
            biteIntervalField.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            biteIntervalField.setAccessible(false);
            e.printStackTrace();
        }
    }

    private HookState getHookState(EntityFishHook hook) {
        if (currentStateField == null) {
            return null;
        }
        try {
            currentStateField.setAccessible(true);
            Enum hookEnum = (Enum)currentStateField.get(hook);
            int hookStateOrdinal = hookEnum.ordinal();
            currentStateField.setAccessible(false);
            return HookState.values()[hookStateOrdinal];
        }
        catch (IllegalAccessException e) {
            currentStateField.setAccessible(false);
            e.printStackTrace();
            return null;
        }
    }

    static enum HookState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

