/*
 * Decompiled with CFR 0.152.
 */
package net.theawesomegem.fishingmadebetter.common.item.fishingrod;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.theawesomegem.fishingmadebetter.common.configuration.CustomConfigurationHandler;
import net.theawesomegem.fishingmadebetter.common.data.FishData;
import net.theawesomegem.fishingmadebetter.common.entity.EntityFMBLavaFishHook;
import net.theawesomegem.fishingmadebetter.common.entity.EntityFMBVoidFishHook;
import net.theawesomegem.fishingmadebetter.common.item.ItemManager;
import net.theawesomegem.fishingmadebetter.common.item.attachment.bobber.ItemBobber;
import net.theawesomegem.fishingmadebetter.common.item.attachment.hook.ItemHook;
import net.theawesomegem.fishingmadebetter.common.item.attachment.reel.ItemReel;
import net.theawesomegem.fishingmadebetter.common.registry.FMBCreativeTab;

public abstract class ItemBetterFishingRod
extends ItemFishingRod {
    protected Item.ToolMaterial toolMaterial;

    public ItemBetterFishingRod(String name, Item.ToolMaterial materialIn) {
        this.toolMaterial = materialIn;
        this.func_77637_a(FMBCreativeTab.instance);
        this.func_77656_e(materialIn.func_77997_a());
        this.setRegistryName(name);
        this.func_77655_b("fishingmadebetter." + name);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.toolMaterial.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        final ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.field_71104_cf != null) {
            int dmg = playerIn.field_71104_cf.func_146034_e();
            if (!playerIn.field_71075_bZ.field_75098_d && itemstack.func_77984_f()) {
                Random rand = playerIn.func_70681_au();
                if (dmg > 0) {
                    int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)itemstack);
                    int j = 0;
                    for (int k = 0; i > 0 && k < dmg; ++k) {
                        if (!EnchantmentDurability.func_92097_a((ItemStack)itemstack, (int)i, (Random)rand)) continue;
                        ++j;
                    }
                    if ((dmg -= j) > 0) {
                        boolean reelAlive = false;
                        boolean bobberAlive = false;
                        boolean hookAlive = false;
                        if (ItemBetterFishingRod.hasReelItem(itemstack)) {
                            ItemBetterFishingRod.setReelDamage(itemstack, ItemBetterFishingRod.getReelDamage(itemstack) + dmg);
                            if (ItemBetterFishingRod.getReelDamage(itemstack) > ItemBetterFishingRod.getReelItem(itemstack).func_77612_l()) {
                                ItemBetterFishingRod.removeReelItem(itemstack);
                                playerIn.func_70669_a(itemstack);
                            } else {
                                reelAlive = true;
                            }
                        }
                        if (ItemBetterFishingRod.hasBobberItem(itemstack)) {
                            ItemBetterFishingRod.setBobberDamage(itemstack, ItemBetterFishingRod.getBobberDamage(itemstack) + dmg);
                            if (ItemBetterFishingRod.getBobberDamage(itemstack) > ItemBetterFishingRod.getBobberItem(itemstack).func_77612_l()) {
                                ItemBetterFishingRod.removeBobberItem(itemstack);
                                playerIn.func_70669_a(itemstack);
                            } else {
                                bobberAlive = true;
                            }
                        }
                        if (ItemBetterFishingRod.hasHookItem(itemstack)) {
                            ItemBetterFishingRod.setHookDamage(itemstack, ItemBetterFishingRod.getHookDamage(itemstack) + dmg);
                            if (ItemBetterFishingRod.getHookDamage(itemstack) > ItemBetterFishingRod.getHookItem(itemstack).func_77612_l()) {
                                ItemBetterFishingRod.removeHookItem(itemstack);
                                playerIn.func_70669_a(itemstack);
                            } else {
                                hookAlive = true;
                            }
                        }
                        itemstack.func_77964_b(itemstack.func_77952_i() + dmg);
                        if (itemstack.func_77952_i() > itemstack.func_77958_k()) {
                            playerIn.func_70669_a(itemstack);
                            if (reelAlive) {
                                ItemStack droppedReel = new ItemStack((Item)ItemBetterFishingRod.getReelItem(itemstack));
                                droppedReel.func_77964_b(ItemBetterFishingRod.getReelDamage(itemstack));
                                playerIn.func_70099_a(droppedReel, 1.0f);
                            }
                            if (bobberAlive) {
                                ItemStack droppedBobber = new ItemStack((Item)ItemBetterFishingRod.getBobberItem(itemstack));
                                droppedBobber.func_77964_b(ItemBetterFishingRod.getBobberDamage(itemstack));
                                playerIn.func_70099_a(droppedBobber, 1.0f);
                            }
                            if (hookAlive) {
                                ItemStack droppedHook = new ItemStack((Item)ItemBetterFishingRod.getHookItem(itemstack));
                                droppedHook.func_77964_b(ItemBetterFishingRod.getHookDamage(itemstack));
                                playerIn.func_70099_a(droppedHook, 1.0f);
                            }
                            itemstack.func_190918_g(1);
                            itemstack.func_77964_b(0);
                        }
                    }
                }
            }
            playerIn.func_184609_a(handIn);
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        } else {
            if (playerIn.func_184586_b(EnumHand.MAIN_HAND) != null && playerIn.func_184586_b(EnumHand.OFF_HAND) != null && playerIn.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemFishingRod && playerIn.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof ItemFishingRod) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
            }
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!worldIn.field_72995_K) {
                if (ItemBetterFishingRod.getBobberItem(itemstack).isLavaBobber()) {
                    EntityFMBLavaFishHook entityFishHook = new EntityFMBLavaFishHook(worldIn, playerIn);
                    worldIn.func_72838_d((Entity)entityFishHook);
                } else if (ItemBetterFishingRod.getBobberItem(itemstack).isVoidBobber()) {
                    EntityFMBVoidFishHook entityFishHook = new EntityFMBVoidFishHook(worldIn, playerIn);
                    worldIn.func_72838_d((Entity)entityFishHook);
                } else {
                    EntityFishHook entityFishHook = new EntityFishHook(worldIn, playerIn){
                        ItemStack parentRod;

                        protected void func_70088_a() {
                            super.func_70088_a();
                            this.parentRod = itemstack;
                        }

                        public void func_70071_h_() {
                            super.func_70071_h_();
                            if (this.func_190619_l() != null && this.func_190619_l().field_71104_cf != null && (this.parentRod == null || this.func_190619_l().func_184614_ca() == null || this.func_190619_l().func_184592_cb() == null || this.func_190619_l().func_184614_ca().func_77973_b() instanceof ItemFishingRod == this.func_190619_l().func_184592_cb().func_77973_b() instanceof ItemFishingRod || this.func_190619_l().func_184614_ca() == this.parentRod == (this.func_190619_l().func_184592_cb() == this.parentRod))) {
                                super.func_70106_y();
                            }
                        }
                    };
                    worldIn.func_72838_d((Entity)entityFishHook);
                }
            }
            playerIn.func_184609_a(handIn);
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemReel reel = ItemBetterFishingRod.getReelItem(stack);
        ItemBobber bobber = ItemBetterFishingRod.getBobberItem(stack);
        ItemHook hook = ItemBetterFishingRod.getHookItem(stack);
        if (GuiScreen.func_146272_n()) {
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Reel: " + TextFormatting.RESET + "" + TextFormatting.GRAY + I18n.func_135052_a((String)(reel.func_77658_a() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
            tooltip.add(reel.func_77612_l() != 0 ? "  Durability: " + (reel.func_77612_l() - ItemBetterFishingRod.getReelDamage(stack)) + "/" + reel.func_77612_l() : "  Durability: -/-");
            tooltip.add("  Reel Length: " + reel.getReelRange() + "m");
            tooltip.add("  Reel Speed: " + reel.getReelSpeed() + "m/s");
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Bobber: " + TextFormatting.RESET + "" + TextFormatting.GRAY + I18n.func_135052_a((String)(bobber.func_77658_a() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
            tooltip.add(bobber.func_77612_l() != 0 ? "  Durability: " + (bobber.func_77612_l() - ItemBetterFishingRod.getBobberDamage(stack)) + "/" + bobber.func_77612_l() : "  Durability: -/-");
            if (bobber.isLavaBobber()) {
                tooltip.add("  Can fish in: " + TextFormatting.RED + "Lava" + TextFormatting.RESET);
            } else if (bobber.isVoidBobber()) {
                tooltip.add("  Can fish in: " + TextFormatting.LIGHT_PURPLE + "Void" + TextFormatting.RESET);
            } else {
                tooltip.add("  Can fish in: " + TextFormatting.BLUE + "Water" + TextFormatting.RESET);
            }
            if (bobber.getVarianceModifier() != 0) {
                tooltip.add("  Tension Bar Size Modifier: +" + bobber.getVarianceModifier());
            }
            if (bobber.getTensioningModifier() != 0) {
                tooltip.add("  Tension Bar Speed Modifier: +" + bobber.getTensioningModifier());
            }
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Hook: " + TextFormatting.RESET + "" + TextFormatting.GRAY + I18n.func_135052_a((String)(hook.func_77658_a() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
            tooltip.add(hook.func_77612_l() != 0 ? "  Durability: " + (hook.func_77612_l() - ItemBetterFishingRod.getHookDamage(stack)) + "/" + hook.func_77612_l() : "  Durability: -/-");
            if (hook.getTuggingReduction() != 0) {
                tooltip.add("  Fish Tugging Modifier: -" + hook.getTuggingReduction());
            }
            if (hook.getTreasureModifier() != 0) {
                tooltip.add("  Treasure Chance Modifier: +" + hook.getTreasureModifier());
            }
            if (hook.getBiteRateModifier() != 0) {
                tooltip.add("  Fish Bite Rate Modifier: +" + hook.getBiteRateModifier());
            }
            if (hook.getWeightModifier() != 0) {
                tooltip.add("  Fish Weight Modifier: +" + hook.getWeightModifier());
            }
            String baitDisplayName = ItemBetterFishingRod.getBaitDisplayName(stack);
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Bait: " + TextFormatting.RESET + "" + TextFormatting.GRAY + (baitDisplayName != null && baitDisplayName.length() > 0 ? baitDisplayName : "None") + TextFormatting.RESET);
            tooltip.add("");
        } else {
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Reel: " + TextFormatting.RESET + "" + TextFormatting.GRAY + I18n.func_135052_a((String)(reel.func_77658_a() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
            tooltip.add(reel.func_77612_l() != 0 ? "  Durability: " + (reel.func_77612_l() - ItemBetterFishingRod.getReelDamage(stack)) + "/" + reel.func_77612_l() : "  Durability: -/-");
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Bobber: " + TextFormatting.RESET + "" + TextFormatting.GRAY + I18n.func_135052_a((String)(bobber.func_77658_a() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
            tooltip.add(bobber.func_77612_l() != 0 ? "  Durability: " + (bobber.func_77612_l() - ItemBetterFishingRod.getBobberDamage(stack)) + "/" + bobber.func_77612_l() : "  Durability: -/-");
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Hook: " + TextFormatting.RESET + "" + TextFormatting.GRAY + I18n.func_135052_a((String)(hook.func_77658_a() + ".name"), (Object[])new Object[0]) + TextFormatting.RESET);
            tooltip.add(hook.func_77612_l() != 0 ? "  Durability: " + (hook.func_77612_l() - ItemBetterFishingRod.getHookDamage(stack)) + "/" + hook.func_77612_l() : "  Durability: -/-");
            String baitDisplayName = ItemBetterFishingRod.getBaitDisplayName(stack);
            tooltip.add(TextFormatting.BLUE + "" + TextFormatting.BOLD + "Bait: " + TextFormatting.RESET + "" + TextFormatting.GRAY + (baitDisplayName != null && baitDisplayName.length() > 0 ? baitDisplayName : "None") + TextFormatting.RESET);
            tooltip.add("");
            tooltip.add("Hold " + TextFormatting.GOLD + "Shift" + TextFormatting.RESET + "" + TextFormatting.GRAY + " for extra information" + TextFormatting.RESET);
        }
    }

    @Nullable
    public static String getBaitItem(ItemStack itemStack) {
        return ItemBetterFishingRod.hasBait(itemStack) ? itemStack.func_77978_p().func_74779_i("BaitItem") : null;
    }

    public static void setBaitItem(ItemStack itemStack, String bait) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74778_a("BaitItem", bait);
    }

    public static void removeBait(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        itemStack.func_77978_p().func_82580_o("BaitItem");
        itemStack.func_77978_p().func_82580_o("BaitMetadata");
        itemStack.func_77978_p().func_82580_o("BaitDisplayName");
    }

    public static int getBaitMetadata(ItemStack itemStack) {
        return ItemBetterFishingRod.hasBait(itemStack) ? itemStack.func_77978_p().func_74762_e("BaitMetadata") : 0;
    }

    public static void setBaitMetadata(ItemStack itemStack, int metadata) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("BaitMetadata", metadata);
    }

    @Nullable
    public static String getBaitDisplayName(ItemStack itemStack) {
        return ItemBetterFishingRod.hasBait(itemStack) ? itemStack.func_77978_p().func_74779_i("BaitDisplayName") : null;
    }

    public static void setBaitDisplayName(ItemStack itemStack, String baitDisplayName) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74778_a("BaitDisplayName", baitDisplayName);
    }

    public static boolean hasBait(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("BaitItem");
    }

    public static boolean isBaitForFish(ItemStack itemStack, String fishId) {
        if (!ItemBetterFishingRod.hasBait(itemStack)) {
            return false;
        }
        FishData fishData = CustomConfigurationHandler.fishDataMap.get(fishId);
        if (fishData == null) {
            return false;
        }
        String baitItem = ItemBetterFishingRod.getBaitItem(itemStack);
        if (baitItem == null) {
            return false;
        }
        return fishData.baitItemMap.containsKey(baitItem) && Arrays.asList((Object[])fishData.baitItemMap.get(baitItem)).contains(ItemBetterFishingRod.getBaitMetadata(itemStack));
    }

    public static ItemReel getReelItem(ItemStack itemStack) {
        return ItemBetterFishingRod.hasReelItem(itemStack) ? (ItemReel)Item.func_111206_d((String)itemStack.func_77978_p().func_74779_i("ReelItem")) : ItemManager.REEL_BASIC;
    }

    public static void setReelItem(ItemStack itemStack, ItemReel itemReel) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74778_a("ReelItem", itemReel.getRegistryName().toString());
    }

    public static void removeReelItem(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        itemStack.func_77978_p().func_82580_o("ReelItem");
        itemStack.func_77978_p().func_82580_o("ReelDamage");
    }

    public static int getReelDamage(ItemStack itemStack) {
        return ItemBetterFishingRod.hasReelItem(itemStack) ? itemStack.func_77978_p().func_74762_e("ReelDamage") : 0;
    }

    public static void setReelDamage(ItemStack itemStack, int newDamage) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("ReelDamage", ItemBetterFishingRod.hasReelItem(itemStack) ? newDamage : 0);
    }

    public static boolean hasReelItem(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("ReelItem");
    }

    public static ItemBobber getBobberItem(ItemStack itemStack) {
        return ItemBetterFishingRod.hasBobberItem(itemStack) ? (ItemBobber)Item.func_111206_d((String)itemStack.func_77978_p().func_74779_i("BobberItem")) : ItemManager.BOBBER_BASIC;
    }

    public static void setBobberItem(ItemStack itemStack, ItemBobber itemBobber) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74778_a("BobberItem", itemBobber.getRegistryName().toString());
    }

    public static void removeBobberItem(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        itemStack.func_77978_p().func_82580_o("BobberItem");
        itemStack.func_77978_p().func_82580_o("BobberDamage");
    }

    public static int getBobberDamage(ItemStack itemStack) {
        return ItemBetterFishingRod.hasBobberItem(itemStack) ? itemStack.func_77978_p().func_74762_e("BobberDamage") : 0;
    }

    public static void setBobberDamage(ItemStack itemStack, int newDamage) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("BobberDamage", ItemBetterFishingRod.hasBobberItem(itemStack) ? newDamage : 0);
    }

    public static boolean hasBobberItem(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("BobberItem");
    }

    public static ItemHook getHookItem(ItemStack itemStack) {
        return ItemBetterFishingRod.hasHookItem(itemStack) ? (ItemHook)Item.func_111206_d((String)itemStack.func_77978_p().func_74779_i("HookItem")) : ItemManager.HOOK_BASIC;
    }

    public static void setHookItem(ItemStack itemStack, ItemHook itemHook) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74778_a("HookItem", itemHook.getRegistryName().toString());
    }

    public static void removeHookItem(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return;
        }
        itemStack.func_77978_p().func_82580_o("HookItem");
        itemStack.func_77978_p().func_82580_o("HookDamage");
    }

    public static int getHookDamage(ItemStack itemStack) {
        return ItemBetterFishingRod.hasHookItem(itemStack) ? itemStack.func_77978_p().func_74762_e("HookDamage") : 0;
    }

    public static void setHookDamage(ItemStack itemStack, int newDamage) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("HookDamage", ItemBetterFishingRod.hasHookItem(itemStack) ? newDamage : 0);
    }

    public static boolean hasHookItem(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("HookItem");
    }
}

