/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.weaponproperty;

import com.oblivioussp.spartanweaponry.api.SpartanWeaponryAPI;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponPropertyWithCallback;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class WeaponPropertyExtraDamage
extends WeaponPropertyWithCallback {
    public WeaponPropertyExtraDamage(String propType, String propModId, float propMagnitude) {
        super(propType, propModId, propMagnitude);
    }

    @Override
    public WeaponProperty.PropertyQuality getQuality() {
        return this.type == "extra_damage_thrown" ? WeaponProperty.PropertyQuality.NEUTRAL : WeaponProperty.PropertyQuality.POSITIVE;
    }

    @Override
    protected void addTooltipDescription(ItemStack stack, List<String> tooltip) {
        if (ConfigHandler.damageBonusCheckArmorValue && (this.type == "extra_damage_chest" || this.type == "extra_damage_unarmoured")) {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + "  " + SpartanWeaponryAPI.internalHandler.translateFormattedString(this.type + ".desc.armor_points", "tooltip", this.modId, MathHelper.func_76141_d((float)((this.magnitude - 1.0f) * 100.0f)), Float.valueOf(ConfigHandler.damageBonusMaxArmorValue)));
        } else {
            tooltip.add(TextFormatting.GRAY + "" + TextFormatting.ITALIC + "  " + SpartanWeaponryAPI.internalHandler.translateFormattedString(this.type + ".desc", "tooltip", this.modId, MathHelper.func_76141_d((float)((this.magnitude - 1.0f) * 100.0f))));
        }
    }

    @Override
    public float modifyDamageDealt(ToolMaterialEx material, float baseDamage, float initialDamage, DamageSource source, EntityLivingBase attacker, EntityLivingBase victim) {
        if (attacker == null || victim == null) {
            return baseDamage;
        }
        float bonusDamage = (this.getMagnitude() - 1.0f) * Math.min(baseDamage, initialDamage);
        switch (this.type) {
            case "extra_damage_chest": {
                if (victim.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
                    return !ConfigHandler.damageBonusCheckArmorValue || victim.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b() <= (double)ConfigHandler.damageBonusMaxArmorValue ? baseDamage + bonusDamage : baseDamage;
                }
            }
            case "extra_damage_unarmoured": {
                if (victim.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() && victim.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() && victim.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() && victim.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b()) {
                    return !ConfigHandler.damageBonusCheckArmorValue || victim.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111125_b() <= (double)ConfigHandler.damageBonusMaxArmorValue ? baseDamage + bonusDamage : baseDamage;
                }
                return baseDamage;
            }
            case "extra_damage_riding": {
                return attacker.func_184218_aH() ? baseDamage + bonusDamage : baseDamage;
            }
            case "extra_damage_undead": {
                return victim.func_70668_bt() == EnumCreatureAttribute.UNDEAD ? baseDamage + bonusDamage : baseDamage;
            }
            case "extra_damage_backstab": {
                Entity immediateEntity = source.func_76364_f();
                float yaw = source.func_76352_a() ? -immediateEntity.field_70177_z : immediateEntity.field_70177_z;
                float victimYaw = victim.field_70177_z;
                float difference = victimYaw - yaw;
                difference = this.posMod(difference + 180.0f, 360.0f) - 180.0f;
                boolean doBonusDamage = MathHelper.func_76135_e((float)difference) <= 30.0f;
                return doBonusDamage ? baseDamage + bonusDamage : baseDamage;
            }
        }
        return baseDamage;
    }

    private float posMod(float num, float den) {
        return (num % den + den) % den;
    }
}

