/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.init;

import com.oblivioussp.spartanweaponry.init.ItemRegistrySW;
import com.oblivioussp.spartanweaponry.util.Log;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionarySW {
    public static final String QUIVERS = "spartanweaponry:quivers";
    public static final String ARROW_QUIVERS = "spartanweaponry:arrow_quivers";
    public static final String BOLT_QUIVERS = "spartanweaponry:bolt_quivers";

    public static void init() {
        Log.info("Registering OreDictionary entries");
        OreDictionarySW.register(QUIVERS, ItemRegistrySW.quiverArrowLight, ItemRegistrySW.quiverArrowModerate, ItemRegistrySW.quiverArrowHeavy, ItemRegistrySW.quiverBoltLight, ItemRegistrySW.quiverBoltModerate, ItemRegistrySW.quiverBoltHeavy);
        OreDictionarySW.register(ARROW_QUIVERS, ItemRegistrySW.quiverArrowLight, ItemRegistrySW.quiverArrowModerate, ItemRegistrySW.quiverArrowHeavy);
        OreDictionarySW.register(BOLT_QUIVERS, ItemRegistrySW.quiverBoltLight, ItemRegistrySW.quiverBoltModerate, ItemRegistrySW.quiverBoltHeavy);
    }

    public static void register(String name, Item ... items) {
        for (Item item : items) {
            if (item == null) continue;
            OreDictionary.registerOre((String)name, (Item)item);
        }
    }

    public static boolean matches(String name, ItemStack stack) {
        NonNullList list = OreDictionary.getOres((String)name);
        if (list.isEmpty()) {
            return false;
        }
        return list.stream().anyMatch(listStack -> stack.func_185136_b(listStack));
    }
}

