/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.oblivioussp.spartanweaponry.api.IWeaponPropertyContainer;
import com.oblivioussp.spartanweaponry.api.ToolMaterialEx;
import com.oblivioussp.spartanweaponry.api.weaponproperty.IPropertyCallback;
import com.oblivioussp.spartanweaponry.api.weaponproperty.WeaponProperty;
import com.oblivioussp.spartanweaponry.client.gui.CreativeTabsSW;
import com.oblivioussp.spartanweaponry.entity.projectile.EntityThrownWeapon;
import com.oblivioussp.spartanweaponry.init.EnchantmentRegistrySW;
import com.oblivioussp.spartanweaponry.init.SoundRegistry;
import com.oblivioussp.spartanweaponry.util.ConfigHandler;
import com.oblivioussp.spartanweaponry.util.Log;
import com.oblivioussp.spartanweaponry.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemThrowingWeapon
extends Item
implements IWeaponPropertyContainer<ItemThrowingWeapon> {
    protected float attackDamage = 1.0f;
    protected double attackSpeed = 0.0;
    protected List<WeaponProperty> field_185051_m;
    protected ToolMaterialEx materialEx;
    protected String modId = null;
    protected String displayName = null;
    protected boolean doCraftCheck = true;
    protected boolean canBeCrafted = true;
    protected int maxAmmo = 1;
    protected int maxChargeTicks = 5;
    protected float throwVelocity;
    protected float throwDamageMultiplier;
    public static final String NBT_AMMO = "Ammo";
    public static final String NBT_AMMO_USED = "AmmoUsed";
    public static final String NBT_UUID = "UUID";
    public static final String NBT_ORIGINAL = "Original";

    public ItemThrowingWeapon(String unlocName, ToolMaterialEx material, float weaponDamageBase, float weaponDamageMultiplier, float weaponSpeed, int maxAmmoCapacity, WeaponProperty ... weaponProperties) {
        this.func_77637_a(CreativeTabsSW.TAB_SW);
        this.setRegistryName(unlocName);
        this.func_77655_b(unlocName);
        this.func_77625_d(1);
        this.materialEx = material;
        this.func_77656_e(this.materialEx.getMaxUses() / 4);
        this.attackDamage = Math.max(0.5f, this.materialEx.getAttackDamage() * weaponDamageMultiplier + weaponDamageBase - 1.0f);
        this.attackSpeed = weaponSpeed;
        this.maxAmmo = maxAmmoCapacity;
        this.field_185051_m = new ArrayList<WeaponProperty>();
        this.field_185051_m.addAll(Arrays.asList(weaponProperties));
        this.throwVelocity = 1.0f;
        this.throwDamageMultiplier = 1.0f;
        this.func_185043_a(new ResourceLocation("empty"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return stack.func_77942_o() && stack.func_77978_p().func_74762_e(ItemThrowingWeapon.NBT_AMMO_USED) == ItemThrowingWeapon.this.getMaxAmmo(stack) ? 1.0f : 0.0f;
            }
        });
    }

    public String func_77658_a() {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return StringHelper.getItemUnlocalizedName(super.func_77658_a());
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.modId != null) {
            return StringHelper.getItemUnlocalizedName(super.func_77658_a(), this.modId);
        }
        return StringHelper.getItemUnlocalizedName(super.func_77658_a());
    }

    public EntityThrownWeapon createThrownWeaponEntity(World world, EntityPlayer player) {
        return new EntityThrownWeapon(world, (EntityLivingBase)player);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e(NBT_AMMO_USED) == this.getMaxAmmo(stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int func_77619_b() {
        return this.materialEx.getEnchantability();
    }

    public boolean func_77616_k(ItemStack stack) {
        return stack.func_77942_o() ? (stack.func_77978_p().func_74764_b(NBT_ORIGINAL) ? stack.func_77978_p().func_74767_n(NBT_ORIGINAL) : true) : super.func_77616_k(stack);
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        if (toRepair.func_190926_b() || repair.func_190926_b()) {
            return false;
        }
        if (this.materialEx.doesOreDictMatch(repair)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        for (String type : this.getToolClasses(stack)) {
            if (!state.func_177230_c().isToolEffective(type, state)) continue;
            return this.materialEx.getEfficiency() * 0.8f;
        }
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!world.field_72995_K && state.func_185887_b(world, pos) != 0.0f) {
            this.damageItem(stack, 2, entityLiving);
        }
        return false;
    }

    public void damageItem(ItemStack stack, int damage, EntityLivingBase entity) {
        if (stack.func_77984_f() && stack.func_77942_o() && stack.func_77978_p().func_74762_e(NBT_AMMO_USED) < this.getMaxAmmo(stack) && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).field_71075_bZ.field_75098_d) && stack.func_96631_a(damage, entity.func_70681_au(), entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null)) {
            entity.func_70669_a(stack);
            if (stack.func_77942_o()) {
                int ammo = stack.func_77978_p().func_74762_e(NBT_AMMO_USED);
                stack.func_77978_p().func_74768_a(NBT_AMMO_USED, ++ammo);
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_71029_a(StatList.func_188059_c((Item)stack.func_77973_b()));
            }
            stack.func_77964_b(0);
        }
    }

    @Override
    public float getDirectAttackDamage() {
        return this.attackDamage;
    }

    public float getThrownDamageMultiplier() {
        return this.throwDamageMultiplier;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getDirectAttackDamage(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.attackSpeed - 4.0, 0));
        }
        return multimap;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e(NBT_AMMO_USED) < this.getMaxAmmo(stack)) {
            this.damageItem(stack, 2, attacker);
        }
        return true;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        int maxAmmo;
        int ammoCount;
        if (entityLiving instanceof EntityPlayer && (ammoCount = (maxAmmo = this.getMaxAmmo(stack)) - stack.func_77978_p().func_74762_e(NBT_AMMO_USED)) > 0) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            int maxCharge = this.getMaxChargeTicks(stack);
            int charge = Math.min(this.func_77626_a(stack) - timeLeft, maxCharge);
            if (!worldIn.field_72995_K) {
                int k;
                EntityThrownWeapon thrown = this.createThrownWeaponEntity(worldIn, player);
                float chargePerc = (float)charge / (float)maxCharge;
                if (thrown == null) {
                    return;
                }
                thrown.setWeapon(stack);
                int velocityBonus = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_RANGE, (ItemStack)stack);
                thrown.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.throwVelocity * ((float)velocityBonus * 0.2f + 1.0f) * (chargePerc * 0.9f + 0.1f), 0.5f);
                double damageMultiplier = (this.throwDamageMultiplier - 1.0f) * chargePerc + 1.0f;
                thrown.func_70239_b(((double)this.getDirectAttackDamage() + 1.0) * damageMultiplier);
                int j = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_DAMAGE, (ItemStack)stack);
                if (j > 0) {
                    thrown.func_70239_b(thrown.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack)) > 0) {
                    thrown.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_FIRE, (ItemStack)stack) > 0) {
                    thrown.func_70015_d(100);
                }
                if (player.field_71075_bZ.field_75098_d) {
                    thrown.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                } else if (thrown.isValidThrowingWeapon()) {
                    stack.func_77978_p().func_74768_a(NBT_AMMO_USED, maxAmmo - --ammoCount);
                    if (ammoCount == 0 && !stack.func_77978_p().func_74767_n(NBT_ORIGINAL)) {
                        stack.func_190918_g(1);
                        if (stack.func_190916_E() <= 0) {
                            player.field_71071_by.func_184437_d(stack);
                        }
                    }
                }
                if (thrown.isValidThrowingWeapon()) {
                    stack.func_77964_b(0);
                    worldIn.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundRegistry.THROWING_WEAPON_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                    worldIn.func_72838_d((Entity)thrown);
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        this.initNBT(stack, true);
        if (this.field_185051_m != null && entity instanceof EntityLivingBase) {
            IPropertyCallback callback;
            EntityLivingBase living = (EntityLivingBase)entity;
            for (WeaponProperty property : this.field_185051_m) {
                callback = property.getCallback();
                if (callback == null) continue;
                callback.onItemUpdate(this.materialEx, stack, world, living, itemSlot, isSelected);
            }
            if (this.materialEx.hasAnyWeaponProperty()) {
                for (WeaponProperty property : this.materialEx.getAllWeaponProperties()) {
                    callback = property.getCallback();
                    if (callback == null) continue;
                    callback.onItemUpdate(this.materialEx, stack, world, living, itemSlot, isSelected);
                }
            }
        }
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        IPropertyCallback callback;
        for (WeaponProperty prop : this.field_185051_m) {
            callback = prop.getCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.materialEx, stack);
        }
        for (WeaponProperty prop : this.materialEx.getAllWeaponProperties()) {
            callback = prop.getCallback();
            if (callback == null) continue;
            callback.onCreateItem(this.materialEx, stack);
        }
        this.initNBT(stack, true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            IPropertyCallback callback;
            ItemStack stack = new ItemStack((Item)this);
            for (WeaponProperty prop : this.field_185051_m) {
                callback = prop.getCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.materialEx, stack);
            }
            for (WeaponProperty prop : this.materialEx.getAllWeaponProperties()) {
                callback = prop.getCallback();
                if (callback == null) continue;
                callback.onCreateItem(this.materialEx, stack);
            }
            this.initNBT(stack, false);
            items.add((Object)stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag;
        boolean isShiftPressed = GuiScreen.func_146272_n();
        if (this.doCraftCheck && worldIn != null) {
            NonNullList ores;
            if (this.materialEx.getModId() == "spartanweaponry" && ((ores = OreDictionary.getOres((String)this.materialEx.getOreDictForRepairMaterial(), (boolean)false)) == null || ores.isEmpty())) {
                this.canBeCrafted = false;
            }
            this.doCraftCheck = false;
        }
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("enchChecked")) {
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack) != 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)stack) != 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack) != 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack) != 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185303_l, (ItemStack)stack) != 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180312_n, (ItemStack)stack) != 0 || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack) != 0) {
                stack.func_77978_p().func_74757_a("enchantmentsInvalid", true);
            }
            stack.func_77978_p().func_74757_a("enchChecked", true);
        }
        if (!ConfigHandler.forceDisableUncraftableTooltips && !this.canBeCrafted) {
            tooltip.add(TextFormatting.RED + StringHelper.translateFormattedString("cantCraftMissingMaterial", "tooltip", "spartanweaponry", StringHelper.translateString(this.materialEx.getOreDictForRepairMaterial(), "material", this.materialEx.getModId())));
        }
        if (stack.func_77942_o()) {
            tag = stack.func_77978_p();
            if (tag.func_74767_n("enchantmentsInvalid")) {
                tooltip.add(TextFormatting.RED + StringHelper.translateString("invalidEnchantments", "tooltip"));
            }
            if (tag.func_74764_b(NBT_ORIGINAL) && !tag.func_74767_n(NBT_ORIGINAL)) {
                tooltip.add(TextFormatting.DARK_RED + StringHelper.translateString("throwable.not_original", "tooltip", "spartanweaponry"));
            }
            if (tag.func_74764_b(NBT_AMMO_USED)) {
                int mxAmmo = this.getMaxAmmo(stack);
                tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("throwable.ammo", "tooltip", "spartanweaponry", TextFormatting.GRAY + StringHelper.translateFormattedString("throwable.ammo.value", "tooltip", "spartanweaponry", mxAmmo - tag.func_74762_e(NBT_AMMO_USED), mxAmmo)));
            }
        }
        tooltip.add(TextFormatting.DARK_AQUA + StringHelper.translateFormattedString("throwable.charge_time", "tooltip", "spartanweaponry", TextFormatting.GRAY + StringHelper.translateFormattedString("throwable.charge_time.value", "tooltip", Float.valueOf((float)this.getMaxChargeTicks(stack) / 20.0f))));
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_186855_b(NBT_UUID) && flagIn == ITooltipFlag.TooltipFlags.ADVANCED) {
            tooltip.add(TextFormatting.DARK_PURPLE + "UUID: " + TextFormatting.GRAY + "" + tag.func_186857_a(NBT_UUID).toString());
        }
        if (!this.field_185051_m.isEmpty() || this.materialEx.hasAnyWeaponProperty()) {
            tooltip.add(TextFormatting.GOLD + StringHelper.translateFormattedString("properties", "tooltip", "spartanweaponry", isShiftPressed ? TextFormatting.DARK_GRAY + StringHelper.translateString("showingDetails", "tooltip", "spartanweaponry") : TextFormatting.DARK_GRAY + StringHelper.translateFormattedString("showDetails", "tooltip", "spartanweaponry", TextFormatting.AQUA + "SHIFT" + TextFormatting.DARK_GRAY)));
        }
        for (WeaponProperty property : this.field_185051_m) {
            property.addTooltip(stack, tooltip, isShiftPressed);
        }
        if (this.materialEx.hasAnyWeaponProperty()) {
            tooltip.add(TextFormatting.DARK_AQUA + "Material Bonus:");
            for (WeaponProperty matProp : this.materialEx.getAllWeaponProperties()) {
                matProp.addTooltip(stack, tooltip, isShiftPressed);
            }
        }
        tooltip.add("");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public String func_77653_i(ItemStack stack) {
        if (this.displayName != null) {
            String name = I18n.func_74837_a((String)String.format("item.%s:%s.name", "spartanweaponry", this.displayName), (Object[])new Object[]{I18n.func_74838_a((String)this.materialEx.getFullUnlocName())});
            return name;
        }
        return super.func_77653_i(stack);
    }

    @Nullable
    public String getCreatorModId(ItemStack itemStack) {
        if (this.modId != null) {
            return this.modId;
        }
        return super.getCreatorModId(itemStack);
    }

    @Override
    public ItemThrowingWeapon addWeaponProperty(WeaponProperty prop) {
        this.field_185051_m.add(prop);
        return this;
    }

    @Override
    public boolean hasWeaponProperty(WeaponProperty prop) {
        return this.field_185051_m.contains(prop) || this.materialEx.getAllWeaponProperties().contains(prop);
    }

    @Override
    public WeaponProperty getFirstWeaponPropertyWithType(String type) {
        for (WeaponProperty property : this.field_185051_m) {
            if (property.getType() != type) continue;
            return property;
        }
        for (WeaponProperty property : this.materialEx.getAllWeaponProperties()) {
            if (property.getType() != type) continue;
            return property;
        }
        return null;
    }

    @Override
    public List<WeaponProperty> getAllWeaponPropertiesWithType(String type) {
        ArrayList<WeaponProperty> result = new ArrayList<WeaponProperty>();
        for (WeaponProperty property : this.field_185051_m) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        for (WeaponProperty property : this.materialEx.getAllWeaponProperties()) {
            if (property.getType() != type) continue;
            result.add(property);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @Override
    public List<WeaponProperty> getAllWeaponProperties() {
        return new ArrayList<WeaponProperty>(this.field_185051_m);
    }

    @Override
    public ToolMaterialEx getMaterialEx() {
        return this.materialEx;
    }

    protected void initNBT(ItemStack stack, boolean initUUID) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(tag = stack.func_77978_p()).func_74764_b(NBT_AMMO_USED)) {
            if (tag.func_74764_b(NBT_AMMO)) {
                Log.info("Found old ammo in item" + stack.func_77973_b().getRegistryName().toString() + "! Converted to new ammo system using a new ammo stack");
                tag.func_74768_a(NBT_AMMO_USED, this.getMaxAmmo(stack) - tag.func_74762_e(NBT_AMMO));
                tag.func_82580_o(NBT_AMMO);
            }
            tag.func_74768_a(NBT_AMMO_USED, 0);
        }
        if (initUUID && !tag.func_186855_b(NBT_UUID)) {
            stack.func_77978_p().func_186854_a(NBT_UUID, UUID.randomUUID());
            stack.func_77978_p().func_74757_a(NBT_ORIGINAL, true);
        }
    }

    public int getMaxAmmo(ItemStack stack) {
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_AMMO, (ItemStack)stack);
        int increasePerLevel = Math.max((int)((float)this.maxAmmo * 0.25f), 1);
        return this.maxAmmo + increasePerLevel * level;
    }

    public int getMaxAmmoBase() {
        return this.maxAmmo;
    }

    public int getMaxChargeTicks(ItemStack stack) {
        return (int)((float)this.maxChargeTicks * (1.0f - (float)EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistrySW.THROWING_CHARGE, (ItemStack)stack) * 0.2f));
    }
}

