/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AdvancementTrigger
implements ICriterionTrigger {
    public static final AdvancementTrigger CRAFT_ITEM = new AdvancementTrigger("craft_item");
    public static final AdvancementTrigger[] TRIGGER_ARRAY = new AdvancementTrigger[]{CRAFT_ITEM};
    private final ResourceLocation id;
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public AdvancementTrigger(String idString) {
        this.id = new ResourceLocation(idString);
    }

    public AdvancementTrigger(ResourceLocation idRes) {
        this.id = idRes;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener listener) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners == null) {
            triggerListeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, triggerListeners);
        }
        triggerListeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener listener) {
        Listeners triggerListeners = this.listeners.get(playerAdvancementsIn);
        if (triggerListeners != null) {
            triggerListeners.remove(listener);
            if (triggerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public ICriterionInstance func_192166_a(JsonObject json, JsonDeserializationContext context) {
        String type = json.get("className").getAsString();
        return new Instance(this.func_192163_a(), type);
    }

    public void trigger(EntityPlayerMP player, Item item) {
        Listeners triggerListeners = this.listeners.get(player.func_192039_O());
        if (triggerListeners != null) {
            triggerListeners.trigger(player, item);
        }
    }

    public static void registerTriggers() {
        try {
            Log.info("Attempting to add new advancement triggers...");
            Method method = ReflectionHelper.findMethod(CriteriaTriggers.class, (String)"register", (String)"func_192118_a", (Class[])new Class[]{ICriterionTrigger.class});
            method.setAccessible(true);
            for (int i = 0; i < TRIGGER_ARRAY.length; ++i) {
                method.invoke(null, TRIGGER_ARRAY[i]);
            }
            Log.info("New advancement triggers added successfully!");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            Log.error("Couldn't register advancement triggers due to an exception occuring. " + e.getMessage());
        }
    }

    protected static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements advancements) {
            this.playerAdvancements = advancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener listener) {
            this.listeners.remove(listener);
        }

        public void trigger(EntityPlayerMP player, Item item) {
            ArrayList<ICriterionTrigger.Listener> list = null;
            for (ICriterionTrigger.Listener listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(item)) continue;
                if (list == null) {
                    list = new ArrayList<ICriterionTrigger.Listener>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final String itemClass;

        public Instance(ResourceLocation criterionId, String className) {
            super(criterionId);
            this.itemClass = className;
        }

        public boolean test(Item item) {
            String canonicalName = item != null ? item.getClass().getCanonicalName() : null;
            return canonicalName != null && canonicalName.equals(this.itemClass);
        }
    }
}

