/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.blocks.SpeciesProperty;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BakedModelSapling;
import com.ferreusveritas.dynamictrees.systems.substances.SubstanceGrowth;
import com.ferreusveritas.dynamictrees.tileentity.TileEntitySpecies;
import com.ferreusveritas.dynamictrees.trees.Species;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDynamicSapling
extends Block
implements ITileEntityProvider,
IGrowable {
    public BlockDynamicSapling(String name) {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.field_149758_A = true;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{SpeciesProperty.SPECIES});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess access, BlockPos pos) {
        return state instanceof IExtendedBlockState ? ((IExtendedBlockState)state).withProperty((IUnlistedProperty)SpeciesProperty.SPECIES, (Object)this.getSpecies(access, pos, state)) : state;
    }

    public void setSpecies(World world, BlockPos pos, Species species) {
        world.func_175656_a(pos, this.func_176223_P());
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntitySpecies) {
            TileEntitySpecies speciesTE = (TileEntitySpecies)tileEntity;
            speciesTE.setSpecies(species);
        }
    }

    public Species getSpecies(IBlockAccess access, BlockPos pos, IBlockState state) {
        TileEntitySpecies tileEntitySpecies = this.getTileEntity(access, pos);
        return tileEntitySpecies != null ? tileEntitySpecies.getSpecies() : Species.NULLSPECIES;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySpecies();
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntitySpecies tileentityspecies;
        super.func_176208_a(worldIn, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (tileentityspecies = this.getTileEntity((IBlockAccess)worldIn, pos)) != null) {
            tileentityspecies.setSpecies(Species.NULLSPECIES);
        }
    }

    @Nullable
    protected TileEntitySpecies getTileEntity(IBlockAccess access, BlockPos pos) {
        TileEntity tileentity = access.func_175625_s(pos);
        return tileentity instanceof TileEntitySpecies ? (TileEntitySpecies)tileentity : null;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.func_176474_b(world, rand, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Species species;
        ISubstanceEffectProvider provider;
        ISubstanceEffect substanceEffect;
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem != null && !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ISubstanceEffectProvider && (substanceEffect = (provider = (ISubstanceEffectProvider)heldItem.func_77973_b()).getSubstanceEffect(heldItem)) instanceof SubstanceGrowth && BlockDynamicSapling.canSaplingStay(world, species = this.getSpecies((IBlockAccess)world, pos, state), pos) && species.transitionToTree(world, pos)) {
            return species.onTreeActivated(world, pos.func_177977_b(), pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
        }
        return false;
    }

    public static boolean canSaplingStay(World world, Species species, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            IBlockState blockState = world.func_180495_p(pos.func_177972_a(dir));
            Block block = blockState.func_177230_c();
            if (!TreeHelper.isBranch(block) && !(block instanceof BlockDynamicSapling)) continue;
            return false;
        }
        return world.func_175623_d(pos.func_177984_a()) && species.isAcceptableSoil(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return BlockDynamicSapling.canSaplingStay(world, this.getSpecies((IBlockAccess)world, pos, state), pos);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        Species species = this.getSpecies((IBlockAccess)world, pos, state);
        if (this.canBlockStay(world, pos, state)) {
            species.transitionToTree(world, pos);
        } else {
            this.dropBlock(world, species, state, pos);
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return this.getSpecies((IBlockAccess)world, pos, state).getSaplingSound();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(world, pos, state)) {
            this.dropBlock(world, this.getSpecies((IBlockAccess)world, pos, state), state, pos);
        }
    }

    protected void dropBlock(World world, Species tree, IBlockState state, BlockPos pos) {
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        Species species = this.getSpecies(world, pos, state);
        if (species != Species.NULLSPECIES) {
            drops.add((Object)species.getSeedStack(1));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getSpecies((IBlockAccess)world, pos, state).getSeedStack(1);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        return this.getSpecies(access, pos, state).getSaplingBoundingBox();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return this.getSpecies((IBlockAccess)world, pos, state).canGrowWithBoneMeal(world, pos);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.getSpecies((IBlockAccess)world, pos, state).canUseBoneMealNow(world, rand, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = world.func_180495_p(pos);
        Species species = (Species)((Object)((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)SpeciesProperty.SPECIES));
        IBakedModel model = BakedModelSapling.getModelForSapling(species);
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                        if (particle == null) continue;
                        particle.func_187117_a(model.func_177554_e());
                        particle.func_174846_a(pos);
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        BlockPos pos = target.func_178782_a();
        if (state instanceof IExtendedBlockState) {
            Species species = (Species)((Object)((IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)world, pos)).getValue((IUnlistedProperty)SpeciesProperty.SPECIES));
            IBakedModel model = BakedModelSapling.getModelForSapling(species);
            Random rand = world.field_73012_v;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            AxisAlignedBB axisalignedbb = state.func_185900_c((IBlockAccess)world, pos);
            double d0 = (double)x + rand.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - 0.2) + 0.1 + axisalignedbb.field_72340_a;
            double d1 = (double)y + rand.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - 0.2) + 0.1 + axisalignedbb.field_72338_b;
            double d2 = (double)z + rand.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - 0.2) + 0.1 + axisalignedbb.field_72339_c;
            switch (target.field_178784_b) {
                case DOWN: {
                    d1 = (double)y + axisalignedbb.field_72338_b - 0.1;
                    break;
                }
                case UP: {
                    d1 = (double)y + axisalignedbb.field_72337_e + 0.1;
                    break;
                }
                case NORTH: {
                    d2 = (double)z + axisalignedbb.field_72339_c - 0.1;
                    break;
                }
                case SOUTH: {
                    d2 = (double)z + axisalignedbb.field_72334_f + 0.1;
                    break;
                }
                case WEST: {
                    d0 = (double)x + axisalignedbb.field_72340_a - 0.1;
                    break;
                }
                case EAST: {
                    d0 = (double)x + axisalignedbb.field_72336_d + 0.1;
                }
            }
            ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            if (particle != null) {
                particle.func_187117_a(model.func_177554_e());
                particle.func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f);
            }
        }
        return true;
    }
}

