/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.entities;

import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityLingeringEffector
extends Entity {
    public BlockPos blockPos;
    public ISubstanceEffect effect;
    public boolean extended;
    private byte invalidTicks = 0;

    public EntityLingeringEffector(World world, BlockPos pos, ISubstanceEffect effect) {
        super(world);
        this.field_70130_N = 1.0f;
        this.field_70131_O = 1.0f;
        this.field_70145_X = true;
        this.setBlockPos(pos);
        this.setEffect(effect);
        if (this.effect != null) {
            for (EntityLingeringEffector effector : world.func_72872_a(EntityLingeringEffector.class, new AxisAlignedBB(pos))) {
                if (!effector.getBlockPos().equals((Object)pos) || !effector.getEffect().getName().equals(effect.getName())) continue;
                effector.func_70106_y();
            }
        }
    }

    public static boolean treeHasEffectorForEffect(World world, BlockPos pos, ISubstanceEffect effect) {
        for (EntityLingeringEffector effector : world.func_72872_a(EntityLingeringEffector.class, new AxisAlignedBB(pos))) {
            if (effector.getEffect() == null || !effector.getEffect().getName().equals(effect.getName())) continue;
            return true;
        }
        return false;
    }

    public void setBlockPos(BlockPos pos) {
        this.blockPos = pos;
        this.func_70107_b((double)this.blockPos.func_177958_n() + 0.5, this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p() + 0.5);
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void setEffect(ISubstanceEffect effect) {
        this.effect = effect;
    }

    public ISubstanceEffect getEffect() {
        return this.effect;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.effect == null) {
            this.invalidTicks = (byte)(this.invalidTicks + 1);
            if (this.invalidTicks > 20) {
                this.func_70106_y();
            }
            return;
        }
        if (this.effect != null) {
            IBlockState state = this.field_70170_p.func_180495_p(this.blockPos);
            if (state.func_177230_c() instanceof BlockRooty) {
                if (!this.effect.update(this.field_70170_p, this.blockPos, this.field_70173_aa, (Integer)state.func_177229_b((IProperty)BlockRooty.LIFE))) {
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }
}

