/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.seasons;

import com.ferreusveritas.dynamictrees.api.seasons.ClimateZoneType;
import com.ferreusveritas.dynamictrees.api.seasons.ISeasonGrowthCalculator;
import net.minecraft.util.math.MathHelper;

public class SeasonGrowthCalculatorActive
implements ISeasonGrowthCalculator {
    protected float clippedsineWave(float seasonValue, float qPhase, float amplitude, float bias) {
        return MathHelper.func_76131_a((float)((float)Math.sin((double)(seasonValue / 2.0f) * Math.PI + 0.7853981633974483 * (double)qPhase) * amplitude + bias), (float)0.0f, (float)1.0f);
    }

    @Override
    public float calcGrowthRate(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        switch (type) {
            case TEMPERATE: {
                return this.clippedsineWave(seasonValue.floatValue(), 7.0f, 0.8f, 1.0f);
            }
            case TROPICAL: {
                return this.clippedsineWave(seasonValue.floatValue(), 2.0f, 0.31f, 0.9f);
            }
        }
        return 1.0f;
    }

    @Override
    public float calcSeedDropRate(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        switch (type) {
            case TEMPERATE: {
                return this.clippedsineWave(seasonValue.floatValue(), 5.0f, 1.5f, -0.25f);
            }
            case TROPICAL: {
                return this.clippedsineWave(seasonValue.floatValue(), 7.0f, 0.31f, 0.9f);
            }
        }
        return 1.0f;
    }

    @Override
    public float calcFruitProduction(Float seasonValue, ClimateZoneType type) {
        if (seasonValue == null) {
            return 1.0f;
        }
        switch (type) {
            case TEMPERATE: {
                return this.clippedsineWave(seasonValue.floatValue(), 7.0f, 1.0f, 1.0f);
            }
            case TROPICAL: {
                return this.clippedsineWave(seasonValue.floatValue(), 1.0f, 0.31f, 0.9f);
            }
        }
        return 1.0f;
    }
}

