/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.List;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class FeatureGenUndergrowth
implements IPostGenFeature {
    @Override
    public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
        if (safeBounds != SafeChunkBounds.ANY && radius > 2) {
            Vec3d vTree = new Vec3d((Vec3i)rootPos).func_72441_c(0.5, 0.5, 0.5);
            for (int i = 0; i < 2; ++i) {
                IBlockState soilBlockState;
                BlockPos pos;
                int rad = MathHelper.func_76125_a((int)(world.field_73012_v.nextInt(radius - 2) + 2), (int)2, (int)(radius - 1));
                Vec3d v = vTree.func_178787_e(new Vec3d(1.0, 0.0, 0.0).func_186678_a((double)rad).func_178785_b((float)((double)world.field_73012_v.nextFloat() * Math.PI * 2.0)));
                BlockPos vPos = new BlockPos(v);
                if (!safeBounds.inBounds(vPos, true) || !species.isAcceptableSoil(world, pos = CoordUtils.findGround(world, vPos), soilBlockState = world.func_180495_p(pos))) continue;
                int type = world.field_73012_v.nextInt(2);
                world.func_175656_a(pos, Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)(type == 0 ? BlockPlanks.EnumType.OAK : BlockPlanks.EnumType.JUNGLE)));
                pos = pos.func_177981_b(world.field_73012_v.nextInt(3));
                IBlockState leavesState = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)(type == 0 ? BlockPlanks.EnumType.OAK : BlockPlanks.EnumType.JUNGLE)).func_177226_a((IProperty)BlockOldLeaf.field_176236_b, (Comparable)Boolean.valueOf(false));
                SimpleVoxmap leafMap = species.getLeavesProperties().getCellKit().getLeafCluster();
                BlockPos.MutableBlockPos leafPos = new BlockPos.MutableBlockPos();
                for (BlockPos.MutableBlockPos dPos : leafMap.getAllNonZero()) {
                    leafPos.func_181079_c(pos.func_177958_n() + dPos.func_177958_n(), pos.func_177956_o() + dPos.func_177956_o(), pos.func_177952_p() + dPos.func_177952_p());
                    if (!safeBounds.inBounds((BlockPos)leafPos, true) || CoordUtils.coordHashCode((BlockPos)leafPos, 0) % 5 == 0 || !world.func_180495_p((BlockPos)leafPos).func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)leafPos)) continue;
                    world.func_175656_a((BlockPos)leafPos, leavesState);
                }
            }
            return true;
        }
        return false;
    }
}

