/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;

public class BlockBounds {
    public static final BlockBounds INVALID = new BlockBounds(){

        @Override
        public boolean inBounds(BlockPos pos) {
            return false;
        }
    };
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;

    private BlockBounds() {
    }

    public BlockBounds(BlockPos pos) {
        this.minX = this.maxX = pos.func_177958_n();
        this.minY = this.maxY = pos.func_177956_o();
        this.minZ = this.maxZ = pos.func_177952_p();
    }

    public BlockBounds(BlockPos min, BlockPos max) {
        this.minX = min.func_177958_n();
        this.minY = min.func_177956_o();
        this.minZ = min.func_177952_p();
        this.maxX = max.func_177958_n();
        this.maxY = max.func_177956_o();
        this.maxZ = max.func_177952_p();
    }

    public BlockBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public BlockBounds(ChunkPos cPos) {
        this.minX = cPos.func_180334_c();
        this.minY = 0;
        this.minZ = cPos.func_180333_d();
        this.maxX = cPos.func_180332_e();
        this.maxY = 255;
        this.maxZ = cPos.func_180330_f();
    }

    public BlockBounds(BlockBounds other) {
        this.minX = other.minX;
        this.minY = other.minY;
        this.minZ = other.minZ;
        this.maxX = other.maxX;
        this.maxY = other.maxY;
        this.maxZ = other.maxZ;
    }

    public BlockBounds(List<BlockPos> blockPosList) {
        this(blockPosList.get(0));
        this.union(blockPosList);
    }

    public BlockBounds union(BlockPos pos) {
        if (pos.func_177958_n() < this.minX) {
            this.minX = pos.func_177958_n();
        } else if (pos.func_177958_n() > this.maxX) {
            this.maxX = pos.func_177958_n();
        }
        if (pos.func_177956_o() < this.minY) {
            this.minY = pos.func_177956_o();
        } else if (pos.func_177956_o() > this.maxY) {
            this.maxY = pos.func_177956_o();
        }
        if (pos.func_177952_p() < this.minZ) {
            this.minZ = pos.func_177952_p();
        } else if (pos.func_177952_p() > this.maxZ) {
            this.maxZ = pos.func_177952_p();
        }
        return this;
    }

    public BlockBounds union(List<BlockPos> blockPosList) {
        blockPosList.forEach(b -> this.union((BlockPos)b));
        return this;
    }

    public boolean inBounds(BlockPos pos) {
        return pos.func_177958_n() >= this.minX && pos.func_177958_n() <= this.maxX && pos.func_177956_o() >= this.minY && pos.func_177956_o() <= this.maxY && pos.func_177952_p() >= this.minZ && pos.func_177952_p() <= this.maxZ;
    }

    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public BlockBounds expand(EnumFacing dir, int amount) {
        switch (dir) {
            case DOWN: {
                this.minY -= amount;
                break;
            }
            case UP: {
                this.maxY += amount;
                break;
            }
            case NORTH: {
                this.minZ -= amount;
                break;
            }
            case SOUTH: {
                this.maxZ += amount;
                break;
            }
            case WEST: {
                this.minX -= amount;
                break;
            }
            case EAST: {
                this.maxX += amount;
            }
        }
        return this;
    }

    public BlockBounds shrink(EnumFacing dir, int amount) {
        return this.expand(dir, -amount);
    }

    public BlockBounds move(int x, int y, int z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public BlockBounds move(BlockPos offset) {
        return this.move(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
    }

    public BlockBounds expand(int amount) {
        this.minX -= amount;
        this.minY -= amount;
        this.minZ -= amount;
        this.maxX += amount;
        this.maxY += amount;
        this.maxZ += amount;
        return this;
    }

    public BlockBounds shrink(int amount) {
        return this.expand(-amount);
    }

    public Iterable<BlockPos.MutableBlockPos> iterate() {
        return BlockPos.func_191531_b((int)this.minX, (int)this.minY, (int)this.minZ, (int)this.maxX, (int)this.maxY, (int)this.maxZ);
    }

    public int getXSize() {
        return this.maxX - this.minX + 1;
    }

    public int getYSize() {
        return this.maxY - this.minY + 1;
    }

    public int getZSize() {
        return this.maxZ - this.minZ + 1;
    }

    public String toString() {
        return this != INVALID ? "Bounds{x1=" + this.minX + ", y1=" + this.minY + ", z1=" + this.minZ + " -> x2=" + this.maxX + ", y2=" + this.maxY + ", z2=" + this.maxZ + "}" : "Invalid";
    }
}

