/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.BlockBounds;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BranchDestructionData {
    public final Species species;
    public final int[] destroyedBranchesRadiusPosition;
    public final int[] destroyedBranchesConnections;
    public final int[] destroyedBranchesBlockIndex;
    public final int[] destroyedLeaves;
    public final int[] destroyedLeavesBlockIndex;
    public final List<BlockBranch.BlockItemStack> leavesDrops;
    public final int[] endPoints;
    public final float woodVolume;
    public final EnumFacing cutDir;
    public final EnumFacing toolDir;
    public final BlockPos cutPos;
    public final int trunkHeight;
    public static final BlockBounds bounds = new BlockBounds(new BlockPos(-64, -64, -64), new BlockPos(64, 64, 64));

    public BranchDestructionData() {
        this.species = Species.NULLSPECIES;
        this.destroyedBranchesConnections = new int[0];
        this.destroyedBranchesRadiusPosition = new int[0];
        this.destroyedBranchesBlockIndex = new int[0];
        this.destroyedLeaves = new int[0];
        this.destroyedLeavesBlockIndex = new int[0];
        this.leavesDrops = new ArrayList<BlockBranch.BlockItemStack>(0);
        this.endPoints = new int[0];
        this.woodVolume = 0.0f;
        this.cutDir = EnumFacing.DOWN;
        this.toolDir = EnumFacing.DOWN;
        this.cutPos = BlockPos.field_177992_a;
        this.trunkHeight = 0;
    }

    public BranchDestructionData(Species species, Map<BlockPos, IExtendedBlockState> branches, Map<BlockPos, IBlockState> leaves, List<BlockBranch.BlockItemStack> leavesDrops, List<BlockPos> ends, float volume, BlockPos cutPos, EnumFacing cutDir, EnumFacing toolDir, int trunkHeight) {
        this.species = species;
        int[][] encodedBranchData = this.convertBranchesToIntArrays(branches);
        this.destroyedBranchesRadiusPosition = encodedBranchData[0];
        this.destroyedBranchesConnections = encodedBranchData[1];
        this.destroyedBranchesBlockIndex = encodedBranchData[2];
        int[][] encodedLeavesData = this.convertLeavesToIntArray(leaves);
        this.destroyedLeaves = encodedLeavesData[0];
        this.destroyedLeavesBlockIndex = encodedLeavesData[1];
        this.leavesDrops = leavesDrops;
        this.endPoints = this.convertEndPointsToIntArray(ends);
        this.woodVolume = volume;
        this.cutPos = cutPos;
        this.cutDir = cutDir;
        this.toolDir = toolDir;
        this.trunkHeight = trunkHeight;
    }

    public BranchDestructionData(NBTTagCompound nbt) {
        this.species = TreeRegistry.findSpecies(new ResourceLocation(nbt.func_74779_i("species")));
        this.destroyedBranchesRadiusPosition = nbt.func_74759_k("branchpos");
        this.destroyedBranchesConnections = nbt.func_74759_k("branchcon");
        this.destroyedBranchesBlockIndex = nbt.func_74759_k("branchblock");
        this.destroyedLeaves = nbt.func_74759_k("leaves");
        this.destroyedLeavesBlockIndex = nbt.func_74759_k("leavesblock");
        this.leavesDrops = new ArrayList<BlockBranch.BlockItemStack>();
        this.endPoints = nbt.func_74759_k("ends");
        this.woodVolume = nbt.func_74760_g("volume");
        this.cutPos = new BlockPos(nbt.func_74762_e("cutx"), nbt.func_74762_e("cuty"), nbt.func_74762_e("cutz"));
        this.cutDir = EnumFacing.values()[MathHelper.func_76125_a((int)nbt.func_74762_e("cutdir"), (int)0, (int)(EnumFacing.values().length - 1))];
        this.toolDir = EnumFacing.values()[MathHelper.func_76125_a((int)nbt.func_74762_e("tooldir"), (int)0, (int)(EnumFacing.values().length - 1))];
        this.trunkHeight = nbt.func_74762_e("trunkheight");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("species", this.species.toString());
        tag.func_74783_a("branchpos", this.destroyedBranchesRadiusPosition);
        tag.func_74783_a("branchcon", this.destroyedBranchesConnections);
        tag.func_74783_a("branchblock", this.destroyedBranchesBlockIndex);
        tag.func_74783_a("leaves", this.destroyedLeaves);
        tag.func_74783_a("leavesblock", this.destroyedLeavesBlockIndex);
        tag.func_74783_a("ends", this.endPoints);
        tag.func_74776_a("volume", this.woodVolume);
        tag.func_74768_a("cutx", this.cutPos.func_177958_n());
        tag.func_74768_a("cuty", this.cutPos.func_177956_o());
        tag.func_74768_a("cutz", this.cutPos.func_177952_p());
        tag.func_74768_a("cutdir", this.cutDir.func_176745_a());
        tag.func_74768_a("tooldir", this.toolDir.func_176745_a());
        tag.func_74768_a("trunkheight", this.trunkHeight);
        return tag;
    }

    private int[][] convertBranchesToIntArrays(Map<BlockPos, IExtendedBlockState> branchList) {
        int[] relPosData = new int[branchList.size()];
        int[] connectionData = new int[branchList.size()];
        int[] blockIndexData = new int[branchList.size()];
        int index = 0;
        IExtendedBlockState origExState = branchList.get(BlockPos.field_177992_a);
        if (origExState != null) {
            relPosData[index] = this.encodeBranchesRadiusPos(BlockPos.field_177992_a, (BlockBranch)origExState.func_177230_c(), (IBlockState)origExState);
            connectionData[index] = this.encodeBranchesConnections(origExState);
            blockIndexData[index++] = this.encodeBranchBlocks((BlockBranch)origExState.func_177230_c());
            branchList.remove(BlockPos.field_177992_a);
        }
        for (Map.Entry<BlockPos, IExtendedBlockState> set : branchList.entrySet()) {
            BlockPos relPos = set.getKey();
            IExtendedBlockState exState = set.getValue();
            Block block = exState.func_177230_c();
            if (!(block instanceof BlockBranch) || !bounds.inBounds(relPos)) continue;
            relPosData[index] = this.encodeBranchesRadiusPos(relPos, (BlockBranch)block, (IBlockState)exState);
            connectionData[index] = this.encodeBranchesConnections(exState);
            blockIndexData[index++] = this.encodeBranchBlocks((BlockBranch)block);
        }
        relPosData = Arrays.copyOf(relPosData, index);
        connectionData = Arrays.copyOf(connectionData, index);
        blockIndexData = Arrays.copyOf(blockIndexData, index);
        return new int[][]{relPosData, connectionData, blockIndexData};
    }

    private int encodeBranchesRadiusPos(BlockPos relPos, BlockBranch branchBlock, IBlockState state) {
        return (branchBlock.getRadius(state) & 0x1F) << 24 | this.encodeRelBlockPos(relPos);
    }

    private int encodeBranchesConnections(IExtendedBlockState exState) {
        int result = 0;
        for (EnumFacing face : EnumFacing.values()) {
            int rad = (Integer)exState.getValue(BlockBranch.CONNECTIONS[face.func_176745_a()]);
            result |= (rad & 0x1F) << face.func_176745_a() * 5;
        }
        return result;
    }

    private int encodeBranchBlocks(BlockBranch branch) {
        return branch.getFamily().getBranchBlockIndex(branch);
    }

    public int getNumBranches() {
        return this.destroyedBranchesRadiusPosition.length;
    }

    public BlockPos getBranchRelPos(int index) {
        return this.decodeRelPos(this.destroyedBranchesRadiusPosition[index]);
    }

    public int getBranchRadius(int index) {
        return this.decodeBranchRadius(this.destroyedBranchesRadiusPosition[index]);
    }

    private int decodeBranchRadius(int encoded) {
        return encoded >> 24 & 0x1F;
    }

    public IExtendedBlockState getBranchBlockState(int index) {
        return this.decodeBranchBlockState(this.destroyedBranchesRadiusPosition[index], this.destroyedBranchesConnections[index], this.destroyedBranchesBlockIndex[index]);
    }

    private IExtendedBlockState decodeBranchBlockState(int encodedRadPos, int encodedConnections, int encodedBlockIndex) {
        int radius;
        IBlockState state;
        BlockBranch branch = this.species.getFamily().getValidBranchBlock(encodedBlockIndex);
        if (branch != null && (state = branch.getStateForRadius(radius = this.decodeBranchRadius(encodedRadPos))) instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            for (EnumFacing face : EnumFacing.values()) {
                int rad = encodedConnections >> face.func_176745_a() * 5 & 0x1F;
                exState = exState.withProperty(BlockBranch.CONNECTIONS[face.func_176745_a()], (Object)MathHelper.func_76125_a((int)rad, (int)0, (int)8));
            }
            return exState;
        }
        return null;
    }

    private int[][] convertLeavesToIntArray(Map<BlockPos, IBlockState> leavesList) {
        int[] posData = new int[leavesList.size()];
        int[] blockIndexData = new int[leavesList.size()];
        int index = 0;
        for (Map.Entry<BlockPos, IBlockState> set : leavesList.entrySet()) {
            BlockPos relPos = set.getKey();
            IBlockState state = set.getValue();
            Block block = state.func_177230_c();
            if (!(block instanceof BlockDynamicLeaves) || !bounds.inBounds(relPos)) continue;
            posData[index] = this.encodeLeaves(relPos, (BlockDynamicLeaves)block, state);
            blockIndexData[index++] = this.encodeLeavesBlocks(state, this.species);
        }
        posData = Arrays.copyOf(posData, index);
        blockIndexData = Arrays.copyOf(blockIndexData, index);
        return new int[][]{posData, blockIndexData};
    }

    private int encodeLeaves(BlockPos relPos, BlockDynamicLeaves block, IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockDynamicLeaves.HYDRO) << 24 | this.encodeRelBlockPos(relPos);
    }

    private int encodeLeavesBlocks(IBlockState state, Species species) {
        return species.getLeavesBlockIndex(state);
    }

    public int getNumLeaves() {
        return this.destroyedLeaves.length;
    }

    public BlockPos getLeavesRelPos(int index) {
        return this.decodeLeavesRelPos(this.destroyedLeaves[index]);
    }

    private BlockPos decodeLeavesRelPos(int encoded) {
        return this.decodeRelPos(encoded);
    }

    public int getLeavesHydro(int index) {
        return this.decodeLeavesHydro(this.destroyedLeaves[index]);
    }

    private int decodeLeavesHydro(int encoded) {
        return encoded >> 24 & 0xF;
    }

    public ILeavesProperties getLeavesProperties(int index) {
        return this.species.getValidLeavesProperties(this.destroyedLeavesBlockIndex[index]);
    }

    public IBlockState getLeavesBlockState(int index) {
        return this.species.getValidLeavesBlock(this.destroyedLeavesBlockIndex[index]);
    }

    private int[] convertEndPointsToIntArray(List<BlockPos> endPoints) {
        int[] data = new int[endPoints.size()];
        int index = 0;
        for (BlockPos relPos : endPoints) {
            if (!bounds.inBounds(relPos)) continue;
            data[index++] = this.encodeRelBlockPos(relPos);
        }
        return Arrays.copyOf(data, index);
    }

    public int getNumEndpoints() {
        return this.endPoints.length;
    }

    public BlockPos getEndPointRelPos(int index) {
        return this.decodeRelPos(this.endPoints[index]);
    }

    public Iterable<BlockPos> getPositions(PosType posType) {
        return this.getPositions(posType, true);
    }

    public Iterable<BlockPos> getPositions(PosType posType, boolean absolute) {
        int limit;
        Function<Integer, BlockPos> getter;
        switch (posType) {
            default: {
                getter = absolute ? i -> this.getBranchRelPos((int)i).func_177971_a((Vec3i)this.cutPos) : i -> this.getBranchRelPos((int)i);
                limit = this.getNumBranches();
                break;
            }
            case ENDPOINTS: {
                getter = absolute ? i -> this.getEndPointRelPos((int)i).func_177971_a((Vec3i)this.cutPos) : i -> this.getEndPointRelPos((int)i);
                limit = this.getNumEndpoints();
                break;
            }
            case LEAVES: {
                getter = absolute ? i -> this.getLeavesRelPos((int)i).func_177971_a((Vec3i)this.cutPos) : i -> this.getLeavesRelPos((int)i);
                limit = this.getNumLeaves();
            }
        }
        return new Iterable<BlockPos>(){

            @Override
            public Iterator<BlockPos> iterator() {
                return new AbstractIterator<BlockPos>(){
                    private int index = 0;

                    protected BlockPos computeNext() {
                        return this.index < limit ? (BlockPos)getter.apply(this.index++) : (BlockPos)this.endOfData();
                    }
                };
            }
        };
    }

    private int encodeRelBlockPos(BlockPos relPos) {
        return (relPos.func_177958_n() + 64 & 0xFF) << 16 | (relPos.func_177956_o() + 64 & 0xFF) << 8 | (relPos.func_177952_p() + 64 & 0xFF) << 0;
    }

    private BlockPos decodeRelPos(int encoded) {
        return new BlockPos((encoded >> 16 & 0xFF) - 64, (encoded >> 8 & 0xFF) - 64, (encoded >> 0 & 0xFF) - 64);
    }

    public static enum PosType {
        BRANCHES,
        LEAVES,
        ENDPOINTS;

    }
}

