/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.cells.LeafClusters;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeCoder;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeCollector;
import com.ferreusveritas.dynamictrees.systems.nodemappers.NodeFindEnds;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class JoCode {
    private static final String base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    protected static final byte forkCode = 6;
    protected static final byte returnCode = 7;
    public static boolean secondChanceRegen = false;
    public byte[] instructions = new byte[0];
    protected boolean careful = false;
    private final byte[][] dirmap = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 3, 2, 5, 4, 6, 7}, {0, 1, 5, 4, 2, 3, 6, 7}, {0, 1, 4, 5, 3, 2, 6, 7}};
    private byte[] facingMap = this.dirmap[2];
    private byte[] unfacingMap = this.dirmap[2];

    public JoCode(World world, BlockPos rootPos, EnumFacing facing) {
        Optional<BlockBranch> branch = TreeHelper.getBranchOpt(world.func_180495_p(rootPos.func_177984_a()));
        if (branch.isPresent()) {
            NodeCoder coder = new NodeCoder();
            branch.get().analyse(world.func_180495_p(rootPos), world, rootPos, EnumFacing.DOWN, new MapSignal(coder));
            this.instructions = coder.compile(this);
            this.rotate(facing);
        }
    }

    public JoCode(World world, BlockPos pos) {
        this(world, pos, EnumFacing.SOUTH);
    }

    public JoCode(String code) {
        this.instructions = JoCode.decode(code);
    }

    public JoCode setCareful(boolean c) {
        this.careful = c;
        return this;
    }

    protected int getCode(int pos) {
        return this.unfacingMap[this.instructions[pos]];
    }

    public JoCode setFacing(EnumFacing facing) {
        int faceNum = facing.ordinal();
        this.facingMap = this.dirmap[faceNum];
        faceNum = faceNum == 4 ? 5 : (faceNum == 5 ? 4 : faceNum);
        this.unfacingMap = this.dirmap[faceNum];
        return this;
    }

    public JoCode rotate(EnumFacing dir) {
        this.setFacing(dir);
        for (int c = 0; c < this.instructions.length; ++c) {
            this.instructions[c] = this.facingMap[this.instructions[c]];
        }
        return this;
    }

    public void generate(World world, Species species, BlockPos rootPosIn, Biome biome, EnumFacing facing, int radius, SafeChunkBounds safeBounds) {
        boolean worldGen = safeBounds != SafeChunkBounds.ANY;
        radius = MathHelper.func_76125_a((int)radius, (int)2, (int)8);
        this.setFacing(facing);
        BlockPos rootPos = species.preGeneration(world, rootPosIn, radius, facing, safeBounds, this);
        if (rootPos != BlockPos.field_177992_a) {
            IBlockState initialDirtState = world.func_180495_p(rootPos);
            species.placeRootyDirtBlock(world, rootPos, 0);
            this.generateFork(world, species, 0, rootPos, false);
            BlockPos treePos = rootPos.func_177984_a();
            IBlockState treeState = world.func_180495_p(treePos);
            BlockBranch branch = TreeHelper.getBranch(treeState);
            if (branch != null) {
                BlockPos.MutableBlockPos cellPos;
                ILeavesProperties leavesProperties = species.getLeavesProperties();
                SimpleVoxmap leafMap = new SimpleVoxmap(radius * 2 + 1, species.getWorldGenLeafMapHeight(), radius * 2 + 1).setMapAndCenter(treePos, new BlockPos(radius, 0, radius));
                INodeInspector inflator = species.getNodeInflator(leafMap);
                NodeFindEnds endFinder = new NodeFindEnds();
                MapSignal signal = new MapSignal(inflator, endFinder);
                signal.destroyLoopedNodes = this.careful;
                branch.analyse(treeState, world, treePos, EnumFacing.DOWN, signal);
                if (signal.found || signal.overflow) {
                    DynamicTrees.log.debug("Non-viable branch network detected during world generation @ " + treePos);
                    DynamicTrees.log.debug("Species: " + (Object)((Object)species));
                    DynamicTrees.log.debug("Radius: " + radius);
                    DynamicTrees.log.debug("JoCode: " + this);
                    this.cleanupFrankentree(world, treePos, treeState, endFinder.getEnds(), safeBounds);
                    if (!secondChanceRegen) {
                        secondChanceRegen = true;
                        this.generate(world, species, rootPosIn, biome, facing, radius, safeBounds);
                    }
                    secondChanceRegen = false;
                    return;
                }
                List<BlockPos> endPoints = endFinder.getEnds();
                this.smother(leafMap, leavesProperties);
                for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells((byte)15)) {
                    cellPos = cell.getPos();
                    if (safeBounds.inBounds((BlockPos)cellPos, false)) {
                        IBlockState testBlockState = world.func_180495_p((BlockPos)cellPos);
                        Block testBlock = testBlockState.func_177230_c();
                        if (!testBlock.func_176200_f((IBlockAccess)world, (BlockPos)cellPos)) continue;
                        world.func_180501_a((BlockPos)cellPos, leavesProperties.getDynamicLeavesState(cell.getValue()), worldGen ? 16 : 2);
                        continue;
                    }
                    leafMap.setVoxel((BlockPos)cellPos, (byte)0);
                }
                for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells()) {
                    cellPos = cell.getPos();
                    if (safeBounds.inBounds((BlockPos)cellPos, true)) continue;
                    leafMap.setVoxel((BlockPos)cellPos, (byte)0);
                }
                TreeHelper.ageVolume(world, leafMap, species.getWorldGenAgeIterations(), safeBounds);
                if (species.handleRot(world, endPoints, rootPos, treePos, 0, safeBounds)) {
                    return;
                }
                species.postGeneration(world, rootPos, biome, radius, endPoints, safeBounds, initialDirtState);
                MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(world, species, rootPos, endPoints, safeBounds, initialDirtState));
                this.addSnow(leafMap, world, rootPos, biome);
            } else {
                world.func_180501_a(rootPos, initialDirtState, this.careful ? 3 : 2);
            }
        }
    }

    protected void cleanupFrankentree(World world, BlockPos treePos, IBlockState treeState, List<BlockPos> endPoints, SafeChunkBounds safeBounds) {
        HashSet blocksToDestroy = new HashSet();
        BlockBranch branch = TreeHelper.getBranch(treeState);
        MapSignal signal = new MapSignal(new NodeCollector(blocksToDestroy));
        signal.destroyLoopedNodes = false;
        signal.trackVisited = true;
        branch.analyse(treeState, world, treePos, null, signal);
        BlockBranch.destroyMode = BlockBranch.EnumDestroyMode.IGNORE;
        for (BlockPos pos : blocksToDestroy) {
            SimpleVoxmap leafCluster;
            ILeavesProperties leavesProperties;
            IBlockState branchState;
            Optional<BlockBranch> branchBlock;
            if (!safeBounds.inBounds(pos, false) || !(branchBlock = TreeHelper.getBranchOpt(branchState = world.func_180495_p(pos))).isPresent()) continue;
            int radius = branchBlock.get().getRadius(branchState);
            TreeFamily family = branchBlock.get().getFamily();
            Species species = family.getCommonSpecies();
            if (family.getPrimaryThickness() == (float)radius && (leavesProperties = species.getLeavesProperties()) != LeavesProperties.NULLPROPERTIES && (leafCluster = leavesProperties.getCellKit().getLeafCluster()) != LeafClusters.NULLMAP) {
                for (SimpleVoxmap.Cell cell : leafCluster.getAllNonZeroCells()) {
                    IBlockState leavesState;
                    BlockPos delPos = pos.func_177971_a((Vec3i)cell.getPos());
                    if (!safeBounds.inBounds(delPos, false) || !TreeHelper.isLeaves(leavesState = world.func_180495_p(delPos))) continue;
                    BlockDynamicLeaves leavesBlock = (BlockDynamicLeaves)leavesState.func_177230_c();
                    if (leavesProperties.getTree() != leavesBlock.getProperties(leavesState).getTree()) continue;
                    world.func_180501_a(delPos, ModBlocks.blockStates.air, 2);
                }
            }
            world.func_180501_a(pos, ModBlocks.blockStates.air, 2);
        }
        BlockBranch.destroyMode = BlockBranch.EnumDestroyMode.HARVEST;
    }

    protected int generateFork(World world, Species species, int codePos, BlockPos pos, boolean disabled) {
        block4: while (codePos < this.instructions.length) {
            int code = this.getCode(codePos);
            switch (code) {
                case 6: {
                    codePos = this.generateFork(world, species, codePos + 1, pos, disabled);
                    continue block4;
                }
                case 7: {
                    return codePos + 1;
                }
            }
            EnumFacing dir = EnumFacing.func_82600_a((int)code);
            pos = pos.func_177972_a(dir);
            if (!disabled) {
                disabled = this.setBlockForGeneration(world, species, pos, dir, this.careful);
            }
            ++codePos;
        }
        return codePos;
    }

    protected boolean setBlockForGeneration(World world, Species species, BlockPos pos, EnumFacing dir, boolean careful) {
        if (world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && (!careful || this.isClearOfNearbyBranches(world, pos, dir.func_176734_d()))) {
            species.getFamily().getDynamicBranch().setRadius(world, pos, (int)species.getFamily().getPrimaryThickness(), null, careful ? 3 : 2);
            return false;
        }
        return true;
    }

    protected void smother(SimpleVoxmap leafMap, ILeavesProperties leavesProperties) {
        int smotherMax = leavesProperties.getSmotherLeavesMax();
        if (smotherMax != 0) {
            BlockPos saveCenter = leafMap.getCenter();
            leafMap.setCenter(new BlockPos(0, 0, 0));
            for (int startY = leafMap.getLenY() - 1; startY >= 0 && !leafMap.isYTouched(startY); --startY) {
            }
            for (int iz = 0; iz < leafMap.getLenZ(); ++iz) {
                for (int ix = 0; ix < leafMap.getLenX(); ++ix) {
                    int count = 0;
                    for (int iy = startY; iy >= 0; --iy) {
                        byte v = leafMap.getVoxel(new BlockPos(ix, iy, iz));
                        if (v == 0) {
                            count = 0;
                            continue;
                        }
                        if ((v & 0xF) != 0) {
                            if (++count <= smotherMax) continue;
                            leafMap.setVoxel(new BlockPos(ix, iy, iz), (byte)0);
                            continue;
                        }
                        if ((v & 0x10) == 0) continue;
                        ++count;
                        leafMap.setVoxel(new BlockPos(ix, iy + 1, iz), (byte)4);
                    }
                }
            }
            leafMap.setCenter(saveCenter);
        }
    }

    protected boolean isClearOfNearbyBranches(World world, BlockPos pos, EnumFacing except) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir == except || TreeHelper.getBranch(world.func_180495_p(pos.func_177972_a(dir))) == null) continue;
            return false;
        }
        return true;
    }

    protected void addSnow(SimpleVoxmap leafMap, World world, BlockPos rootPos, Biome biome) {
        if (biome.func_185353_n() < 0.4f) {
            block0: for (BlockPos.MutableBlockPos top : leafMap.getTops()) {
                if (!world.func_175708_f((BlockPos)top, false)) continue;
                BlockPos.MutableBlockPos iPos = new BlockPos.MutableBlockPos((BlockPos)top);
                int yOffset = 0;
                do {
                    IBlockState state;
                    if ((state = world.func_180495_p((BlockPos)iPos)).func_185904_a() == Material.field_151579_a) {
                        world.func_180501_a((BlockPos)iPos, ModBlocks.blockStates.snowLayer.get(), 2);
                        continue block0;
                    }
                    if (state.func_177230_c() == ModBlocks.blockLeavesSnow.get() || state.func_177230_c() == Blocks.field_150431_aC) continue block0;
                    iPos.func_185336_p(iPos.func_177956_o() + 1);
                } while (yOffset++ < 4);
            }
        }
    }

    public static String encode(byte[] array) {
        ArrayList<Byte> instructions = new ArrayList<Byte>(array.length + (array.length & 1));
        for (byte b : array) {
            instructions.add(b);
        }
        if ((instructions.size() & 1) == 1) {
            instructions.add((byte)7);
        }
        String code = "";
        for (int b = 0; b < instructions.size(); b += 2) {
            code = code + base64.charAt((Byte)instructions.get(b) << 3 | (Byte)instructions.get(b + 1));
        }
        return code;
    }

    public static byte[] decode(String code) {
        return new CodeCompiler(code).compile();
    }

    public String toString() {
        return JoCode.encode(this.instructions);
    }

    public static class CodeCompiler {
        ArrayList<Byte> instructions;

        public CodeCompiler() {
            this.instructions = new ArrayList();
        }

        public CodeCompiler(int size) {
            this.instructions = new ArrayList(size);
        }

        public CodeCompiler(String code) {
            this.instructions = new ArrayList(code.length() * 2);
            for (int i = 0; i < code.length(); ++i) {
                int sixbits = JoCode.base64.indexOf(code.charAt(i));
                if (sixbits == -1) continue;
                this.addInstruction((byte)(sixbits >> 3));
                this.addInstruction((byte)(sixbits & 7));
            }
        }

        public void addDirection(byte dir) {
            if (dir >= 0) {
                this.instructions.add((byte)(dir & 7));
            }
        }

        public void addInstruction(byte instruction) {
            this.instructions.add(instruction);
        }

        public void addReturn() {
            this.instructions.add((byte)7);
        }

        public void addFork() {
            this.instructions.add((byte)6);
        }

        public byte[] compile() {
            byte[] array = new byte[this.instructions.size()];
            Iterator<Byte> i = this.instructions.iterator();
            int pos = 0;
            while (i.hasNext()) {
                array[pos++] = i.next();
            }
            return array;
        }
    }
}

