/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client.condition;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.multipart.ConditionPropertyValue;

public class FoamyConditionPropertyValue
extends ConditionPropertyValue {
    private static final Splitter SPLITTER = Splitter.on((char)'|').omitEmptyStrings();

    public FoamyConditionPropertyValue(String keyIn, String valueIn) {
        super(keyIn, valueIn);
    }

    public Predicate<IBlockState> func_188118_a(BlockStateContainer blockState) {
        List valueNames;
        boolean negate;
        IProperty property = blockState.func_185920_a(this.field_188125_d);
        if (property == null) {
            throw new RuntimeException(this.toString() + ": Definition: " + blockState + " has no property: " + this.field_188125_d);
        }
        String s = this.field_188126_e;
        boolean bl = negate = !s.isEmpty() && s.charAt(0) == '!';
        if (negate) {
            s = s.substring(1);
        }
        if ((valueNames = SPLITTER.splitToList((CharSequence)s)).isEmpty()) {
            throw new RuntimeException(this.toString() + ": has an empty value: " + this.field_188126_e);
        }
        Object[] values = new Object[valueNames.size()];
        for (int i = 0; i < values.length; ++i) {
            Optional valueParsed = property.func_185929_b((String)valueNames.get(i));
            if (!valueParsed.isPresent()) {
                throw new RuntimeException(this.toString() + ": has an unknown value: " + this.field_188126_e);
            }
            values[i] = valueParsed.get();
        }
        if (negate) {
            return values.length > 1 ? new PredicateNegative(property, values) : new SingletonPredicateNegative(property, values[0]);
        }
        return values.length > 1 ? new PredicatePositive(property, values) : new SingletonPredicatePositive(property, values[0]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FoamyConditionPropertyValue)) {
            return false;
        }
        FoamyConditionPropertyValue other = (FoamyConditionPropertyValue)((Object)obj);
        return other.field_188125_d.equals(this.field_188125_d) && other.field_188126_e.equals(this.field_188126_e);
    }

    public int hashCode() {
        return 31 * this.field_188125_d.hashCode() + this.field_188126_e.hashCode();
    }

    public static final class SingletonPredicateNegative
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object value;

        protected SingletonPredicateNegative(IProperty<?> property, Object value) {
            this.property = property;
            this.value = value;
        }

        public boolean apply(@Nullable IBlockState state) {
            return state == null || !state.func_177229_b(this.property).equals(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingletonPredicateNegative that = (SingletonPredicateNegative)o;
            return this.property == that.property && this.value == that.value;
        }

        public int hashCode() {
            return 31 * this.property.hashCode() + (this.value != null ? this.value.hashCode() : 0);
        }
    }

    public static final class SingletonPredicatePositive
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object value;

        protected SingletonPredicatePositive(IProperty<?> property, Object value) {
            this.property = property;
            this.value = value;
        }

        public boolean apply(@Nullable IBlockState state) {
            return state != null && state.func_177229_b(this.property).equals(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingletonPredicatePositive that = (SingletonPredicatePositive)o;
            return this.property == that.property && this.value == that.value;
        }

        public int hashCode() {
            return 31 * this.property.hashCode() + (this.value != null ? this.value.hashCode() : 0);
        }
    }

    public static final class PredicatePositive
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object[] values;

        protected PredicatePositive(IProperty<?> property, Object[] values) {
            this.property = property;
            this.values = values;
        }

        public boolean apply(@Nullable IBlockState state) {
            if (state != null) {
                Comparable value = state.func_177229_b(this.property);
                for (int i = 0; i < this.values.length; ++i) {
                    if (!value.equals(this.values[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicatePositive that = (PredicatePositive)o;
            if (this.property == that.property) {
                if (this.values.length != that.values.length) {
                    return false;
                }
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] == that.values[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.property.hashCode() + Arrays.hashCode(this.values);
        }
    }

    public static final class PredicateNegative
    implements Predicate<IBlockState> {
        private final IProperty<?> property;
        private final Object[] values;

        protected PredicateNegative(IProperty<?> property, Object[] values) {
            this.property = property;
            this.values = values;
        }

        public boolean apply(@Nullable IBlockState state) {
            if (state != null) {
                Comparable value = state.func_177229_b(this.property);
                for (int i = 0; i < this.values.length; ++i) {
                    if (!value.equals(this.values[i])) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredicateNegative that = (PredicateNegative)o;
            if (this.property == that.property) {
                if (this.values.length != that.values.length) {
                    return false;
                }
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] == that.values[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.property.hashCode() + Arrays.hashCode(this.values);
        }
    }
}

