/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.client.deduplicator;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.MultipartBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import pl.asie.foamfix.FoamFix;
import pl.asie.foamfix.client.FoamyMultipartBakedModel;
import pl.asie.foamfix.client.deduplicator.Deduplicator;
import pl.asie.foamfix.shared.FoamFixShared;
import pl.asie.foamfix.util.MethodHandleHelper;

public final class FoamFixModelDeduplicate {
    public static final FoamFixModelDeduplicate INSTANCE = new FoamFixModelDeduplicate();

    private FoamFixModelDeduplicate() {
    }

    private void debugCountModels(ModelBakeEvent event) {
        ArrayList<String> bmNames = new ArrayList<String>();
        TObjectIntHashMap bmCountMod = new TObjectIntHashMap();
        TObjectIntHashMap bmCountVariant = new TObjectIntHashMap();
        for (ModelResourceLocation loc : event.getModelRegistry().func_148742_b()) {
            bmNames.add(loc.toString());
            bmCountMod.adjustOrPutValue((Object)loc.func_110624_b(), 1, 1);
            bmCountVariant.adjustOrPutValue((Object)(loc.func_110624_b() + ":" + loc.func_110623_a()), 1, 1);
        }
        ArrayList<Object> bmCountModKeys = new ArrayList<Object>(bmCountMod.keySet());
        ArrayList<Object> bmCountVariantKeys = new ArrayList<Object>(bmCountVariant.keySet());
        bmNames.sort(Comparator.naturalOrder());
        bmCountModKeys.sort(Comparator.comparingInt(arg_0 -> ((TObjectIntMap)bmCountMod).get(arg_0)).reversed());
        bmCountVariantKeys.sort(Comparator.comparingInt(arg_0 -> ((TObjectIntMap)bmCountVariant).get(arg_0)).reversed());
        try {
            File outFile = new File("foamfixBakedModelNames.txt");
            PrintWriter writer = new PrintWriter(outFile);
            for (String string : bmNames) {
                writer.println(string);
            }
            writer.close();
            outFile = new File("foamfixBakedModelCountsPerMod.txt");
            writer = new PrintWriter(outFile);
            for (String string : bmCountModKeys) {
                writer.println(string + ": " + bmCountMod.get((Object)string));
            }
            writer.close();
            outFile = new File("foamfixBakedModelCountsPerBlock.txt");
            writer = new PrintWriter(outFile);
            for (String string : bmCountVariantKeys) {
                writer.println(string + ": " + bmCountVariant.get((Object)string));
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onModelBake(ModelBakeEvent event) {
        Map cache;
        if (FoamFixShared.config.dbgCountModels) {
            this.debugCountModels(event);
        }
        try {
            cache = MethodHandleHelper.findFieldGetter(ModelLoaderRegistry.class, "cache").invoke();
        }
        catch (Throwable t) {
            t.printStackTrace();
            cache = Collections.emptyMap();
        }
        if (FoamFixShared.config.clWipeModelCache) {
            int itemsCleared = 0;
            FoamFix.getLogger().info("Clearing ModelLoaderRegistry cache (" + cache.size() + " items)...");
            int cacheSize = cache.size();
            cache.entrySet().removeIf(e -> {
                ResourceLocation r = (ResourceLocation)e.getKey();
                if ("minecraft".equals(r.func_110624_b()) || "fml".equals(r.func_110624_b()) || "forge".equals(r.func_110624_b())) {
                    if (r.func_110623_a().endsWith("/generated")) {
                        return false;
                    }
                    return !r.func_110623_a().startsWith("builtin/");
                }
                return true;
            });
            FoamFix.getLogger().info("Cleared " + (itemsCleared += cacheSize - cache.size()) + " objects.");
            cache = Collections.emptyMap();
        }
        if (FoamFixShared.config.geDeduplicate || FoamFixShared.config.clDeduplicateModels) {
            Deduplicator deduplicator = new Deduplicator();
            deduplicator.maxRecursion = FoamFixShared.config.clDeduplicateRecursionLevel;
            deduplicator.addResourceLocation(ForgeRegistries.BLOCKS.getKeys());
            deduplicator.addResourceLocation(ForgeRegistries.ITEMS.getKeys());
            if (FoamFixShared.config.geDeduplicate) {
                block27: {
                    FoamFix.getLogger().info("Deduplicating...");
                    try {
                        if (cache == null) break block27;
                        int bakeBarLength = 2;
                        if (FoamFixShared.config.clDeduplicateIModels) {
                            bakeBarLength += cache.size();
                        }
                        ProgressManager.ProgressBar bakeBar = ProgressManager.push((String)"FoamFix: deduplicating", (int)bakeBarLength);
                        try {
                            bakeBar.step("Vertex formats");
                            for (Field field : DefaultVertexFormats.class.getDeclaredFields()) {
                                if (field.getType() != VertexFormat.class) continue;
                                field.setAccessible(true);
                                deduplicator.deduplicateObject(field.get(null), 0);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (FoamFixShared.config.clDeduplicateIModels) {
                            for (ResourceLocation loc : cache.keySet()) {
                                IModel model = (IModel)cache.get(loc);
                                String string = loc.toString();
                                bakeBar.step(String.format("[%s]", string));
                                try {
                                    deduplicator.addResourceLocation(loc);
                                    deduplicator.deduplicateObject(model, 0);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        try {
                            bakeBar.step("Stats");
                            for (Field field : StatList.class.getDeclaredFields()) {
                                if (field.getType() != StatBase[].class) continue;
                                field.setAccessible(true);
                                for (StatBase statBase : (StatBase[])field.get(null)) {
                                    deduplicator.deduplicateObject(statBase, 0);
                                }
                            }
                            for (StatBase statBase : StatList.field_75940_b) {
                                deduplicator.deduplicateObject(statBase, 0);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ProgressManager.pop((ProgressManager.ProgressBar)bakeBar);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (FoamFixShared.config.clDeduplicateModels) {
                    int stepCounter = 0;
                    int stepEvery = FoamFixShared.config.clDeduplicateStepEvery;
                    int stepCount = (event.getModelRegistry().func_148742_b().size() + (stepEvery - 1)) / stepEvery;
                    ProgressManager.ProgressBar bakeBar = ProgressManager.push((String)"FoamFix: deduplicating", (int)stepCount);
                    deduplicator.maxRecursion = FoamFixShared.config.clDeduplicateRecursionLevel;
                    FoamFix.getLogger().info("Deduplicating models...");
                    for (ModelResourceLocation modelResourceLocation : event.getModelRegistry().func_148742_b()) {
                        IBakedModel model = (IBakedModel)event.getModelRegistry().func_82594_a((Object)modelResourceLocation);
                        String modelName = modelResourceLocation.toString();
                        if (stepEvery == 1 || stepCounter % stepEvery == 0) {
                            bakeBar.step(modelName);
                        }
                        ++stepCounter;
                        if (model.getClass() == MultipartBakedModel.class) {
                            ++deduplicator.successfuls;
                            model = new FoamyMultipartBakedModel((MultipartBakedModel)model);
                        }
                        try {
                            deduplicator.addResourceLocation(modelResourceLocation);
                            event.getModelRegistry().func_82595_a((Object)modelResourceLocation, (Object)((IBakedModel)deduplicator.deduplicateObject(model, 0)));
                        }
                        catch (Exception exception) {}
                    }
                    ProgressManager.pop((ProgressManager.ProgressBar)bakeBar);
                    FoamFix.getLogger().info("Deduplicated " + deduplicator.successfuls + " (+ " + deduplicator.successfulTrims + ") objects.");
                }
            }
        }
    }
}

