/*
 * Decompiled with CFR 0.152.
 */
package dttraverse;

import com.ferreusveritas.dynamictrees.ModItems;
import com.ferreusveritas.dynamictrees.ModRecipes;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.client.ModelHelper;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDataBasePopulator;
import com.ferreusveritas.dynamictrees.blocks.LeavesPaging;
import com.ferreusveritas.dynamictrees.blocks.LeavesProperties;
import com.ferreusveritas.dynamictrees.items.DendroPotion;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import dttraverse.trees.SpeciesAutumnBrown;
import dttraverse.trees.SpeciesAutumnOrange;
import dttraverse.trees.SpeciesAutumnRed;
import dttraverse.trees.SpeciesAutumnYellow;
import dttraverse.trees.SpeciesMiniJungle;
import dttraverse.trees.SpeciesOakShrub;
import dttraverse.trees.TreeFir;
import dttraverse.worldgen.BiomeDataBasePopulator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import prospector.traverse.init.TraverseBlocks;

@Mod.EventBusSubscriber(modid="dttraverse")
public final class ModContent {
    public static ILeavesProperties firLeavesProperties;
    public static ILeavesProperties autumnYellowLeavesProperties;
    public static ILeavesProperties autumnOrangeLeavesProperties;
    public static ILeavesProperties autumnRedLeavesProperties;
    public static ILeavesProperties autumnBrownLeavesProperties;
    public static final ArrayList<TreeFamily> TREES;
    public static final ArrayList<Species> SPECIES;

    @SubscribeEvent
    public static void registerDataBasePopulators(WorldGenRegistry.BiomeDataBasePopulatorRegistryEvent event) {
        event.register((IBiomeDataBasePopulator)new BiomeDataBasePopulator());
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        TreeFamily oakTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "oak")).getFamily();
        TreeFamily birchTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "birch")).getFamily();
        TreeFamily jungleTree = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dynamictrees", "jungle")).getFamily();
        firLeavesProperties = ModContent.setUpLeaves((Block)TraverseBlocks.blocks.get("fir_leaves"), "conifer", 5);
        autumnBrownLeavesProperties = ModContent.setUpLeaves((Block)TraverseBlocks.blocks.get("brown_autumnal_leaves"), "deciduous", 1);
        autumnOrangeLeavesProperties = ModContent.setUpLeaves((Block)TraverseBlocks.blocks.get("orange_autumnal_leaves"), "deciduous", 4);
        autumnRedLeavesProperties = ModContent.setUpLeaves((Block)TraverseBlocks.blocks.get("red_autumnal_leaves"), "deciduous", 4);
        autumnYellowLeavesProperties = ModContent.setUpLeaves((Block)TraverseBlocks.blocks.get("yellow_autumnal_leaves"), "deciduous", 4);
        LeavesPaging.getLeavesBlockForSequence((String)"dttraverse", (int)0, (ILeavesProperties)firLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dttraverse", (int)4, (ILeavesProperties)autumnYellowLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dttraverse", (int)8, (ILeavesProperties)autumnOrangeLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dttraverse", (int)12, (ILeavesProperties)autumnRedLeavesProperties);
        LeavesPaging.getLeavesBlockForSequence((String)"dttraverse", (int)16, (ILeavesProperties)autumnBrownLeavesProperties);
        SPECIES.addAll(Arrays.asList(new Species[]{new SpeciesAutumnYellow(birchTree), new SpeciesAutumnOrange(oakTree), new SpeciesAutumnRed(oakTree), new SpeciesAutumnBrown(oakTree), new SpeciesMiniJungle(jungleTree), new SpeciesOakShrub(oakTree)}));
        SPECIES.forEach(arg_0 -> ((IForgeRegistry)Species.REGISTRY).register(arg_0));
        TreeFir firTree = new TreeFir();
        Collections.addAll(TREES, new TreeFamily[]{firTree});
        TREES.forEach(tree -> tree.registerSpecies(Species.REGISTRY));
        ArrayList treeBlocks = new ArrayList();
        TREES.forEach(tree -> tree.getRegisterableBlocks((List)treeBlocks));
        treeBlocks.addAll(LeavesPaging.getLeavesMapForModId((String)"dttraverse").values());
        registry.registerAll((IForgeRegistryEntry[])treeBlocks.toArray(new Block[treeBlocks.size()]));
    }

    public static ILeavesProperties setUpLeaves(final Block primitiveLeavesBlock, String cellKit, final int smotherLeavesMax) {
        return new LeavesProperties(primitiveLeavesBlock.func_176223_P(), new ItemStack(primitiveLeavesBlock, 1, 0), TreeRegistry.findCellKit((String)cellKit)){

            public ItemStack getPrimitiveLeavesItemStack() {
                return new ItemStack(primitiveLeavesBlock, 1, 0);
            }

            public int getSmotherLeavesMax() {
                return smotherLeavesMax;
            }

            public int getLightRequirement() {
                return 1;
            }
        };
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        SPECIES.forEach(species -> {
            if (species.getFamily().getCommonSpecies().getSeed() != species.getSeed()) {
                registry.register((IForgeRegistryEntry)species.getSeed());
            }
        });
        ArrayList treeItems = new ArrayList();
        TREES.forEach(tree -> tree.getRegisterableItems((List)treeItems));
        registry.registerAll((IForgeRegistryEntry[])treeItems.toArray(new Item[treeItems.size()]));
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        ModContent.setupRecipes("fir", "fir_sapling");
        ModContent.setupRecipes("autumn_yellow", "yellow_autumnal_sapling");
        ModContent.setupRecipes("autumn_orange", "orange_autumnal_sapling");
        ModContent.setupRecipes("autumn_red", "red_autumnal_sapling");
        ModContent.setupRecipes("autumn_red", "red_brown_sapling");
    }

    public static void setupRecipes(String species, String sapling) {
        Species specie = TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", species));
        ItemStack seed = specie.getSeedStack(1);
        ItemStack transofrmationPotion = ModItems.dendroPotion.setTargetTree(new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), specie.getFamily());
        BrewingRecipeRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.dendroPotion, 1, DendroPotion.DendroPotionType.TRANSFORM.getIndex()), (ItemStack)seed, (ItemStack)transofrmationPotion);
        ModRecipes.createDirtBucketExchangeRecipes((ItemStack)new ItemStack((Block)TraverseBlocks.blocks.get(sapling)), (ItemStack)seed, (boolean)true);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (TreeFamily tree : TREES) {
            ModelHelper.regModel((Block)tree.getDynamicBranch());
            ModelHelper.regModel((Item)tree.getCommonSpecies().getSeed());
            ModelHelper.regModel((TreeFamily)tree);
        }
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_yellow")).getSeed());
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_orange")).getSeed());
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_red")).getSeed());
        ModelHelper.regModel((Item)TreeRegistry.findSpecies((ResourceLocation)new ResourceLocation("dttraverse", "autumn_brown")).getSeed());
        LeavesPaging.getLeavesMapForModId((String)"dttraverse").forEach((key, leaves) -> ModelLoader.setCustomStateMapper((Block)leaves, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLeaves.field_176237_a}).func_178441_a()));
    }

    static {
        TREES = new ArrayList();
        SPECIES = new ArrayList();
    }
}

