/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.util;

import com.yungnickyoung.minecraft.bettercaves.config.Configuration;
import java.util.function.Predicate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;

public class BetterCavesUtils {
    private BetterCavesUtils() {
    }

    public static int getSurfaceAltitudeForColumn(ChunkPrimer primer, int localX, int localZ) {
        return BetterCavesUtils.searchSurfaceAltitudeInRangeForColumn(primer, localX, localZ, 255, 0);
    }

    public static int searchSurfaceAltitudeInRangeForColumn(ChunkPrimer primer, int localX, int localZ, int topY, int bottomY) {
        if (topY == 255 && primer.func_177856_a(localX, 255, localZ) != Blocks.field_150350_a.func_176223_P() && primer.func_177856_a(localX, 255, localZ).func_185904_a() != Material.field_151586_h) {
            return 255;
        }
        for (int y = bottomY; y <= topY; ++y) {
            IBlockState blockState = primer.func_177856_a(localX, y, localZ);
            if (blockState != Blocks.field_150350_a.func_176223_P() && blockState.func_185904_a() != Material.field_151586_h) continue;
            return y;
        }
        return 1;
    }

    public static String dimensionAsString(int dimensionID, String dimensionName) {
        return String.format("%d (%s)", dimensionID, dimensionName);
    }

    public static int getLocal(int coordinate) {
        return coordinate & 0xF;
    }

    public static boolean isDimensionWhitelisted(int dimID) {
        if (Configuration.enableGlobalWhitelist) {
            return true;
        }
        for (int dim : Configuration.whitelistedDimensionIDs) {
            if (dimID != dim) continue;
            return true;
        }
        return false;
    }

    public static float biomeDistanceFactor(World world, BlockPos pos, int radius, Predicate<Biome> isTargetBiome) {
        BlockPos.MutableBlockPos checkpos = new BlockPos.MutableBlockPos();
        for (int i = 1; i <= radius; ++i) {
            for (int j = 0; j <= i; ++j) {
                for (EnumFacing direction : EnumFacing.Plane.HORIZONTAL) {
                    checkpos.func_189533_g((Vec3i)pos).func_189534_c(direction, i).func_189534_c(direction.func_176746_e(), j);
                    if (isTargetBiome.test(world.func_180494_b((BlockPos)checkpos))) {
                        return (float)(i + j) / (float)(2 * radius);
                    }
                    if (j == 0 || i == j) continue;
                    checkpos.func_189533_g((Vec3i)pos).func_189534_c(direction, i).func_189534_c(direction.func_176735_f(), j);
                    if (!isTargetBiome.test(world.func_180494_b((BlockPos)checkpos))) continue;
                    return (float)(i + j) / (float)(2 * radius);
                }
            }
        }
        return 1.0f;
    }
}

