/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.util.BoxUtil;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.storage.loot.LootTableList;

public class ZombieVillagerRoom
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 7;
    private static final int Y_AXIS_LEN = 5;
    private static final int MAIN_AXIS_LEN = 7;
    private static final int LOCAL_X_END = 6;
    private static final int LOCAL_Y_END = 4;
    private static final int LOCAL_Z_END = 6;

    public ZombieVillagerRoom() {
    }

    public ZombieVillagerRoom(int i, int chunkPieceLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, chunkPieceLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = BoxUtil.boxFromCoordsWithRotation(x, y, z, 7, 5, 7, direction);
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 6, 6)) {
            return false;
        }
        this.fill(world, box, 1, 0, 0, 5, 2, 0, Blocks.field_150348_b.func_176223_P());
        this.fill(world, box, 0, 0, 1, 0, 2, 5, Blocks.field_150348_b.func_176223_P());
        this.fill(world, box, 6, 0, 1, 6, 2, 5, Blocks.field_150348_b.func_176223_P());
        this.fill(world, box, 1, 0, 6, 5, 2, 6, Blocks.field_150348_b.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 1, 0, 0, 5, 2, 0, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 0, 0, 1, 0, 2, 5, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 6, 0, 1, 6, 2, 5, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.4f, 1, 0, 6, 5, 2, 6, Blocks.field_150347_e.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 1, 0, 0, 5, 2, 0, Blocks.field_150417_aV.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 0, 0, 1, 0, 2, 5, Blocks.field_150417_aV.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 6, 0, 1, 6, 2, 5, Blocks.field_150417_aV.func_176223_P());
        this.chanceReplaceNonAir(world, box, random, 0.1f, 1, 0, 6, 5, 2, 6, Blocks.field_150417_aV.func_176223_P());
        this.fill(world, box, 2, 3, 0, 4, 3, 0, Blocks.field_150333_U.func_176223_P());
        this.fill(world, box, 0, 3, 2, 0, 3, 4, Blocks.field_150333_U.func_176223_P());
        this.fill(world, box, 6, 3, 2, 6, 3, 4, Blocks.field_150333_U.func_176223_P());
        this.fill(world, box, 2, 3, 6, 4, 3, 6, Blocks.field_150333_U.func_176223_P());
        this.chanceFill(world, box, random, 0.5f, 2, 3, 0, 4, 3, 0, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        this.chanceFill(world, box, random, 0.5f, 0, 3, 2, 0, 3, 4, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        this.chanceFill(world, box, random, 0.5f, 6, 3, 2, 6, 3, 4, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        this.chanceFill(world, box, random, 0.5f, 2, 3, 6, 4, 3, 6, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        this.fill(world, box, 2, 3, 1, 4, 3, 1, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        this.fill(world, box, 1, 3, 2, 1, 3, 4, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        this.fill(world, box, 2, 3, 5, 4, 3, 5, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        this.fill(world, box, 5, 3, 2, 5, 3, 4, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP));
        this.func_175811_a(world, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_RIGHT).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), 1, 3, 1, box);
        this.func_175811_a(world, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 1, 3, 5, box);
        this.func_175811_a(world, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_LEFT).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH), 5, 3, 1, box);
        this.func_175811_a(world, Blocks.field_150446_ar.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.INNER_RIGHT).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH), 5, 3, 5, box);
        this.fill(world, box, 2, 4, 2, 4, 4, 4, Blocks.field_150333_U.func_176223_P());
        this.chanceFill(world, box, random, 0.5f, 2, 4, 2, 4, 4, 4, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.COBBLESTONE));
        this.func_175811_a(world, AIR, 3, 4, 3, box);
        this.func_175811_a(world, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), 3, 4, 3, box);
        this.fill(world, box, 1, 0, 1, 5, 0, 5, Blocks.field_150348_b.func_176223_P());
        this.chanceFill(world, box, random, 0.4f, 1, 0, 1, 5, 0, 5, Blocks.field_150347_e.func_176223_P());
        this.chanceFill(world, box, random, 0.1f, 1, 0, 1, 5, 0, 5, Blocks.field_150417_aV.func_176223_P());
        this.fill(world, box, 1, 1, 1, 5, 2, 5, AIR);
        this.fill(world, box, 2, 3, 2, 4, 3, 4, AIR);
        this.fill(world, box, 3, 1, 0, 3, 2, 0, AIR);
        this.func_175811_a(world, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER), 3, 1, 0, box);
        this.func_175811_a(world, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 3, 2, 0, box);
        this.fill(world, box, 6, 2, 2, 6, 2, 4, Blocks.field_150411_aY.func_176223_P());
        this.func_175811_a(world, Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 1, 1, 4, box);
        this.func_175811_a(world, Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 1, 1, 5, box);
        TileEntity blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(1, 4), this.func_74862_a(1), this.func_74873_b(1, 4)));
        if (blockEntity instanceof TileEntityBed) {
            ((TileEntityBed)blockEntity).func_193052_a(EnumDyeColor.BLACK);
        }
        if ((blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(1, 5), this.func_74862_a(1), this.func_74873_b(1, 5)))) instanceof TileEntityBed) {
            ((TileEntityBed)blockEntity).func_193052_a(EnumDyeColor.BLACK);
        }
        this.func_175811_a(world, Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 5, 1, 4, box);
        this.func_175811_a(world, Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD), 5, 1, 5, box);
        blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(5, 4), this.func_74862_a(1), this.func_74873_b(5, 4)));
        if (blockEntity instanceof TileEntityBed) {
            ((TileEntityBed)blockEntity).func_193052_a(EnumDyeColor.BLACK);
        }
        if ((blockEntity = world.func_175625_s(new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) instanceof TileEntityBed) {
            ((TileEntityBed)blockEntity).func_193052_a(EnumDyeColor.BLACK);
        }
        BlockPos spawnerPos = new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(0), this.func_74873_b(3, 3));
        world.func_180501_a(spawnerPos, Blocks.field_150474_ac.func_176223_P(), 2);
        blockEntity = world.func_175625_s(spawnerPos);
        if (blockEntity instanceof TileEntityMobSpawner) {
            ((TileEntityMobSpawner)blockEntity).func_145881_a().func_190894_a(new ResourceLocation("zombie_villager"));
        }
        this.func_175811_a(world, Blocks.field_150463_bK.func_176223_P(), 1, 1, 1, box);
        this.func_175811_a(world, Blocks.field_150429_aA.func_176223_P(), 1, 2, 1, box);
        this.func_186167_a(world, box, random, 5, 1, 1, LootTableList.field_186424_f);
        this.func_175811_a(world, Blocks.field_150430_aB.func_176223_P(), 2, 2, 1, box);
        this.func_175811_a(world, Blocks.field_150467_bQ.func_176223_P(), 5, 1, 2, box);
        if (random.nextFloat() < 0.33f) {
            this.func_175811_a(world, Blocks.field_150342_X.func_176223_P(), 2, 1, 5, box);
        } else if (random.nextFloat() < 0.67f) {
            this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), 2, 1, 5, box);
        } else {
            this.func_175811_a(world, Blocks.field_150460_al.func_176223_P(), 2, 1, 5, box);
        }
        this.chanceFill(world, box, random, 0.3f, 2, 3, 2, 4, 3, 4, Blocks.field_150321_G.func_176223_P());
        return true;
    }
}

