/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.commands;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api.questing.IQuestLineEntry;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import bq_standard.tasks.TaskAdvancement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.server.MinecraftServer;

public class AdvancementDump {
    public static final AdvancementDump INSTANCE = new AdvancementDump();
    private HashMap<Advancement, DBEntry<IQuest>> idMap = new HashMap();

    public void dumpAdvancements(MinecraftServer server) {
        this.idMap.clear();
        IQuestDatabase questDB = (IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB);
        IQuestLineDatabase lineDB = (IQuestLineDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.LINE_DB);
        ArrayList<Advancement> roots = new ArrayList<Advancement>();
        for (Advancement advancement : server.func_191949_aK().func_192780_b()) {
            if (advancement.func_192068_c() == null) continue;
            int id = questDB.nextID();
            IQuest quest = questDB.createNew(id);
            IDatabaseNBT taskDB = quest.getTasks();
            DisplayInfo disp = advancement.func_192068_c();
            if (advancement.func_192070_b() == null) {
                roots.add(advancement);
                if (advancement.func_192073_f().isEmpty()) {
                    quest.setProperty(NativeProps.SILENT, (Object)true);
                }
            }
            quest.setProperty(NativeProps.NAME, (Object)disp.func_192297_a().func_150254_d());
            quest.setProperty(NativeProps.DESC, (Object)disp.func_193222_b().func_150254_d());
            quest.setProperty(NativeProps.ICON, (Object)new BigItemStack(disp.func_192298_b()));
            quest.setProperty(NativeProps.SILENT, (Object)true);
            quest.setProperty(NativeProps.VISIBILITY, (Object)(disp.func_193224_j() || advancement.func_192070_b() == null ? EnumQuestVisibility.COMPLETED : EnumQuestVisibility.UNLOCKED));
            quest.setProperty(NativeProps.MAIN, (Object)(disp.func_192291_d() == FrameType.GOAL ? 1 : 0));
            TaskAdvancement task = new TaskAdvancement();
            task.advID = advancement.func_192067_g();
            taskDB.add(taskDB.nextID(), (Object)task);
            this.idMap.put(advancement, (DBEntry<IQuest>)new DBEntry(id, (Object)quest));
        }
        for (Map.Entry entry : this.idMap.entrySet()) {
            Advancement parent;
            DBEntry<IQuest> pq;
            if (((Advancement)entry.getKey()).func_192070_b() == null || (pq = this.idMap.get(parent = ((Advancement)entry.getKey()).func_192070_b())) == null) continue;
            this.addReq((IQuest)((DBEntry)entry.getValue()).getValue(), pq.getID());
        }
        for (Advancement advancement : roots) {
            IQuestLine ql = lineDB.createNew(lineDB.nextID());
            ql.setProperty(NativeProps.NAME, (Object)advancement.func_192068_c().func_192297_a().func_150254_d());
            ql.setProperty(NativeProps.DESC, (Object)advancement.func_192068_c().func_193222_b().func_150254_d());
            IQuestLineEntry qleRoot = ql.createNew(this.idMap.get(advancement).getID());
            qleRoot.setPosition((int)(advancement.func_192068_c().func_192299_e() * 32.0f), (int)(advancement.func_192068_c().func_192296_f() * 32.0f));
            qleRoot.setSize(24, 24);
            ArrayDeque iterStack = new ArrayDeque();
            iterStack.add(advancement.func_192069_e().iterator());
            while (!iterStack.isEmpty()) {
                Iterator iter = (Iterator)iterStack.poll();
                while (iter.hasNext()) {
                    Advancement child = (Advancement)iter.next();
                    IQuestLineEntry qle = ql.createNew(this.idMap.get(child).getID());
                    qle.setPosition((int)(child.func_192068_c().func_192299_e() * 32.0f), (int)(child.func_192068_c().func_192296_f() * 32.0f));
                    qle.setSize(24, 24);
                    iterStack.add(child.func_192069_e().iterator());
                }
            }
        }
    }

    private boolean containsReq(IQuest quest, int id) {
        for (int reqID : quest.getRequirements()) {
            if (id != reqID) continue;
            return true;
        }
        return false;
    }

    private boolean addReq(IQuest quest, int id) {
        if (this.containsReq(quest, id)) {
            return false;
        }
        int[] orig = quest.getRequirements();
        int[] added = Arrays.copyOf(orig, orig.length + 1);
        added[orig.length] = id;
        quest.setRequirements(added);
        return true;
    }
}

