/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.rewards;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.JsonHelper;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.NBTReplaceUtil;
import bq_standard.client.gui.rewards.PanelRewardChoice;
import bq_standard.core.BQ_Standard;
import bq_standard.rewards.factory.FactoryRewardChoice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class RewardChoice
implements IReward {
    public final ArrayList<BigItemStack> choices = new ArrayList();
    private final HashMap<UUID, Integer> selected = new HashMap();

    public ResourceLocation getFactoryID() {
        return FactoryRewardChoice.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.reward.choice";
    }

    public int getSelecton(UUID uuid) {
        if (!this.selected.containsKey(uuid)) {
            return -1;
        }
        return this.selected.get(uuid);
    }

    public void setSelection(UUID uuid, int value) {
        this.selected.put(uuid, value);
    }

    public boolean canClaim(EntityPlayer player, DBEntry<IQuest> quest) {
        if (!this.selected.containsKey(QuestingAPI.getQuestingUUID((EntityPlayer)player))) {
            return false;
        }
        int tmp = this.selected.get(QuestingAPI.getQuestingUUID((EntityPlayer)player));
        return this.choices.size() <= 0 || tmp >= 0 && tmp < this.choices.size();
    }

    public void claimReward(EntityPlayer player, DBEntry<IQuest> quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.choices.size() <= 0) {
            return;
        }
        if (!this.selected.containsKey(playerID)) {
            return;
        }
        int tmp = this.selected.get(playerID);
        if (tmp < 0 || tmp >= this.choices.size()) {
            BQ_Standard.logger.log(Level.ERROR, "Choice reward was forcibly claimed with invalid choice", (Throwable)new IllegalStateException());
            return;
        }
        BigItemStack stack = this.choices.get(tmp);
        BigItemStack bigItemStack = stack = stack == null ? null : stack.copy();
        if (stack == null || stack.stackSize <= 0) {
            BQ_Standard.logger.log(Level.WARN, "Claimed reward choice was null or was 0 in size!");
            return;
        }
        for (ItemStack s : stack.getCombinedStacks()) {
            if (s.func_77978_p() != null) {
                s.func_77982_d(NBTReplaceUtil.replaceStrings(s.func_77978_p(), "VAR_NAME", player.func_70005_c_()));
                s.func_77982_d(NBTReplaceUtil.replaceStrings(s.func_77978_p(), "VAR_UUID", QuestingAPI.getQuestingUUID((EntityPlayer)player).toString()));
            }
            if (player.field_71071_by.func_70441_a(s)) continue;
            player.func_146097_a(s, true, false);
        }
    }

    public void readFromNBT(NBTTagCompound json) {
        this.choices.clear();
        NBTTagList cList = json.func_150295_c("choices", 10);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            this.choices.add(JsonHelper.JsonToItemStack((NBTTagCompound)cList.func_150305_b(i)));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        NBTTagList rJson = new NBTTagList();
        for (BigItemStack stack : this.choices) {
            rJson.func_74742_a((NBTBase)JsonHelper.ItemStackToJson((BigItemStack)stack, (NBTTagCompound)new NBTTagCompound()));
        }
        json.func_74782_a("choices", (NBTBase)rJson);
        return json;
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getRewardGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelRewardChoice(rect, quest, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getRewardEditor(GuiScreen screen, DBEntry<IQuest> quest) {
        return null;
    }
}

